/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.io;

import fr.ens.biologie.genomique.kenetre.bio.io.CountsWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class TSVCountsWriter
implements CountsWriter {
    private final OutputStream os;

    @Override
    public void write(Map<String, Integer> counts) throws IOException {
        Objects.requireNonNull(counts, "counts argument cannot be null");
        try (OutputStreamWriter writer = new OutputStreamWriter(this.os);){
            ArrayList<String> keysSorted = new ArrayList<String>(counts.keySet());
            Collections.sort(keysSorted);
            writer.write("Id\tCount\n");
            for (String key : keysSorted) {
                writer.write(key + "\t" + counts.get(key) + "\n");
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }

    public TSVCountsWriter(OutputStream os) throws FileNotFoundException {
        Objects.requireNonNull(os, "os argument cannot be null");
        this.os = os;
    }

    public TSVCountsWriter(File outputFile) throws IOException {
        Objects.requireNonNull(outputFile, "outputFile argument cannot be null");
        this.os = new FileOutputStream(outputFile);
    }

    public TSVCountsWriter(String outputFilename) throws IOException {
        Objects.requireNonNull(outputFilename, "outputFilename argument cannot be null");
        this.os = new FileOutputStream(outputFilename);
    }
}

