/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.io;

import fr.ens.biologie.genomique.kenetre.bio.ExpressionMatrix;
import fr.ens.biologie.genomique.kenetre.bio.io.ExpressionMatrixWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Objects;

public class TSVExpressionMatrixWriter
implements ExpressionMatrixWriter {
    private final OutputStream os;

    @Override
    public void write(ExpressionMatrix matrix) throws IOException {
        Objects.requireNonNull(matrix, "matrix argument cannot be null");
        this.write(matrix, matrix.getRowNames());
    }

    @Override
    public void write(ExpressionMatrix matrix, Collection<String> rowNamesToWrite) throws IOException {
        Objects.requireNonNull(matrix, "matrix argument cannot be null");
        Objects.requireNonNull(rowNamesToWrite, "rowNamesToWrite argument cannot be null");
        try (OutputStreamWriter writer = new OutputStreamWriter(this.os);){
            StringBuilder sb = new StringBuilder();
            for (String columnName : matrix.getColumnNames()) {
                sb.append('\t');
                sb.append(columnName);
            }
            sb.append('\n');
            writer.write(sb.toString());
            for (String rowName : rowNamesToWrite) {
                sb.setLength(0);
                sb.append(rowName);
                for (Double value : matrix.getRowValues(rowName)) {
                    sb.append('\t');
                    double d = value;
                    if (!Double.isNaN(d) && !Double.isInfinite(d) && Math.floor(d) - d == 0.0) {
                        sb.append((int)d);
                        continue;
                    }
                    sb.append(value);
                }
                sb.append('\n');
                writer.write(sb.toString());
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }

    public TSVExpressionMatrixWriter(OutputStream os) throws FileNotFoundException {
        Objects.requireNonNull(os, "os argument cannot be null");
        this.os = os;
    }

    public TSVExpressionMatrixWriter(File outputFile) throws IOException {
        Objects.requireNonNull(outputFile, "os argument cannot be null");
        this.os = new FileOutputStream(outputFile);
    }

    public TSVExpressionMatrixWriter(String outputFilename) throws IOException {
        Objects.requireNonNull(outputFilename, "os argument cannot be null");
        this.os = new FileOutputStream(outputFilename);
    }
}

