/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readfilter;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.AbstractReadFilter;
import org.usadellab.trimmomatic.fastq.FastqRecord;
import org.usadellab.trimmomatic.trim.AbstractSingleRecordTrimmer;

public abstract class AbstractTrimmomaticReadFilter
extends AbstractReadFilter {
    private AbstractSingleRecordTrimmer trimmer;

    @Override
    public String getDescription() {
        return this.getName() + " Trimmomatic filter";
    }

    @Override
    public void setParameter(String key, String value) throws KenetreException {
        if ("arguments".equals(key)) {
            try {
                this.trimmer = this.createTrimmer(value == null ? "" : value);
            }
            catch (Exception e) {
                throw new KenetreException("Invalid parameter: " + value, (Throwable)e);
            }
        } else {
            throw new KenetreException("Unknown parameter for " + this.getName() + " read filter: " + key);
        }
    }

    @Override
    public void init() {
        if (this.trimmer == null) {
            this.trimmer = this.createTrimmer("");
        }
    }

    protected abstract AbstractSingleRecordTrimmer createTrimmer(String var1);

    @Override
    public boolean accept(ReadSequence read) {
        if (read == null) {
            return false;
        }
        FastqRecord in = new FastqRecord(read.getName(), read.getSequence(), "", read.getQuality(), read.getFastqFormat().getAsciiOffset());
        FastqRecord out = this.trimmer.processRecord(in);
        if (out == null) {
            return false;
        }
        read.setSequence(out.getSequence());
        read.setQuality(out.getQuality());
        return true;
    }
}

