/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readfilter;

import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.AbstractReadFilter;

public class GGGHeadReadFilter
extends AbstractReadFilter {
    public static final String FILTER_NAME = "ggghead";
    private static final int ADDITIONAL_BASE_COUNT = 3;

    @Override
    public String getName() {
        return FILTER_NAME;
    }

    @Override
    public String getDescription() {
        return "GGG head identifier";
    }

    @Override
    public boolean accept(ReadSequence read) {
        String sequence = read.getSequence();
        int length = read.length();
        String start = sequence.substring(0, Math.min(3, length));
        String end = sequence.substring(Math.max(length - 3, 0));
        read.setName(read.getName() + " start_sequence=" + start + " start_G_count=" + GGGHeadReadFilter.count(start, 'G') + " end_sequence=" + end + " end_C_count=" + GGGHeadReadFilter.count(end, 'C'));
        return true;
    }

    private static int count(String s, char c) {
        int result = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++result;
        }
        return result;
    }
}

