/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readfilter;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.AbstractReadFilter;

public class LengthReadFilter
extends AbstractReadFilter {
    public static final String FILTER_NAME = "length";
    private int minimalLengthThreshold;

    @Override
    public boolean accept(ReadSequence read) {
        if (read == null) {
            return false;
        }
        return read.length() > this.minimalLengthThreshold;
    }

    @Override
    public String getName() {
        return FILTER_NAME;
    }

    @Override
    public String getDescription() {
        return "Length ReadFilter";
    }

    @Override
    public void setParameter(String key, String value) throws KenetreException {
        if (key == null || value == null) {
            return;
        }
        if ("minimal.length.threshold".equals(key.trim())) {
            try {
                this.minimalLengthThreshold = Integer.parseInt(value.trim());
            }
            catch (NumberFormatException e) {
                return;
            }
            if (this.minimalLengthThreshold < 1) {
                throw new KenetreException("Invalid length threshold: " + this.minimalLengthThreshold);
            }
        } else {
            throw new KenetreException("Unknown parameter for " + this.getName() + " read filter: " + key);
        }
    }

    @Override
    public void init() {
        if (this.minimalLengthThreshold < 1) {
            throw new IllegalArgumentException("Minimal length threshold is not set for " + this.getName() + " read filter.");
        }
    }
}

