/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readfilter;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.AbstractReadFilter;

public class MaxLengthReadFilter
extends AbstractReadFilter {
    public static final String FILTER_NAME = "maxlength";
    private int maximumLengthThreshold;

    @Override
    public boolean accept(ReadSequence read) {
        if (read == null) {
            return false;
        }
        return read.length() < this.maximumLengthThreshold;
    }

    @Override
    public String getName() {
        return FILTER_NAME;
    }

    @Override
    public String getDescription() {
        return "Max Length ReadFilter";
    }

    @Override
    public void setParameter(String key, String value) throws KenetreException {
        if (key == null || value == null) {
            return;
        }
        if ("maximum.length.threshold".equals(key.trim())) {
            try {
                this.maximumLengthThreshold = Integer.parseInt(value.trim());
            }
            catch (NumberFormatException e) {
                return;
            }
            if (this.maximumLengthThreshold < 1) {
                throw new KenetreException("Invalid length threshold: " + this.maximumLengthThreshold);
            }
        } else {
            throw new KenetreException("Unknown parameter for " + this.getName() + " read filter: " + key);
        }
    }

    @Override
    public void init() {
        if (this.maximumLengthThreshold < 1) {
            throw new IllegalArgumentException("Maximum length threshold is not set for " + this.getName() + " read filter.");
        }
    }
}

