/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readfilter;

import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.NanoporeReadId;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.AbstractReadFilter;
import java.util.Iterator;

public class NanoporeSequenceTypeFilter
extends AbstractReadFilter {
    public static final String FILTER_NAME = "nanoporesequencetype";
    private final Splitter spliter = Splitter.on((char)' ').omitEmptyStrings();
    private NanoporeReadId.SequenceType sequenceType = NanoporeReadId.SequenceType.CONSENSUS;

    @Override
    public String getName() {
        return FILTER_NAME;
    }

    @Override
    public String getDescription() {
        return "Filter nanopore reads against its type";
    }

    @Override
    public boolean accept(ReadSequence read) {
        if (read == null) {
            return false;
        }
        Iterator it = this.spliter.split((CharSequence)read.getName()).iterator();
        if (!it.hasNext()) {
            return false;
        }
        String sequenceName = (String)it.next();
        switch (this.sequenceType) {
            case CONSENSUS: {
                return sequenceName.indexOf(95) == -1;
            }
            case TEMPLATE: {
                return sequenceName.endsWith("_t");
            }
            case COMPLEMENT: {
                return sequenceName.endsWith("_c");
            }
        }
        return false;
    }

    @Override
    public void setParameter(String key, String value) throws KenetreException {
        NanoporeReadId.SequenceType type;
        if (key == null || value == null) {
            return;
        }
        if ("keep".equals(key.trim())) {
            try {
                type = NanoporeReadId.SequenceType.valueOf(value.toUpperCase().trim());
            }
            catch (IllegalArgumentException e) {
                throw new KenetreException("Invalid sequence type: " + value);
            }
        } else {
            throw new KenetreException("Unknown parameter for " + this.getName() + " read filter: " + key);
        }
        this.sequenceType = type;
    }
}

