/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readfilter;

import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.AbstractReadFilter;

public class PairCheckReadFilter
extends AbstractReadFilter {
    @Override
    public boolean accept(ReadSequence read1, ReadSequence read2) {
        int len2;
        if (read1 == null) {
            return false;
        }
        if (read2 == null) {
            return false;
        }
        String id1 = read1.getName();
        String id2 = read2.getName();
        if (id1 == null) {
            return false;
        }
        if (id2 == null) {
            return false;
        }
        if (id1.equals(id2)) {
            return false;
        }
        int len1 = id1.length();
        if (len1 != (len2 = id2.length())) {
            return false;
        }
        if (!id1.endsWith("/1")) {
            return false;
        }
        if (!id2.endsWith("/2")) {
            return false;
        }
        int len = len1 - 2;
        String prefix1 = id1.substring(0, len);
        String prefix2 = id2.substring(0, len);
        return prefix1.equals(prefix2);
    }

    @Override
    public boolean accept(ReadSequence read) {
        return read != null;
    }

    @Override
    public String getName() {
        return "paircheck";
    }

    @Override
    public String getDescription() {
        return "Pair check read filter";
    }

    @Override
    public void setParameter(String key, String value) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{}";
    }
}

