/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readfilter;

import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.AbstractReadFilter;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.PolyATailReadFilter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class RemoveInvalidPolyAReadFilter
extends AbstractReadFilter {
    public static final String FILTER_NAME = "removeinvalidpolya";
    private Splitter splitter = Splitter.on((char)' ').omitEmptyStrings().trimResults();
    private Set<String> allowed = new HashSet<String>(Arrays.asList("polya", "polyt"));

    @Override
    public String getName() {
        return FILTER_NAME;
    }

    @Override
    public String getDescription() {
        return "PolyA invalid type filter";
    }

    @Override
    public void setParameter(String key, String value) throws KenetreException {
        switch (key) {
            case "allowed.tail.type": {
                this.allowed.clear();
                for (String type : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)value.toLowerCase())) {
                    PolyATailReadFilter.TailType t = PolyATailReadFilter.TailType.parse(type);
                    if (t == null) {
                        throw new KenetreException("Unknown value for " + this.getName() + "." + key + " parameter: " + type);
                    }
                    this.allowed.add(t.toString().toLowerCase());
                }
                break;
            }
            default: {
                throw new KenetreException("Unknown parameter for " + this.getName() + " read filter: " + key);
            }
        }
    }

    @Override
    public boolean accept(ReadSequence read) {
        String readName = read.getName();
        for (String s : this.splitter.splitToList((CharSequence)readName)) {
            if (!(s = s.toLowerCase().replace("\"", "").replace(" ", "")).startsWith("tail_type=") || !this.allowed.contains(s = s.substring(s.indexOf(61) + 1))) continue;
            return true;
        }
        return false;
    }
}

