/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readfilter;

import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.AbstractReadFilter;
import java.util.regex.Pattern;

public class TrimPolyNEndReadFilter
extends AbstractReadFilter {
    public static final String FILTER_NAME = "trimpolynend";
    private static final Pattern PATTERN = Pattern.compile("NN+$");

    @Override
    public boolean accept(ReadSequence read) {
        if (read == null) {
            return false;
        }
        TrimPolyNEndReadFilter.trim(read);
        return read.length() != 0;
    }

    public static void trim(ReadSequence read) {
        if (read == null || read.getSequence() == null || read.getQuality() == null || read.getSequence().length() != read.getQuality().length() || read.getSequence().length() == 0) {
            return;
        }
        String[] splitResult = PATTERN.split(read.getSequence());
        if (splitResult == null || splitResult.length == 0) {
            read.setSequence("");
            read.setQuality("");
            return;
        }
        ReadSequence tmp = read.subSequence(0, splitResult[0].length());
        read.setSequence(tmp.getSequence());
        read.setQuality(tmp.getQuality());
    }

    @Override
    public String getName() {
        return FILTER_NAME;
    }

    @Override
    public String getDescription() {
        return "Trim polyN ends";
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{}";
    }
}

