/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.io;

import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import fr.ens.biologie.genomique.kenetre.util.SystemUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public enum CompressionType {
    GZIP("gzip", ".gz"),
    BZIP2("bzip2", ".bz2"),
    NONE("", "");

    private final String contentEncoding;
    private final String extension;

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getExtension() {
        return this.extension;
    }

    public boolean isCompressed() {
        return this != NONE;
    }

    public InputStream createInputStream(InputStream is) throws IOException {
        if (is == null) {
            return null;
        }
        switch (this) {
            case GZIP: {
                return CompressionType.createGZipInputStream(is);
            }
            case BZIP2: {
                return CompressionType.createBZip2InputStream(is);
            }
            case NONE: {
                return is;
            }
        }
        return null;
    }

    public OutputStream createOutputStream(OutputStream os) throws IOException {
        if (os == null) {
            return null;
        }
        switch (this) {
            case GZIP: {
                return CompressionType.createGZipOutputStream(os);
            }
            case BZIP2: {
                return CompressionType.createBZip2OutputStream(os);
            }
            case NONE: {
                return os;
            }
        }
        return null;
    }

    public static CompressionType getCompressionTypeByContentEncoding(String contentType) {
        if (contentType == null) {
            return null;
        }
        for (CompressionType ct : CompressionType.values()) {
            if (!contentType.equals(ct.contentEncoding)) continue;
            return ct;
        }
        return NONE;
    }

    public static CompressionType getCompressionTypeByExtension(String extension) {
        if (extension == null) {
            return null;
        }
        for (CompressionType ct : CompressionType.values()) {
            if (!extension.toLowerCase().equals(ct.extension)) continue;
            return ct;
        }
        return NONE;
    }

    public static CompressionType getCompressionTypeByFilename(String filename) {
        if (filename == null) {
            return null;
        }
        return CompressionType.getCompressionTypeByExtension(StringUtils.extension(filename));
    }

    public static InputStream createGZipInputStream(InputStream is) throws IOException {
        return new GZIPInputStream(is);
    }

    public static InputStream createBZip2InputStream(InputStream is) throws IOException {
        if (SystemUtils.isClass("org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream")) {
            return CompressionType.createBZip2InputStreamWithCommonCompress(is);
        }
        if (SystemUtils.isClass("org.apache.hadoop.io.compress.BZip2Codec")) {
            return CompressionType.createBZip2InputStreamWithHadoopLib(is);
        }
        throw new IOException("Unable to find a class to create a BZip2InputStream.");
    }

    public static OutputStream createGZipOutputStream(OutputStream os) throws IOException {
        return new GZIPOutputStream(os);
    }

    public static OutputStream createBZip2OutputStream(OutputStream os) throws IOException {
        if (SystemUtils.isClass("org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream")) {
            return CompressionType.createBZip2OutputStreamWithCommonCompress(os);
        }
        if (SystemUtils.isClass("org.apache.hadoop.io.compress.BZip2Codec")) {
            return CompressionType.createBZip2OutputStreamWithHadoopLib(os);
        }
        throw new IOException("Unable to find a class to create a BZip2InputStream.");
    }

    public static String removeCompressionExtension(String s) {
        if (s == null) {
            return null;
        }
        for (CompressionType ct : CompressionType.values()) {
            if (ct == NONE || !s.endsWith(ct.getExtension())) continue;
            return s.substring(0, s.length() - ct.getExtension().length());
        }
        return s;
    }

    private static InputStream createBZip2InputStreamWithHadoopLib(InputStream is) throws IOException {
        Objects.requireNonNull(is);
        try {
            Object instance = SystemUtils.class.getClassLoader().loadClass("org.apache.hadoop.io.compress.BZip2Codec").newInstance();
            Method m = instance.getClass().getMethod("createInputStream", InputStream.class);
            return (InputStream)m.invoke(instance, is);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return null;
        }
    }

    private static OutputStream createBZip2OutputStreamWithHadoopLib(OutputStream os) throws IOException {
        Objects.requireNonNull(os);
        try {
            Object instance = SystemUtils.class.getClassLoader().loadClass("org.apache.hadoop.io.compress.BZip2Codec").newInstance();
            Method m = instance.getClass().getMethod("createOutputStream", OutputStream.class);
            return (OutputStream)m.invoke(instance, os);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return null;
        }
    }

    private static InputStream createBZip2InputStreamWithCommonCompress(InputStream is) throws IOException {
        Objects.requireNonNull(is);
        try {
            Constructor<?> c = SystemUtils.class.getClassLoader().loadClass("org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream").getConstructor(InputStream.class);
            c.setAccessible(true);
            return (InputStream)c.newInstance(is);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return null;
        }
    }

    private static OutputStream createBZip2OutputStreamWithCommonCompress(OutputStream os) throws IOException {
        Objects.requireNonNull(os);
        try {
            Constructor<?> c = SystemUtils.class.getClassLoader().loadClass("org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream").getConstructor(OutputStream.class);
            c.setAccessible(true);
            return (OutputStream)c.newInstance(os);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return null;
        }
    }

    private CompressionType(String contentEncoding, String extension) {
        this.contentEncoding = contentEncoding;
        this.extension = extension;
    }
}

