/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.util;

import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.util.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class ServiceListLoader {
    private static final String PREFIX = "META-INF/services/";
    private final String serviceName;
    private final ClassLoader loader;

    private List<Entry> getServiceEntries() throws IOException {
        String fullName = PREFIX + this.serviceName;
        Enumeration<URL> urls = this.loader == null ? ClassLoader.getSystemResources(fullName) : this.loader.getResources(fullName);
        ArrayList<Entry> result = new ArrayList<Entry>();
        for (URL url : Utils.newIterable(urls)) {
            this.parse(url, result);
        }
        return result;
    }

    private void parse(URL url, List<Entry> result) throws IOException {
        String line;
        InputStream is = url.openStream();
        BufferedReader reader = FileUtils.createBufferedReader(is);
        int lineNumber = 0;
        while ((line = reader.readLine()) != null) {
            ++lineNumber;
            String trimLine = line.trim();
            if ("".equals(trimLine) || trimLine.startsWith("#")) continue;
            result.add(new Entry(url, lineNumber, trimLine));
        }
        is.close();
    }

    public static List<String> load(String serviceName) throws IOException {
        return ServiceListLoader.load(serviceName, null);
    }

    public static List<String> load(String serviceName, ClassLoader loader) throws IOException {
        List<Entry> entries = ServiceListLoader.loadEntries(serviceName, loader);
        ArrayList<String> result = new ArrayList<String>(entries.size());
        for (Entry e : entries) {
            result.add(e.getValue());
        }
        return result;
    }

    public static List<Entry> loadEntries(String serviceName) throws IOException {
        return ServiceListLoader.loadEntries(serviceName, null);
    }

    public static List<Entry> loadEntries(String serviceName, ClassLoader loader) throws IOException {
        return new ServiceListLoader(serviceName, loader).getServiceEntries();
    }

    private ServiceListLoader(String serviceName, ClassLoader loader) {
        if (serviceName == null) {
            throw new NullPointerException("The service name is null");
        }
        this.loader = loader == null ? this.getClass().getClassLoader() : loader;
        this.serviceName = serviceName;
    }

    public static final class Entry {
        private final URL url;
        private final int lineNumber;
        private final String value;

        public URL getUrl() {
            return this.url;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{url=" + this.url + ", lineNumber=" + this.lineNumber + ", value=" + this.value;
        }

        private Entry(URL url, int lineNumber, String value) {
            this.url = url;
            this.lineNumber = lineNumber;
            this.value = value;
        }
    }
}

