/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.util;

import java.util.Arrays;

public final class StatUtils {
    public static double mean(int[] values) {
        if (values == null) {
            throw new IllegalArgumentException("input value array is null");
        }
        int len = values.length;
        int sum = 0;
        for (int value : values) {
            sum += value;
        }
        return (double)sum / (double)len;
    }

    public static double mean(double[] values) {
        if (values == null) {
            throw new IllegalArgumentException("input value array is null");
        }
        int len = values.length;
        double sum = 0.0;
        for (double value : values) {
            sum += value;
        }
        return sum / (double)len;
    }

    public static double median(int[] values) {
        return StatUtils.percentile(values, 50.0);
    }

    public static double median(double[] values) {
        return StatUtils.percentile(values, 50.0);
    }

    public static double percentile(int[] values, double p) {
        if (values == null) {
            throw new IllegalArgumentException("values is null");
        }
        return StatUtils.percentile(values, 0, values.length, p);
    }

    public static double percentile(double[] values, double p) {
        if (values == null) {
            throw new IllegalArgumentException("values is null");
        }
        return StatUtils.percentile(values, 0, values.length, p);
    }

    private static double percentile(int[] values, int begin, int length, double p) {
        StatUtils.test(values, begin, length);
        if (p > 100.0 || p <= 0.0) {
            throw new IllegalArgumentException("invalid quantile value: " + p);
        }
        if (length == 0) {
            return Double.NaN;
        }
        if (length == 1) {
            return values[begin];
        }
        double pos = p * ((double)length + 1.0) / 100.0;
        double fpos = Math.floor(pos);
        int intPos = (int)fpos;
        double dif = pos - fpos;
        double[] sorted = new double[length];
        System.arraycopy(values, begin, sorted, 0, length);
        Arrays.sort(sorted);
        if (pos < 1.0) {
            return sorted[0];
        }
        if (pos >= (double)length) {
            return sorted[length - 1];
        }
        double lower = sorted[intPos - 1];
        double upper = sorted[intPos];
        return lower + dif * (upper - lower);
    }

    private static double percentile(double[] values, int begin, int length, double p) {
        StatUtils.test(values, begin, length);
        if (p > 100.0 || p <= 0.0) {
            throw new IllegalArgumentException("invalid quantile value: " + p);
        }
        if (length == 0) {
            return Double.NaN;
        }
        if (length == 1) {
            return values[begin];
        }
        double pos = p * ((double)length + 1.0) / 100.0;
        double fpos = Math.floor(pos);
        int intPos = (int)fpos;
        double dif = pos - fpos;
        double[] sorted = new double[length];
        System.arraycopy(values, begin, sorted, 0, length);
        Arrays.sort(sorted);
        if (pos < 1.0) {
            return sorted[0];
        }
        if (pos >= (double)length) {
            return sorted[length - 1];
        }
        double lower = sorted[intPos - 1];
        double upper = sorted[intPos];
        return lower + dif * (upper - lower);
    }

    private static boolean test(int[] values, int begin, int length) {
        if (values == null) {
            throw new IllegalArgumentException("input value array is null");
        }
        if (begin < 0) {
            throw new IllegalArgumentException("start position cannot be negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length cannot be negative");
        }
        if (begin + length > values.length) {
            throw new IllegalArgumentException("begin + length > values.length");
        }
        return length != 0;
    }

    private static boolean test(double[] values, int begin, int length) {
        if (values == null) {
            throw new IllegalArgumentException("input value array is null");
        }
        if (begin < 0) {
            throw new IllegalArgumentException("start position cannot be negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length cannot be negative");
        }
        if (begin + length > values.length) {
            throw new IllegalArgumentException("begin + length > values.length");
        }
        return length != 0;
    }
}

