/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.util;

import com.google.common.base.Splitter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public final class SystemUtils {
    private static final String HADOOP_CLASS_TO_TEST = "org.apache.hadoop.io.Text";

    public static String getHostName() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static String getIPAddr() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostAddress();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static boolean isMacOsX() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().startsWith("linux");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public static boolean isUnix() {
        return !SystemUtils.isWindows();
    }

    public static boolean isClass(String className) {
        if (className == null) {
            return false;
        }
        try {
            SystemUtils.class.getClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isHadoop() {
        return SystemUtils.isClass(HADOOP_CLASS_TO_TEST);
    }

    public static int getJavaVersion() {
        int pos1;
        String version = System.getProperty("java.version");
        int major = Integer.parseInt(version.substring(0, (pos1 = version.indexOf(46) + 1) - 1));
        if (major > 1) {
            return major;
        }
        int pos2 = version.indexOf(46, pos1);
        return Integer.parseInt(version.substring(pos1, pos2));
    }

    public static int uid() {
        try {
            return Integer.parseInt(SystemUtils.execToString("/usr/bin/id", "-u").replace("\n", "").trim());
        }
        catch (IOException | NumberFormatException e) {
            return -1;
        }
    }

    public static int gid() {
        try {
            return Integer.parseInt(SystemUtils.execToString("/usr/bin/id", "-g").replace("\n", "").trim());
        }
        catch (IOException | NumberFormatException e) {
            return -1;
        }
    }

    private static String execToString(String ... args) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(args);
        Process p = pb.start();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            StringBuilder result = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                result.append(line);
                result.append('\n');
            }
            reader.close();
            String string = result.toString();
            return string;
        }
    }

    public static File searchExecutableInPATH(String executableName) {
        if (executableName == null) {
            throw new NullPointerException("the executableName cannot be null");
        }
        String pathEnv = System.getenv().get("PATH");
        if (pathEnv == null) {
            return null;
        }
        for (String dirname : Splitter.on((char)File.pathSeparatorChar).split((CharSequence)pathEnv)) {
            File dir = new File(dirname);
            File file = new File(dir, executableName);
            if (!dir.isDirectory() || !file.exists() || !file.canExecute()) continue;
            return file;
        }
        return null;
    }

    public static boolean isActiveConnection(String hostname, int port, int timeout) {
        try {
            try (Socket soc = new Socket();){
                soc.connect(new InetSocketAddress(hostname, port), timeout);
            }
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private SystemUtils() {
    }
}

