/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.util.process;

import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import java.util.Set;

public final class ProcessUtils {
    private static Random random;

    public static void exec(String cmd, boolean stdOutput) throws IOException {
        ProcessUtils.exec(cmd, stdOutput, null);
    }

    public static void exec(String cmd, boolean stdOutput, GenericLogger logger) throws IOException {
        if (logger != null) {
            logger.debug("execute (Thread " + Thread.currentThread().getId() + "): " + cmd);
        }
        long startTime = System.currentTimeMillis();
        Process p = Runtime.getRuntime().exec(cmd);
        InputStream std = p.getInputStream();
        BufferedReader stdr = new BufferedReader(new InputStreamReader(std, Charset.defaultCharset()));
        String l = null;
        while ((l = stdr.readLine()) != null) {
            if (!stdOutput) continue;
            System.out.println(l);
        }
        InputStream err = p.getInputStream();
        BufferedReader errr = new BufferedReader(new InputStreamReader(err, Charset.defaultCharset()));
        String l2 = null;
        while ((l2 = errr.readLine()) != null) {
            System.err.println(l2);
        }
        stdr.close();
        errr.close();
        if (logger != null) {
            ProcessUtils.logEndTime(p, cmd, startTime, logger);
        }
    }

    public static void execWriteOutput(String cmd, File outputFile) throws IOException {
        ProcessUtils.execWriteOutput(cmd, outputFile, null);
    }

    public static void execWriteOutput(String cmd, File outputFile, GenericLogger logger) throws IOException {
        if (logger != null) {
            logger.debug("execute (Thread " + Thread.currentThread().getId() + "): " + cmd);
        }
        long startTime = System.currentTimeMillis();
        Process p = Runtime.getRuntime().exec(cmd);
        InputStream std = p.getInputStream();
        OutputStream fos = FileUtils.createOutputStream(outputFile);
        FileUtils.copy(std, fos);
        InputStream err = p.getInputStream();
        BufferedReader errr = new BufferedReader(new InputStreamReader(err, Charset.defaultCharset()));
        String l2 = null;
        while ((l2 = errr.readLine()) != null) {
            System.err.println(l2);
        }
        fos.close();
        errr.close();
        if (logger != null) {
            ProcessUtils.logEndTime(p, cmd, startTime, logger);
        }
    }

    public static String execToString(String cmd) throws IOException {
        return ProcessUtils.execToString(cmd, false, true);
    }

    public static String execToString(String cmd, boolean addStdErr, boolean checkExitCode) throws IOException {
        return ProcessUtils.execToString(cmd, addStdErr, checkExitCode, null);
    }

    public static String execToString(String cmd, boolean addStdErr, boolean checkExitCode, GenericLogger logger) throws IOException {
        if (logger != null) {
            logger.debug("execute (Thread " + Thread.currentThread().getId() + "): " + cmd);
        }
        long startTime = System.currentTimeMillis();
        Process p = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
        InputStream std = p.getInputStream();
        BufferedReader stdr = new BufferedReader(new InputStreamReader(std, Charset.defaultCharset()));
        StringBuilder sb = new StringBuilder();
        String l1 = null;
        while ((l1 = stdr.readLine()) != null) {
            sb.append(l1);
            sb.append('\n');
        }
        InputStream err = p.getErrorStream();
        BufferedReader errr = new BufferedReader(new InputStreamReader(err, Charset.defaultCharset()));
        String l2 = null;
        while ((l2 = errr.readLine()) != null) {
            if (addStdErr) {
                sb.append(l2);
                sb.append('\n');
                continue;
            }
            System.err.println(l2);
        }
        stdr.close();
        errr.close();
        if (checkExitCode && logger != null) {
            ProcessUtils.logEndTime(p, cmd, startTime, logger);
        }
        return sb.toString();
    }

    public static void logEndTime(Process p, String cmd, long startTime, GenericLogger logger) throws IOException {
        Objects.requireNonNull(logger);
        try {
            int exitValue = p.waitFor();
            long endTime = System.currentTimeMillis();
            ProcessUtils.throwExitCodeException(exitValue, cmd);
            logger.debug("Done (Thread " + Thread.currentThread().getId() + ", exit code: " + exitValue + ") in " + (endTime - startTime) + " ms.");
        }
        catch (InterruptedException e) {
            logger.error("Interrupted exception: " + e.getMessage());
        }
    }

    public static void throwExitCodeException(int exitCode, String command) throws IOException {
        switch (exitCode) {
            case 0: {
                return;
            }
            case 126: {
                throw new IOException("Command invoked cannot execute: " + command);
            }
            case 127: {
                throw new IOException("Command not found: " + command);
            }
            case 134: {
                throw new IOException("Abort: " + command);
            }
            case 139: {
                throw new IOException("Segmentation fault: " + command);
            }
        }
        throw new IOException("Error while executing (exit code " + exitCode + "): " + command);
    }

    public static Set<Integer> getExecutablePids(String executableName) {
        if (executableName == null) {
            return null;
        }
        HashSet<Integer> result = new HashSet<Integer>();
        try {
            String[] lines;
            String s = ProcessUtils.execToString("pgrep -x " + executableName.trim());
            for (String line : lines = s.split("\n")) {
                try {
                    result.add(Integer.parseInt(line));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        catch (IOException e) {
            return result;
        }
        return result;
    }

    public static void waitUntilExecutableRunning(String executableName) {
        if (executableName == null) {
            return;
        }
        Set<Integer> pids;
        while ((pids = ProcessUtils.getExecutablePids(executableName)).size() != 0) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }

    public static void waitRandom(int maxMilliseconds) {
        if (maxMilliseconds <= 0) {
            return;
        }
        if (random == null) {
            random = new Random(System.currentTimeMillis());
        }
        try {
            Thread.sleep(random.nextInt(maxMilliseconds));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private ProcessUtils() {
    }
}

