/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.analysis.AdapterUtility;
import picard.analysis.AlignmentSummaryMetricsCollector;
import picard.analysis.ChimeraUtil;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.argumentcollections.ReferenceArgumentCollection;
import picard.cmdline.programgroups.Metrics;

@CommandLineProgramProperties(summary="<b>Produces a summary of alignment metrics from a SAM or BAM file.</b>  This tool takes a SAM/BAM file input and produces metrics detailing the quality of the read alignments as well as the proportion of the reads that passed machine signal-to-noise threshold quality filters. Note that these quality filters are specific to Illumina data; for additional information, please see the corresponding <a href='https://www.broadinstitute.org/gatk/guide/article?id=6329'>GATK Dictionary entry</a>. </p><p>Note: Metrics labeled as percentages are actually expressed as fractions!</p><h4>Usage example:</h4><pre>    java -jar picard.jar CollectAlignmentSummaryMetrics \\<br />          R=reference_sequence.fasta \\<br />          I=input.bam \\<br />          O=output.txt</pre><p>Please see the CollectAlignmentSummaryMetrics <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#AlignmentSummaryMetrics'>definitions</a> for a complete description of the metrics produced by this tool.</p><hr />", oneLineSummary="<b>Produces a summary of alignment metrics from a SAM or BAM file.</b>  ", programGroup=Metrics.class)
@DocumentedFeature
public class CollectAlignmentSummaryMetrics
extends SinglePassSamProgram {
    static final String USAGE_SUMMARY = "<b>Produces a summary of alignment metrics from a SAM or BAM file.</b>  ";
    static final String USAGE_DETAILS = "This tool takes a SAM/BAM file input and produces metrics detailing the quality of the read alignments as well as the proportion of the reads that passed machine signal-to-noise threshold quality filters. Note that these quality filters are specific to Illumina data; for additional information, please see the corresponding <a href='https://www.broadinstitute.org/gatk/guide/article?id=6329'>GATK Dictionary entry</a>. </p><p>Note: Metrics labeled as percentages are actually expressed as fractions!</p><h4>Usage example:</h4><pre>    java -jar picard.jar CollectAlignmentSummaryMetrics \\<br />          R=reference_sequence.fasta \\<br />          I=input.bam \\<br />          O=output.txt</pre><p>Please see the CollectAlignmentSummaryMetrics <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#AlignmentSummaryMetrics'>definitions</a> for a complete description of the metrics produced by this tool.</p><hr />";
    private static final Log log = Log.getInstance(CollectAlignmentSummaryMetrics.class);
    @Argument(doc="Paired-end reads above this insert size will be considered chimeric along with inter-chromosomal pairs.")
    public int MAX_INSERT_SIZE = ChimeraUtil.DEFAULT_INSERT_SIZE_LIMIT;
    @Argument(doc="Paired-end reads that do not have this expected orientation will be considered chimeric.")
    public Set<SamPairUtil.PairOrientation> EXPECTED_PAIR_ORIENTATIONS = EnumSet.copyOf(ChimeraUtil.DEFAULT_EXPECTED_ORIENTATIONS);
    @Argument(doc="List of adapter sequences to use when processing the alignment metrics.")
    public List<String> ADAPTER_SEQUENCE = AdapterUtility.DEFAULT_ADAPTER_SEQUENCE;
    @Argument(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.")
    public Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet((Object[])new MetricAccumulationLevel[]{MetricAccumulationLevel.ALL_READS});
    @Argument(shortName="BS", doc="Whether the SAM or BAM file consists of bisulfite sequenced reads.")
    public boolean IS_BISULFITE_SEQUENCED = false;
    private AlignmentSummaryMetricsCollector collector;

    public static void main(String[] argv) {
        new CollectAlignmentSummaryMetrics().instanceMainWithExit(argv);
    }

    protected final int testDoWork() {
        return this.doWork();
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        if (header.getSequenceDictionary().isEmpty()) {
            log.warn(new Object[]{this.INPUT.getAbsoluteFile() + " has no sequence dictionary.  If any reads in the file are aligned, then alignment summary metrics collection will fail."});
        }
        boolean doRefMetrics = this.REFERENCE_SEQUENCE != null;
        this.collector = new AlignmentSummaryMetricsCollector(this.METRIC_ACCUMULATION_LEVEL, header.getReadGroups(), doRefMetrics, this.ADAPTER_SEQUENCE, this.MAX_INSERT_SIZE, this.EXPECTED_PAIR_ORIENTATIONS, this.IS_BISULFITE_SEQUENCED);
    }

    @Override
    protected void acceptRead(SAMRecord rec, ReferenceSequence ref) {
        this.collector.acceptRecord(rec, ref);
    }

    @Override
    protected void finish() {
        this.collector.finish();
        MetricsFile file = this.getMetricsFile();
        this.collector.addAllLevelsToFile(file);
        file.write(this.OUTPUT);
    }

    @Override
    protected ReferenceArgumentCollection makeReferenceArgumentCollection() {
        return new CollectAlignmentRefArgCollection();
    }

    public static class CollectAlignmentRefArgCollection
    implements ReferenceArgumentCollection {
        @Argument(shortName="R", doc="Reference sequence file. Note that while this argument isn't required, without it only a small subset of the metrics will be calculated. Note also that if a reference sequence is provided, it must be accompanied by a sequence dictionary.", optional=true)
        public File REFERENCE_SEQUENCE = Defaults.REFERENCE_FASTA;

        @Override
        public File getReferenceFile() {
            return this.REFERENCE_SEQUENCE;
        }
    }
}

