/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IntervalList;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.analysis.CollectWgsMetrics;
import picard.cmdline.programgroups.Metrics;

@CommandLineProgramProperties(summary="Collect whole genome sequencing-related metrics.  This tool computes metrics that are useful for evaluating coverage and performance of whole genome sequencing experiments. These metrics include the percentages of reads that pass minimal base- and mapping- quality filters as well as coverage (read-depth) levels. <br /><br />  The histogram output is optional and for a given run, displays two separate outputs on the y-axis while using a single set of values for the x-axis.  Specifically, the first column in the histogram table (x-axis) is labeled 'coverage' and represents different possible coverage depths.  However, it also represents the range of values for the base quality scores and thus should probably be labeled 'sequence depth and base quality scores'. The second and third columns (y-axes) correspond to the numbers of bases at a specific sequence depth 'count' and the numbers of bases at a particular base quality score 'baseq_count' respectively.<br /><br />Although similar to the CollectWgsMetrics tool, the default thresholds for CollectRawWgsMetrics are less stringent.  For example, the CollectRawWgsMetrics have base and mapping quality score thresholds set to '3' and '0' respectively, while the CollectWgsMetrics tool has the default threshold values set to '20' (at time of writing).  Nevertheless, both tools enable the user to input specific threshold values.<p>Note: Metrics labeled as percentages are actually expressed as fractions!</p><h4>Usage example:</h4><pre>java -jar picard.jar CollectRawWgsMetrics \\<br />      I=input.bam \\<br />      O=raw_wgs_metrics.txt \\<br />      R=reference_sequence.fasta \\<br />      INCLUDE_BQ_HISTOGRAM=true</pre><hr />Please see <a href='https://broadinstitute.github.io/picard/picard-metric-definitions.html#CollectWgsMetrics.WgsMetrics'>the WgsMetrics documentation</a> for detailed explanations of the output metrics.<hr />", oneLineSummary="Collect whole genome sequencing-related metrics.  ", programGroup=Metrics.class)
@DocumentedFeature
public class CollectRawWgsMetrics
extends CollectWgsMetrics {
    static final String USAGE_SUMMARY = "Collect whole genome sequencing-related metrics.  ";
    static final String USAGE_DETAILS = "This tool computes metrics that are useful for evaluating coverage and performance of whole genome sequencing experiments. These metrics include the percentages of reads that pass minimal base- and mapping- quality filters as well as coverage (read-depth) levels. <br /><br />  The histogram output is optional and for a given run, displays two separate outputs on the y-axis while using a single set of values for the x-axis.  Specifically, the first column in the histogram table (x-axis) is labeled 'coverage' and represents different possible coverage depths.  However, it also represents the range of values for the base quality scores and thus should probably be labeled 'sequence depth and base quality scores'. The second and third columns (y-axes) correspond to the numbers of bases at a specific sequence depth 'count' and the numbers of bases at a particular base quality score 'baseq_count' respectively.<br /><br />Although similar to the CollectWgsMetrics tool, the default thresholds for CollectRawWgsMetrics are less stringent.  For example, the CollectRawWgsMetrics have base and mapping quality score thresholds set to '3' and '0' respectively, while the CollectWgsMetrics tool has the default threshold values set to '20' (at time of writing).  Nevertheless, both tools enable the user to input specific threshold values.<p>Note: Metrics labeled as percentages are actually expressed as fractions!</p><h4>Usage example:</h4><pre>java -jar picard.jar CollectRawWgsMetrics \\<br />      I=input.bam \\<br />      O=raw_wgs_metrics.txt \\<br />      R=reference_sequence.fasta \\<br />      INCLUDE_BQ_HISTOGRAM=true</pre><hr />Please see <a href='https://broadinstitute.github.io/picard/picard-metric-definitions.html#CollectWgsMetrics.WgsMetrics'>the WgsMetrics documentation</a> for detailed explanations of the output metrics.<hr />";

    public CollectRawWgsMetrics() {
        this.MINIMUM_MAPPING_QUALITY = 0;
        this.MINIMUM_BASE_QUALITY = 3;
        this.COVERAGE_CAP = 100000;
        this.LOCUS_ACCUMULATION_CAP = 200000;
    }

    @Override
    protected CollectWgsMetrics.WgsMetrics generateWgsMetrics(IntervalList intervals, Histogram<Integer> highQualityDepthHistogram, Histogram<Integer> unfilteredDepthHistogram, double pctExcludedByMapq, double pctExcludedByDupes, double pctExcludedByPairing, double pctExcludedByBaseq, double pctExcludedByOverlap, double pctExcludedByCapping, double pctTotal, int coverageCap, Histogram<Integer> unfilteredBaseQHistogram, int sampleSize) {
        return new RawWgsMetrics(intervals, highQualityDepthHistogram, unfilteredDepthHistogram, pctExcludedByMapq, pctExcludedByDupes, pctExcludedByPairing, pctExcludedByBaseq, pctExcludedByOverlap, pctExcludedByCapping, pctTotal, coverageCap, unfilteredBaseQHistogram, sampleSize);
    }

    public static class RawWgsMetrics
    extends CollectWgsMetrics.WgsMetrics {
        public RawWgsMetrics() {
        }

        public RawWgsMetrics(IntervalList intervals, Histogram<Integer> highQualityDepthHistogram, Histogram<Integer> unfilteredDepthHistogram, double pctExcludedByMapq, double pctExcludedByDupes, double pctExcludedByPairing, double pctExcludedByBaseq, double pctExcludedByOverlap, double pctExcludedByCapping, double pctTotal, int coverageCap, Histogram<Integer> unfilteredBaseQHistogram, int sampleSize) {
            super(intervals, highQualityDepthHistogram, unfilteredDepthHistogram, pctExcludedByMapq, pctExcludedByDupes, pctExcludedByPairing, pctExcludedByBaseq, pctExcludedByOverlap, pctExcludedByCapping, pctTotal, coverageCap, unfilteredBaseQHistogram, sampleSize);
        }
    }
}

