/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.CollectionUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import picard.illumina.parser.TilePhasingValue;
import picard.illumina.parser.TileTemplateRead;

public class Tile {
    private final int lane;
    private final int tile;
    private final float density;
    private final float clusters;
    private final Map<TileTemplateRead, Float> phasingMap;
    private final Map<TileTemplateRead, Float> prePhasingMap;

    public Tile(int lane, int tile, float density, float clusters, TilePhasingValue ... tilePhasingValues) {
        this.lane = lane;
        this.tile = tile;
        this.density = density;
        this.clusters = clusters;
        Collection<TilePhasingValue> phasingValues = Tile.ensureSoleTilePhasingValuesPerRead(Arrays.asList(tilePhasingValues));
        EnumMap<TileTemplateRead, Float> phasingMap = new EnumMap<TileTemplateRead, Float>(TileTemplateRead.class);
        EnumMap<TileTemplateRead, Float> prePhasingMap = new EnumMap<TileTemplateRead, Float>(TileTemplateRead.class);
        for (TilePhasingValue phasingValue : phasingValues) {
            phasingMap.put(phasingValue.getTileTemplateRead(), Float.valueOf(phasingValue.getPhasingValue()));
            prePhasingMap.put(phasingValue.getTileTemplateRead(), Float.valueOf(phasingValue.getPrePhasingValue()));
        }
        this.phasingMap = Collections.unmodifiableMap(phasingMap);
        this.prePhasingMap = Collections.unmodifiableMap(prePhasingMap);
    }

    public int getLaneNumber() {
        return this.lane;
    }

    public int getTileNumber() {
        return this.tile;
    }

    public float getClusterDensity() {
        return this.density;
    }

    public float getClusterCount() {
        return this.clusters;
    }

    public Map<TileTemplateRead, Float> getPhasingMap() {
        return this.phasingMap;
    }

    public Map<TileTemplateRead, Float> getPrePhasingMap() {
        return this.prePhasingMap;
    }

    private static Collection<TilePhasingValue> ensureSoleTilePhasingValuesPerRead(Collection<TilePhasingValue> tilePhasingValues) {
        Map<TileTemplateRead, List<TilePhasingValue>> partitionedMap = tilePhasingValues.stream().collect(Collectors.groupingBy(TilePhasingValue::getTileTemplateRead));
        LinkedList<TilePhasingValue> newTilePhasingValues = new LinkedList<TilePhasingValue>();
        for (TileTemplateRead read : partitionedMap.keySet()) {
            newTilePhasingValues.add((TilePhasingValue)CollectionUtil.getSoleElement((Collection)partitionedMap.get((Object)read)));
        }
        return newTilePhasingValues;
    }
}

