/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser.readers;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import picard.PicardException;
import picard.illumina.parser.readers.BinaryFileIterator;
import picard.illumina.parser.readers.MMapBackedIteratorFactory;
import picard.util.UnsignedTypeUtil;

public class TileMetricsOutReader
implements Iterator<IlluminaTileMetrics> {
    private final BinaryFileIterator<ByteBuffer> bbIterator;
    private float density;
    private TileMetricsVersion version;

    public TileMetricsOutReader(File tileMetricsOutFile, TileMetricsVersion version) {
        this.bbIterator = MMapBackedIteratorFactory.getByteBufferIterator(version.headerSize, version.recordSize, tileMetricsOutFile);
        this.version = version;
        ByteBuffer header = this.bbIterator.getHeaderBytes();
        int actualVersion = UnsignedTypeUtil.uByteToInt(header.get());
        if (actualVersion != version.version) {
            throw new PicardException("TileMetricsOutReader expects the version number to be " + version.version + ".  Actual Version in Header( " + actualVersion + ")");
        }
        int actualRecordSize = UnsignedTypeUtil.uByteToInt(header.get());
        if (version.recordSize != actualRecordSize) {
            throw new PicardException("TileMetricsOutReader expects the record size to be " + version.recordSize + ".  Actual Record Size in Header( " + actualRecordSize + ")");
        }
        if (version == TileMetricsVersion.THREE) {
            this.density = UnsignedTypeUtil.uIntToFloat(header.getInt());
        }
    }

    @Override
    public boolean hasNext() {
        return this.bbIterator.hasNext();
    }

    @Override
    public IlluminaTileMetrics next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return new IlluminaTileMetrics(this.bbIterator.next(), this.version);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public float getDensity() {
        return this.density;
    }

    public static enum TileMetricsVersion {
        TWO(2, 2, 10),
        THREE(3, 6, 15);

        private final int version;
        private final int headerSize;
        private final int recordSize;

        private TileMetricsVersion(int version, int headerSize, int recordSize) {
            this.version = version;
            this.headerSize = headerSize;
            this.recordSize = recordSize;
        }
    }

    public static class IlluminaLaneTileCode {
        private final int laneNumber;
        private final int tileNumber;
        private final int metricCode;

        public IlluminaLaneTileCode(int laneNumber, int tileNumber, int metricCode) {
            this.laneNumber = laneNumber;
            this.tileNumber = tileNumber;
            this.metricCode = metricCode;
        }

        public int getLaneNumber() {
            return this.laneNumber;
        }

        public int getTileNumber() {
            return this.tileNumber;
        }

        public int getMetricCode() {
            return this.metricCode;
        }

        public boolean equals(Object o) {
            if (o instanceof IlluminaLaneTileCode) {
                IlluminaLaneTileCode that = (IlluminaLaneTileCode)o;
                return this.laneNumber == that.laneNumber && this.tileNumber == that.tileNumber && this.metricCode == that.metricCode;
            }
            return false;
        }

        public int hashCode() {
            int result = this.laneNumber;
            result = 31 * result + this.tileNumber;
            result = 31 * result + this.metricCode;
            return result;
        }
    }

    public static class IlluminaTileMetrics {
        private final IlluminaLaneTileCode laneTileCode;
        private final float metricValue;
        private float metricValue2;
        private byte type;

        public IlluminaTileMetrics(ByteBuffer bb, TileMetricsVersion version) {
            if (version == TileMetricsVersion.THREE) {
                this.laneTileCode = new IlluminaLaneTileCode(UnsignedTypeUtil.uShortToInt(bb.getShort()), bb.getInt(), 0);
                this.type = bb.get();
                this.metricValue = bb.getFloat();
                this.metricValue2 = bb.getFloat();
            } else {
                this.laneTileCode = new IlluminaLaneTileCode(UnsignedTypeUtil.uShortToInt(bb.getShort()), UnsignedTypeUtil.uShortToInt(bb.getShort()), UnsignedTypeUtil.uShortToInt(bb.getShort()));
                this.metricValue = bb.getFloat();
            }
        }

        public IlluminaTileMetrics(int laneNumber, int tileNumber, int metricCode, float metricValue) {
            this.laneTileCode = new IlluminaLaneTileCode(laneNumber, tileNumber, metricCode);
            this.metricValue = metricValue;
        }

        public int getLaneNumber() {
            return this.laneTileCode.getLaneNumber();
        }

        public int getTileNumber() {
            return this.laneTileCode.getTileNumber();
        }

        public int getMetricCode() {
            return this.laneTileCode.getMetricCode();
        }

        public float getMetricValue() {
            return this.metricValue;
        }

        public IlluminaLaneTileCode getLaneTileCode() {
            return this.laneTileCode;
        }

        public boolean equals(Object o) {
            if (o instanceof IlluminaTileMetrics) {
                IlluminaTileMetrics that = (IlluminaTileMetrics)o;
                return this.laneTileCode == that.laneTileCode && this.metricValue == that.metricValue;
            }
            return false;
        }

        public int hashCode() {
            return String.format("%s:%s:%s:%s", this.laneTileCode.getLaneNumber(), this.laneTileCode.getTileNumber(), this.laneTileCode.getMetricCode(), Float.valueOf(this.metricValue)).hashCode();
        }

        public boolean isClusterRecord() {
            return this.type == 116;
        }
    }
}

