/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BamFileIoUtils;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(summary="Concatenate one or more BAM files as efficiently as possibleThis tool performs a rapid \"gather\" operation on BAM files after scatter operations where the same process has been performed on different regions of a BAM file creating many smaller BAM files that now need to be concatenated (reassembled) back together.<br /><br />Assumes that the list of BAM files provided as INPUT are in the order that they should be concatenated and simply concatenates the bodies of the BAM files while retaining the header from the first file.  Operates via copying of the gzip blocks directly for speed but also supports generation of an MD5 on the output and indexing of the output BAM file. Only supports BAM files, does not support SAM files.<h4>Usage example:</h4><pre>java -jar picard.jar GatherBamFiles \\<br />      I=input1.bam \\ <br />      I=input2.bam \\ <br />      O=gathered_files.bam</pre> <hr />", oneLineSummary="Concatenate one or more BAM files as efficiently as possible", programGroup=SamOrBam.class)
@DocumentedFeature
public class GatherBamFiles
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Concatenate one or more BAM files as efficiently as possible";
    static final String USAGE_DETAILS = "This tool performs a rapid \"gather\" operation on BAM files after scatter operations where the same process has been performed on different regions of a BAM file creating many smaller BAM files that now need to be concatenated (reassembled) back together.<br /><br />Assumes that the list of BAM files provided as INPUT are in the order that they should be concatenated and simply concatenates the bodies of the BAM files while retaining the header from the first file.  Operates via copying of the gzip blocks directly for speed but also supports generation of an MD5 on the output and indexing of the output BAM file. Only supports BAM files, does not support SAM files.<h4>Usage example:</h4><pre>java -jar picard.jar GatherBamFiles \\<br />      I=input1.bam \\ <br />      I=input2.bam \\ <br />      O=gathered_files.bam</pre> <hr />";
    @Argument(shortName="I", doc="Two or more BAM files or text files containing lists of BAM files (one per line).")
    public List<File> INPUT;
    @Argument(shortName="O", doc="The output BAM file to write.")
    public File OUTPUT;
    private static final Log log = Log.getInstance(GatherBamFiles.class);

    public static void main(String[] args) {
        GatherBamFiles gatherer = new GatherBamFiles();
        gatherer.CREATE_INDEX = true;
        gatherer.instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        List inputs = IOUtil.unrollFiles(this.INPUT, (String[])new String[]{".bam", ".sam"});
        for (File f : inputs) {
            IOUtil.assertFileIsReadable((File)f);
        }
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        if (this.determineBlockCopyingStatus(inputs)) {
            BamFileIoUtils.gatherWithBlockCopying((List)inputs, (File)this.OUTPUT, (boolean)this.CREATE_INDEX, (boolean)this.CREATE_MD5_FILE);
        } else {
            GatherBamFiles.gatherNormally(inputs, this.OUTPUT, this.CREATE_INDEX, this.CREATE_MD5_FILE, this.REFERENCE_SEQUENCE);
        }
        return 0;
    }

    private boolean determineBlockCopyingStatus(List<File> inputs) {
        boolean useBlockCopying = true;
        for (File f : inputs) {
            if (BamFileIoUtils.isBamFile((File)f)) continue;
            useBlockCopying = false;
        }
        return useBlockCopying;
    }

    private static void gatherNormally(List<File> inputs, File output, boolean createIndex, boolean createMd5, File referenceFasta) {
        SAMFileHeader header = SamReaderFactory.makeDefault().referenceSequence(referenceFasta).getFileHeader(inputs.get(0));
        SAMFileWriter out = new SAMFileWriterFactory().setCreateIndex(createIndex).setCreateMd5File(createMd5).makeSAMOrBAMWriter(header, true, output);
        for (File f : inputs) {
            log.info(new Object[]{"Gathering " + f.getAbsolutePath()});
            SamReader in = SamReaderFactory.makeDefault().referenceSequence(referenceFasta).open(f);
            for (SAMRecord rec : in) {
                out.addAlignment(rec);
            }
            CloserUtil.close((Object)in);
        }
        out.close();
    }
}

