/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates;

import htsjdk.samtools.DuplicateScoringStrategy;
import htsjdk.samtools.ReservedTagConstants;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SortingCollection;
import htsjdk.samtools.util.SortingLongCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.programgroups.SamOrBam;
import picard.sam.DuplicationMetrics;
import picard.sam.markduplicates.EstimateLibraryComplexity;
import picard.sam.markduplicates.util.AbstractMarkDuplicatesCommandLineProgram;
import picard.sam.markduplicates.util.DiskBasedReadEndsForMarkDuplicatesMap;
import picard.sam.markduplicates.util.LibraryIdGenerator;
import picard.sam.markduplicates.util.ReadEnds;
import picard.sam.markduplicates.util.ReadEndsForMarkDuplicates;
import picard.sam.markduplicates.util.ReadEndsForMarkDuplicatesCodec;
import picard.sam.markduplicates.util.ReadEndsForMarkDuplicatesWithBarcodes;
import picard.sam.markduplicates.util.ReadEndsForMarkDuplicatesWithBarcodesCodec;
import picard.sam.markduplicates.util.RepresentativeReadIndexerCodec;
import picard.sam.util.RepresentativeReadIndexer;

@CommandLineProgramProperties(summary="Identifies duplicate reads.  <p>This tool locates and tags duplicate reads in a BAM or SAM file, where duplicate reads are defined as originating from a single fragment of DNA.  Duplicates can arise during sample preparation e.g. library construction using PCR.  See also <a href='https://broadinstitute.github.io/picard/command-line-overview.html#EstimateLibraryComplexity'>EstimateLibraryComplexity</a> for additional notes on PCR duplication artifacts.  Duplicate reads can also result from a single amplification cluster, incorrectly detected as multiple clusters by the optical sensor of the sequencing instrument.  These duplication artifacts are referred to as optical duplicates.</p><p>The MarkDuplicates tool works by comparing sequences in the 5 prime positions of both reads and read-pairs in a SAM/BAM file.  An BARCODE_TAG option is available to facilitate duplicate marking using molecular barcodes.  After duplicate reads are collected, the tool differentiates the primary and duplicate reads using an algorithm that ranks reads by the sums of their base-quality scores (default method).</p>  <p>The tool's main output is a new SAM or BAM file, in which duplicates have been identified in the SAM flags field for each read.  Duplicates are marked with the hexadecimal value of 0x0400, which corresponds to a decimal value of 1024.  If you are not familiar with this type of annotation, please see the following <a href='https://www.broadinstitute.org/gatk/blog?id=7019'>blog post</a> for additional information.</p><p>Although the bitwise flag annotation indicates whether a read was marked as a duplicate, it does not identify the type of duplicate.  To do this, a new tag called the duplicate type (DT) tag was recently added as an optional output in  the 'optional field' section of a SAM/BAM file.  Invoking the TAGGING_POLICY option, you can instruct the program to mark all the duplicates (All), only the optical duplicates (OpticalOnly), or no duplicates (DontTag).  The records within the output of a SAM/BAM file will have values for the 'DT' tag (depending on the invoked TAGGING_POLICY), as either library/PCR-generated duplicates (LB), or sequencing-platform artifact duplicates (SQ).  This tool uses the READ_NAME_REGEX and the OPTICAL_DUPLICATE_PIXEL_DISTANCE options as the primary methods to identify and differentiate duplicate types.  Set READ_NAME_REGEX to null to skip optical duplicate detection, e.g. for RNA-seq or other data where duplicate sets are extremely large and estimating library complexity is not an aim.  Note that without optical duplicate counts, library size estimation will be inaccurate.</p> <p>MarkDuplicates also produces a metrics file indicating the numbers of duplicates for both single- and paired-end reads.</p>  <p>The program can take either coordinate-sorted or query-sorted inputs, however the behavior is slightly different.  When the input is coordinate-sorted, unmapped mates of mapped records and supplementary/secondary alignments are not marked as duplicates.  However, when the input is query-sorted (actually query-grouped), then unmapped mates and secondary/supplementary reads are not excluded from the duplication test and can be marked as duplicate reads.</p>  <p>If desired, duplicates can be removed using the REMOVE_DUPLICATE and REMOVE_SEQUENCING_DUPLICATES options.</p><h4>Usage example:</h4><pre>java -jar picard.jar MarkDuplicates \\<br />      I=input.bam \\<br />      O=marked_duplicates.bam \\<br />      M=marked_dup_metrics.txt</pre>Please see <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#DuplicationMetrics'>MarkDuplicates</a> for detailed explanations of the output metrics.<hr />", oneLineSummary="Identifies duplicate reads.  ", programGroup=SamOrBam.class)
@DocumentedFeature
public class MarkDuplicates
extends AbstractMarkDuplicatesCommandLineProgram {
    static final String USAGE_SUMMARY = "Identifies duplicate reads.  ";
    static final String USAGE_DETAILS = "<p>This tool locates and tags duplicate reads in a BAM or SAM file, where duplicate reads are defined as originating from a single fragment of DNA.  Duplicates can arise during sample preparation e.g. library construction using PCR.  See also <a href='https://broadinstitute.github.io/picard/command-line-overview.html#EstimateLibraryComplexity'>EstimateLibraryComplexity</a> for additional notes on PCR duplication artifacts.  Duplicate reads can also result from a single amplification cluster, incorrectly detected as multiple clusters by the optical sensor of the sequencing instrument.  These duplication artifacts are referred to as optical duplicates.</p><p>The MarkDuplicates tool works by comparing sequences in the 5 prime positions of both reads and read-pairs in a SAM/BAM file.  An BARCODE_TAG option is available to facilitate duplicate marking using molecular barcodes.  After duplicate reads are collected, the tool differentiates the primary and duplicate reads using an algorithm that ranks reads by the sums of their base-quality scores (default method).</p>  <p>The tool's main output is a new SAM or BAM file, in which duplicates have been identified in the SAM flags field for each read.  Duplicates are marked with the hexadecimal value of 0x0400, which corresponds to a decimal value of 1024.  If you are not familiar with this type of annotation, please see the following <a href='https://www.broadinstitute.org/gatk/blog?id=7019'>blog post</a> for additional information.</p><p>Although the bitwise flag annotation indicates whether a read was marked as a duplicate, it does not identify the type of duplicate.  To do this, a new tag called the duplicate type (DT) tag was recently added as an optional output in  the 'optional field' section of a SAM/BAM file.  Invoking the TAGGING_POLICY option, you can instruct the program to mark all the duplicates (All), only the optical duplicates (OpticalOnly), or no duplicates (DontTag).  The records within the output of a SAM/BAM file will have values for the 'DT' tag (depending on the invoked TAGGING_POLICY), as either library/PCR-generated duplicates (LB), or sequencing-platform artifact duplicates (SQ).  This tool uses the READ_NAME_REGEX and the OPTICAL_DUPLICATE_PIXEL_DISTANCE options as the primary methods to identify and differentiate duplicate types.  Set READ_NAME_REGEX to null to skip optical duplicate detection, e.g. for RNA-seq or other data where duplicate sets are extremely large and estimating library complexity is not an aim.  Note that without optical duplicate counts, library size estimation will be inaccurate.</p> <p>MarkDuplicates also produces a metrics file indicating the numbers of duplicates for both single- and paired-end reads.</p>  <p>The program can take either coordinate-sorted or query-sorted inputs, however the behavior is slightly different.  When the input is coordinate-sorted, unmapped mates of mapped records and supplementary/secondary alignments are not marked as duplicates.  However, when the input is query-sorted (actually query-grouped), then unmapped mates and secondary/supplementary reads are not excluded from the duplication test and can be marked as duplicate reads.</p>  <p>If desired, duplicates can be removed using the REMOVE_DUPLICATE and REMOVE_SEQUENCING_DUPLICATES options.</p><h4>Usage example:</h4><pre>java -jar picard.jar MarkDuplicates \\<br />      I=input.bam \\<br />      O=marked_duplicates.bam \\<br />      M=marked_dup_metrics.txt</pre>Please see <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#DuplicationMetrics'>MarkDuplicates</a> for detailed explanations of the output metrics.<hr />";
    public static final String DUPLICATE_TYPE_TAG = "DT";
    public static final String DUPLICATE_TYPE_LIBRARY = "LB";
    public static final String DUPLICATE_TYPE_SEQUENCING = "SQ";
    public static final String DUPLICATE_SET_INDEX_TAG = "DI";
    public static final String DUPLICATE_SET_SIZE_TAG = "DS";
    private final Log log = Log.getInstance(MarkDuplicates.class);
    @Argument(shortName="MAX_SEQS", doc="This option is obsolete. ReadEnds will always be spilled to disk.")
    public int MAX_SEQUENCES_FOR_DISK_READ_ENDS_MAP = 50000;
    @Argument(shortName="MAX_FILE_HANDLES", doc="Maximum number of file handles to keep open when spilling read ends to disk. Set this number a little lower than the per-process maximum number of file that may be open. This number can be found by executing the 'ulimit -n' command on a Unix system.")
    public int MAX_FILE_HANDLES_FOR_READ_ENDS_MAP = 8000;
    @Argument(doc="This number, plus the maximum RAM available to the JVM, determine the memory footprint used by some of the sorting collections.  If you are running out of memory, try reducing this number.")
    public double SORTING_COLLECTION_SIZE_RATIO = 0.25;
    @Argument(doc="Barcode SAM tag (ex. BC for 10X Genomics)", optional=true)
    public String BARCODE_TAG = null;
    @Argument(doc="Read one barcode SAM tag (ex. BX for 10X Genomics)", optional=true)
    public String READ_ONE_BARCODE_TAG = null;
    @Argument(doc="Read two barcode SAM tag (ex. BX for 10X Genomics)", optional=true)
    public String READ_TWO_BARCODE_TAG = null;
    @Argument(doc="If a read appears in a duplicate set, add two tags. The first tag, DUPLICATE_SET_SIZE_TAG (DS), indicates the size of the duplicate set. The smallest possible DS value is 2 which occurs when two reads map to the same portion of the reference only one of which is marked as duplicate. The second tag, DUPLICATE_SET_INDEX_TAG (DI), represents a unique identifier for the duplicate set to which the record belongs. This identifier is the index-in-file of the representative read that was selected out of the duplicate set.", optional=true)
    public boolean TAG_DUPLICATE_SET_MEMBERS = false;
    @Argument(doc="If true remove 'optical' duplicates and other duplicates that appear to have arisen from the sequencing process instead of the library preparation process, even if REMOVE_DUPLICATES is false. If REMOVE_DUPLICATES is true, all duplicates are removed and this option is ignored.")
    public boolean REMOVE_SEQUENCING_DUPLICATES = false;
    @Argument(doc="Determines how duplicate types are recorded in the DT optional attribute.")
    public DuplicateTaggingPolicy TAGGING_POLICY = DuplicateTaggingPolicy.DontTag;
    @Argument(doc="Clear DT tag from input SAM records. Should be set to false if input SAM doesn't have this tag.  Default true")
    public boolean CLEAR_DT = true;
    private SortingCollection<ReadEndsForMarkDuplicates> pairSort;
    private SortingCollection<ReadEndsForMarkDuplicates> fragSort;
    private SortingLongCollection duplicateIndexes;
    private SortingLongCollection opticalDuplicateIndexes;
    private SortingCollection<RepresentativeReadIndexer> representativeReadIndicesForDuplicates;
    private int numDuplicateIndices = 0;
    private static final long NO_SUCH_INDEX = Long.MAX_VALUE;
    protected LibraryIdGenerator libraryIdGenerator = null;

    private int getBarcodeValue(SAMRecord record) {
        return EstimateLibraryComplexity.getReadBarcodeValue(record, this.BARCODE_TAG);
    }

    private int getReadOneBarcodeValue(SAMRecord record) {
        return EstimateLibraryComplexity.getReadBarcodeValue(record, this.READ_ONE_BARCODE_TAG);
    }

    private int getReadTwoBarcodeValue(SAMRecord record) {
        return EstimateLibraryComplexity.getReadBarcodeValue(record, this.READ_TWO_BARCODE_TAG);
    }

    public MarkDuplicates() {
        this.DUPLICATE_SCORING_STRATEGY = DuplicateScoringStrategy.ScoringStrategy.SUM_OF_BASE_QUALITIES;
    }

    public static void main(String[] args) {
        new MarkDuplicates().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IOUtil.assertInputsAreValid((List)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        IOUtil.assertFileIsWritable((File)this.METRICS_FILE);
        boolean useBarcodes = null != this.BARCODE_TAG || null != this.READ_ONE_BARCODE_TAG || null != this.READ_TWO_BARCODE_TAG;
        this.reportMemoryStats("Start of doWork");
        this.log.info(new Object[]{"Reading input file and constructing read end information."});
        this.buildSortedReadEndLists(useBarcodes);
        this.reportMemoryStats("After buildSortedReadEndLists");
        this.generateDuplicateIndexes(useBarcodes, this.REMOVE_SEQUENCING_DUPLICATES || this.TAGGING_POLICY != DuplicateTaggingPolicy.DontTag);
        this.reportMemoryStats("After generateDuplicateIndexes");
        this.log.info(new Object[]{"Marking " + this.numDuplicateIndices + " records as duplicates."});
        if (this.READ_NAME_REGEX == null) {
            this.log.warn(new Object[]{"Skipped optical duplicate cluster discovery; library size estimation may be inaccurate!"});
        } else {
            this.log.info(new Object[]{"Found " + this.libraryIdGenerator.getNumberOfOpticalDuplicateClusters() + " optical duplicate clusters."});
        }
        AbstractMarkDuplicatesCommandLineProgram.SamHeaderAndIterator headerAndIterator = this.openInputs(false);
        SAMFileHeader header = headerAndIterator.header;
        SAMFileHeader.SortOrder sortOrder = header.getSortOrder();
        SAMFileHeader outputHeader = header.clone();
        this.log.info(new Object[]{"Reads are assumed to be ordered by: " + sortOrder});
        if (sortOrder != SAMFileHeader.SortOrder.coordinate && sortOrder != SAMFileHeader.SortOrder.queryname) {
            throw new PicardException("This program requires input that are either coordinate or query sorted. Found " + sortOrder);
        }
        this.COMMENT.forEach(arg_0 -> ((SAMFileHeader)outputHeader).addComment(arg_0));
        Map<String, String> chainedPgIds = this.getChainedPgIds(outputHeader);
        SAMFileWriter out = new SAMFileWriterFactory().makeSAMOrBAMWriter(outputHeader, true, this.OUTPUT);
        long recordInFileIndex = 0L;
        long nextOpticalDuplicateIndex = this.opticalDuplicateIndexes != null && this.opticalDuplicateIndexes.hasNext() ? this.opticalDuplicateIndexes.next() : Long.MAX_VALUE;
        long nextDuplicateIndex = this.duplicateIndexes.hasNext() ? this.duplicateIndexes.next() : Long.MAX_VALUE;
        CloseableIterator representativeReadIterator = null;
        RepresentativeReadIndexer rri = null;
        int representativeReadIndexInFile = -1;
        int duplicateSetSize = -1;
        int nextRepresentativeIndex = -1;
        if (this.TAG_DUPLICATE_SET_MEMBERS && (representativeReadIterator = this.representativeReadIndicesForDuplicates.iterator()).hasNext()) {
            rri = (RepresentativeReadIndexer)representativeReadIterator.next();
            nextRepresentativeIndex = rri.readIndexInFile;
            representativeReadIndexInFile = rri.representativeReadIndexInFile;
            duplicateSetSize = rri.setSize;
        }
        ProgressLogger progress = new ProgressLogger(this.log, 10000000, "Written");
        CloseableIterator<SAMRecord> iterator = headerAndIterator.iterator;
        String duplicateQueryName = null;
        String opticalDuplicateQueryName = null;
        while (iterator.hasNext()) {
            boolean isOpticalDuplicate;
            boolean needNextOpticalDuplicateIndex;
            boolean isDuplicate;
            boolean needNextDuplicateIndex;
            SAMRecord rec = (SAMRecord)iterator.next();
            String library = LibraryIdGenerator.getLibraryName(header, rec);
            DuplicationMetrics metrics = this.libraryIdGenerator.getMetricsByLibrary(library);
            if (metrics == null) {
                metrics = new DuplicationMetrics();
                metrics.LIBRARY = library;
                this.libraryIdGenerator.addMetricsByLibrary(library, metrics);
            }
            if (rec.getReadUnmappedFlag()) {
                ++metrics.UNMAPPED_READS;
            } else if (rec.isSecondaryOrSupplementary()) {
                ++metrics.SECONDARY_OR_SUPPLEMENTARY_RDS;
            } else if (!rec.getReadPairedFlag() || rec.getMateUnmappedFlag()) {
                ++metrics.UNPAIRED_READS_EXAMINED;
            } else {
                ++metrics.READ_PAIRS_EXAMINED;
            }
            boolean bl = needNextDuplicateIndex = recordInFileIndex > nextDuplicateIndex && (sortOrder == SAMFileHeader.SortOrder.coordinate || !rec.getReadName().equals(duplicateQueryName));
            if (needNextDuplicateIndex) {
                nextDuplicateIndex = this.duplicateIndexes.hasNext() ? this.duplicateIndexes.next() : Long.MAX_VALUE;
            }
            boolean bl2 = isDuplicate = recordInFileIndex == nextDuplicateIndex || sortOrder == SAMFileHeader.SortOrder.queryname && recordInFileIndex > nextDuplicateIndex && rec.getReadName().equals(duplicateQueryName);
            if (isDuplicate) {
                duplicateQueryName = rec.getReadName();
                rec.setDuplicateReadFlag(true);
                if (!rec.isSecondaryOrSupplementary() && !rec.getReadUnmappedFlag()) {
                    if (!rec.getReadPairedFlag() || rec.getMateUnmappedFlag()) {
                        ++metrics.UNPAIRED_READ_DUPLICATES;
                    } else {
                        ++metrics.READ_PAIR_DUPLICATES;
                    }
                }
            } else {
                rec.setDuplicateReadFlag(false);
            }
            boolean bl3 = needNextOpticalDuplicateIndex = recordInFileIndex > nextOpticalDuplicateIndex && (sortOrder == SAMFileHeader.SortOrder.coordinate || !rec.getReadName().equals(opticalDuplicateQueryName));
            if (needNextOpticalDuplicateIndex) {
                nextOpticalDuplicateIndex = this.opticalDuplicateIndexes.hasNext() ? this.opticalDuplicateIndexes.next() : Long.MAX_VALUE;
            }
            boolean bl4 = isOpticalDuplicate = sortOrder == SAMFileHeader.SortOrder.queryname && recordInFileIndex > nextOpticalDuplicateIndex && rec.getReadName().equals(opticalDuplicateQueryName) || recordInFileIndex == nextOpticalDuplicateIndex;
            if (this.CLEAR_DT) {
                rec.setAttribute(DUPLICATE_TYPE_TAG, null);
            }
            if (this.TAGGING_POLICY != DuplicateTaggingPolicy.DontTag && rec.getDuplicateReadFlag()) {
                if (isOpticalDuplicate) {
                    opticalDuplicateQueryName = rec.getReadName();
                    rec.setAttribute(DUPLICATE_TYPE_TAG, (Object)DuplicateType.SEQUENCING.code());
                } else if (this.TAGGING_POLICY == DuplicateTaggingPolicy.All) {
                    rec.setAttribute(DUPLICATE_TYPE_TAG, (Object)DuplicateType.LIBRARY.code());
                }
            }
            if (this.TAG_DUPLICATE_SET_MEMBERS) {
                boolean isInDuplicateSet;
                boolean needNextRepresentativeIndex;
                boolean bl5 = needNextRepresentativeIndex = recordInFileIndex > (long)nextRepresentativeIndex;
                if (needNextRepresentativeIndex && representativeReadIterator.hasNext()) {
                    rri = (RepresentativeReadIndexer)representativeReadIterator.next();
                    nextRepresentativeIndex = rri.readIndexInFile;
                    representativeReadIndexInFile = rri.representativeReadIndexInFile;
                    duplicateSetSize = rri.setSize;
                }
                boolean bl6 = isInDuplicateSet = recordInFileIndex == (long)nextRepresentativeIndex || sortOrder == SAMFileHeader.SortOrder.queryname && recordInFileIndex > nextDuplicateIndex;
                if (isInDuplicateSet && !rec.isSecondaryOrSupplementary() && !rec.getReadUnmappedFlag() && this.TAG_DUPLICATE_SET_MEMBERS) {
                    rec.setAttribute(DUPLICATE_SET_INDEX_TAG, (Object)representativeReadIndexInFile);
                    rec.setAttribute(DUPLICATE_SET_SIZE_TAG, (Object)duplicateSetSize);
                }
            }
            ++recordInFileIndex;
            if (this.REMOVE_DUPLICATES && rec.getDuplicateReadFlag() || this.REMOVE_SEQUENCING_DUPLICATES && isOpticalDuplicate) continue;
            if (this.PROGRAM_RECORD_ID != null && this.ADD_PG_TAG_TO_READS.booleanValue()) {
                rec.setAttribute(SAMTag.PG.name(), (Object)chainedPgIds.get(rec.getStringAttribute(SAMTag.PG.name())));
            }
            out.addAlignment(rec);
            progress.record(rec);
        }
        iterator.close();
        this.duplicateIndexes.cleanup();
        if (this.TAG_DUPLICATE_SET_MEMBERS) {
            this.representativeReadIndicesForDuplicates.cleanup();
        }
        this.reportMemoryStats("Before output close");
        out.close();
        this.reportMemoryStats("After output close");
        this.finalizeAndWriteMetrics(this.libraryIdGenerator);
        return 0;
    }

    long numOpticalDuplicates() {
        return (long)this.libraryIdGenerator.getOpticalDuplicatesByLibraryIdMap().getSumOfValues();
    }

    private void reportMemoryStats(String stage) {
        System.gc();
        Runtime runtime = Runtime.getRuntime();
        this.log.info(new Object[]{stage + " freeMemory: " + runtime.freeMemory() + "; totalMemory: " + runtime.totalMemory() + "; maxMemory: " + runtime.maxMemory()});
    }

    private void buildSortedReadEndLists(boolean useBarcodes) {
        ReadEndsForMarkDuplicatesCodec diskCodec;
        ReadEndsForMarkDuplicatesCodec pairCodec;
        ReadEndsForMarkDuplicatesCodec fragCodec;
        int sizeInBytes = useBarcodes ? ReadEndsForMarkDuplicatesWithBarcodes.getSizeOf() : ReadEndsForMarkDuplicates.getSizeOf();
        this.MAX_RECORDS_IN_RAM = (int)(Runtime.getRuntime().maxMemory() / (long)sizeInBytes) / 2;
        int maxInMemory = (int)((double)Runtime.getRuntime().maxMemory() * this.SORTING_COLLECTION_SIZE_RATIO / (double)sizeInBytes);
        this.log.info(new Object[]{"Will retain up to " + maxInMemory + " data points before spilling to disk."});
        if (useBarcodes) {
            fragCodec = new ReadEndsForMarkDuplicatesWithBarcodesCodec();
            pairCodec = new ReadEndsForMarkDuplicatesWithBarcodesCodec();
            diskCodec = new ReadEndsForMarkDuplicatesWithBarcodesCodec();
        } else {
            fragCodec = new ReadEndsForMarkDuplicatesCodec();
            pairCodec = new ReadEndsForMarkDuplicatesCodec();
            diskCodec = new ReadEndsForMarkDuplicatesCodec();
        }
        this.pairSort = SortingCollection.newInstance(ReadEndsForMarkDuplicates.class, (SortingCollection.Codec)pairCodec, (Comparator)new ReadEndsMDComparator(useBarcodes), (int)maxInMemory, (Collection)this.TMP_DIR);
        this.fragSort = SortingCollection.newInstance(ReadEndsForMarkDuplicates.class, (SortingCollection.Codec)fragCodec, (Comparator)new ReadEndsMDComparator(useBarcodes), (int)maxInMemory, (Collection)this.TMP_DIR);
        AbstractMarkDuplicatesCommandLineProgram.SamHeaderAndIterator headerAndIterator = this.openInputs(true);
        SAMFileHeader.SortOrder assumedSortOrder = headerAndIterator.header.getSortOrder();
        SAMFileHeader header = headerAndIterator.header;
        DiskBasedReadEndsForMarkDuplicatesMap tmp = new DiskBasedReadEndsForMarkDuplicatesMap(this.MAX_FILE_HANDLES_FOR_READ_ENDS_MAP, diskCodec);
        long index = 0L;
        ProgressLogger progress = new ProgressLogger(this.log, 1000000, "Read");
        CloseableIterator<SAMRecord> iterator = headerAndIterator.iterator;
        if (null == this.libraryIdGenerator) {
            this.libraryIdGenerator = new LibraryIdGenerator(header);
        }
        String duplicateQueryName = null;
        long duplicateIndex = Long.MAX_VALUE;
        while (iterator.hasNext()) {
            SAMRecord rec = (SAMRecord)iterator.next();
            if (this.PROGRAM_RECORD_ID != null) {
                this.pgIdsSeen.add(rec.getStringAttribute(SAMTag.PG.name()));
            }
            if (assumedSortOrder == SAMFileHeader.SortOrder.queryname && !rec.getReadName().equals(duplicateQueryName)) {
                duplicateQueryName = rec.getReadName();
                duplicateIndex = index;
            }
            if (rec.getReadUnmappedFlag()) {
                if (rec.getReferenceIndex() == -1 && assumedSortOrder == SAMFileHeader.SortOrder.coordinate) {
                    break;
                }
            } else if (!rec.isSecondaryOrSupplementary()) {
                long indexForRead = assumedSortOrder == SAMFileHeader.SortOrder.queryname ? duplicateIndex : index;
                ReadEndsForMarkDuplicates fragmentEnd = this.buildReadEnds(header, indexForRead, rec, useBarcodes);
                this.fragSort.add((Object)fragmentEnd);
                if (rec.getReadPairedFlag() && !rec.getMateUnmappedFlag()) {
                    String key = rec.getAttribute(ReservedTagConstants.READ_GROUP_ID) + ":" + rec.getReadName();
                    ReadEndsForMarkDuplicates pairedEnds = tmp.remove(rec.getReferenceIndex(), key);
                    if (pairedEnds == null) {
                        pairedEnds = fragmentEnd.clone();
                        tmp.put(pairedEnds.read2ReferenceIndex, key, pairedEnds);
                    } else {
                        int matesRefIndex = fragmentEnd.read1ReferenceIndex;
                        int matesCoordinate = fragmentEnd.read1Coordinate;
                        if (rec.getFirstOfPairFlag()) {
                            pairedEnds.orientationForOpticalDuplicates = ReadEnds.getOrientationByte(rec.getReadNegativeStrandFlag(), pairedEnds.orientation == 1);
                            if (useBarcodes) {
                                ((ReadEndsForMarkDuplicatesWithBarcodes)pairedEnds).readOneBarcode = this.getReadOneBarcodeValue(rec);
                            }
                        } else {
                            pairedEnds.orientationForOpticalDuplicates = ReadEnds.getOrientationByte(pairedEnds.orientation == 1, rec.getReadNegativeStrandFlag());
                            if (useBarcodes) {
                                ((ReadEndsForMarkDuplicatesWithBarcodes)pairedEnds).readTwoBarcode = this.getReadTwoBarcodeValue(rec);
                            }
                        }
                        if (matesRefIndex > pairedEnds.read1ReferenceIndex || matesRefIndex == pairedEnds.read1ReferenceIndex && matesCoordinate >= pairedEnds.read1Coordinate) {
                            pairedEnds.read2ReferenceIndex = matesRefIndex;
                            pairedEnds.read2Coordinate = matesCoordinate;
                            pairedEnds.read2IndexInFile = indexForRead;
                            pairedEnds.orientation = ReadEnds.getOrientationByte(pairedEnds.orientation == 1, rec.getReadNegativeStrandFlag());
                            if (pairedEnds.read2ReferenceIndex == pairedEnds.read1ReferenceIndex && pairedEnds.read2Coordinate == pairedEnds.read1Coordinate && pairedEnds.orientation == 5) {
                                pairedEnds.orientation = (byte)3;
                            }
                        } else {
                            pairedEnds.read2ReferenceIndex = pairedEnds.read1ReferenceIndex;
                            pairedEnds.read2Coordinate = pairedEnds.read1Coordinate;
                            pairedEnds.read2IndexInFile = pairedEnds.read1IndexInFile;
                            pairedEnds.read1ReferenceIndex = matesRefIndex;
                            pairedEnds.read1Coordinate = matesCoordinate;
                            pairedEnds.read1IndexInFile = indexForRead;
                            pairedEnds.orientation = ReadEnds.getOrientationByte(rec.getReadNegativeStrandFlag(), pairedEnds.orientation == 1);
                        }
                        pairedEnds.score = (short)(pairedEnds.score + DuplicateScoringStrategy.computeDuplicateScore((SAMRecord)rec, (DuplicateScoringStrategy.ScoringStrategy)this.DUPLICATE_SCORING_STRATEGY));
                        this.pairSort.add((Object)pairedEnds);
                    }
                }
            }
            ++index;
            if (!progress.record(rec)) continue;
            this.log.info(new Object[]{"Tracking " + tmp.size() + " as yet unmatched pairs. " + tmp.sizeInRam() + " records in RAM."});
        }
        this.log.info(new Object[]{"Read " + index + " records. " + tmp.size() + " pairs never matched."});
        iterator.close();
        this.pairSort.doneAdding();
        this.fragSort.doneAdding();
    }

    private ReadEndsForMarkDuplicates buildReadEnds(SAMFileHeader header, long index, SAMRecord rec, boolean useBarcodes) {
        ReadEndsForMarkDuplicates ends = useBarcodes ? new ReadEndsForMarkDuplicatesWithBarcodes() : new ReadEndsForMarkDuplicates();
        ends.read1ReferenceIndex = rec.getReferenceIndex();
        ends.read1Coordinate = rec.getReadNegativeStrandFlag() ? rec.getUnclippedEnd() : rec.getUnclippedStart();
        ends.orientation = rec.getReadNegativeStrandFlag() ? (byte)1 : 0;
        ends.read1IndexInFile = index;
        ends.score = DuplicateScoringStrategy.computeDuplicateScore((SAMRecord)rec, (DuplicateScoringStrategy.ScoringStrategy)this.DUPLICATE_SCORING_STRATEGY);
        if (rec.getReadPairedFlag() && !rec.getMateUnmappedFlag()) {
            ends.read2ReferenceIndex = rec.getMateReferenceIndex();
        }
        ends.libraryId = this.libraryIdGenerator.getLibraryId(rec);
        if (this.opticalDuplicateFinder.addLocationInformation(rec.getReadName(), ends)) {
            ends.readGroup = 0;
            String rg = (String)rec.getAttribute(ReservedTagConstants.READ_GROUP_ID);
            List readGroups = header.getReadGroups();
            if (rg != null && readGroups != null) {
                SAMReadGroupRecord readGroup;
                Iterator iterator = readGroups.iterator();
                while (iterator.hasNext() && !(readGroup = (SAMReadGroupRecord)iterator.next()).getReadGroupId().equals(rg)) {
                    ends.readGroup = (short)(ends.readGroup + 1);
                }
            }
        }
        if (useBarcodes) {
            ReadEndsForMarkDuplicates endsWithBarcode = ends;
            endsWithBarcode.barcode = this.getBarcodeValue(rec);
            if (!rec.getReadPairedFlag() || rec.getFirstOfPairFlag()) {
                endsWithBarcode.readOneBarcode = this.getReadOneBarcodeValue(rec);
            } else {
                endsWithBarcode.readTwoBarcode = this.getReadTwoBarcodeValue(rec);
            }
        }
        return ends;
    }

    private void generateDuplicateIndexes(boolean useBarcodes, boolean indexOpticalDuplicates) {
        int entryOverhead = this.TAG_DUPLICATE_SET_MEMBERS ? 16 : 8;
        int maxInMemory = (int)Math.min((double)Runtime.getRuntime().maxMemory() * 0.25 / (double)entryOverhead, 2.147483642E9);
        if (indexOpticalDuplicates) {
            this.opticalDuplicateIndexes = new SortingLongCollection(maxInMemory /= (entryOverhead + 8) / entryOverhead, this.TMP_DIR.toArray(new File[this.TMP_DIR.size()]));
        }
        this.log.info(new Object[]{"Will retain up to " + maxInMemory + " duplicate indices before spilling to disk."});
        this.duplicateIndexes = new SortingLongCollection(maxInMemory, this.TMP_DIR.toArray(new File[this.TMP_DIR.size()]));
        if (this.TAG_DUPLICATE_SET_MEMBERS) {
            RepresentativeReadIndexerCodec representativeIndexCodec = new RepresentativeReadIndexerCodec();
            this.representativeReadIndicesForDuplicates = SortingCollection.newInstance(RepresentativeReadIndexer.class, (SortingCollection.Codec)representativeIndexCodec, (Comparator)new RepresentativeReadComparator(), (int)maxInMemory, (Collection)this.TMP_DIR);
        }
        ReadEndsForMarkDuplicates firstOfNextChunk = null;
        ArrayList<ReadEndsForMarkDuplicates> nextChunk = new ArrayList<ReadEndsForMarkDuplicates>(200);
        this.log.info(new Object[]{"Traversing read pair information and detecting duplicates."});
        for (ReadEndsForMarkDuplicates next : this.pairSort) {
            if (firstOfNextChunk != null && this.areComparableForDuplicates(firstOfNextChunk, next, true, useBarcodes)) {
                nextChunk.add(next);
                continue;
            }
            if (nextChunk.size() > 1) {
                this.markDuplicatePairs(nextChunk);
                if (this.TAG_DUPLICATE_SET_MEMBERS) {
                    this.addRepresentativeReadIndex(nextChunk);
                }
            }
            nextChunk.clear();
            nextChunk.add(next);
            firstOfNextChunk = next;
        }
        if (nextChunk.size() > 1) {
            this.markDuplicatePairs(nextChunk);
            if (this.TAG_DUPLICATE_SET_MEMBERS) {
                this.addRepresentativeReadIndex(nextChunk);
            }
        }
        this.pairSort.cleanup();
        this.pairSort = null;
        this.log.info(new Object[]{"Traversing fragment information and detecting duplicates."});
        boolean containsPairs = false;
        boolean containsFrags = false;
        firstOfNextChunk = null;
        for (ReadEndsForMarkDuplicates next : this.fragSort) {
            if (firstOfNextChunk != null && this.areComparableForDuplicates(firstOfNextChunk, next, false, useBarcodes)) {
                nextChunk.add(next);
                containsPairs = containsPairs || next.isPaired();
                containsFrags = containsFrags || !next.isPaired();
                continue;
            }
            if (nextChunk.size() > 1 && containsFrags) {
                this.markDuplicateFragments(nextChunk, containsPairs);
            }
            nextChunk.clear();
            nextChunk.add(next);
            firstOfNextChunk = next;
            containsPairs = next.isPaired();
            containsFrags = !next.isPaired();
        }
        this.markDuplicateFragments(nextChunk, containsPairs);
        this.fragSort.cleanup();
        this.fragSort = null;
        this.log.info(new Object[]{"Sorting list of duplicate records."});
        this.duplicateIndexes.doneAddingStartIteration();
        if (this.opticalDuplicateIndexes != null) {
            this.opticalDuplicateIndexes.doneAddingStartIteration();
        }
        if (this.TAG_DUPLICATE_SET_MEMBERS) {
            this.representativeReadIndicesForDuplicates.doneAdding();
        }
    }

    private boolean areComparableForDuplicates(ReadEndsForMarkDuplicates lhs, ReadEndsForMarkDuplicates rhs, boolean compareRead2, boolean useBarcodes) {
        boolean areComparable;
        boolean bl = areComparable = lhs.libraryId == rhs.libraryId;
        if (useBarcodes && areComparable) {
            ReadEndsForMarkDuplicatesWithBarcodes lhsWithBarcodes = (ReadEndsForMarkDuplicatesWithBarcodes)lhs;
            ReadEndsForMarkDuplicatesWithBarcodes rhsWithBarcodes = (ReadEndsForMarkDuplicatesWithBarcodes)rhs;
            boolean bl2 = areComparable = lhsWithBarcodes.barcode == rhsWithBarcodes.barcode && lhsWithBarcodes.readOneBarcode == rhsWithBarcodes.readOneBarcode && lhsWithBarcodes.readTwoBarcode == rhsWithBarcodes.readTwoBarcode;
        }
        if (areComparable) {
            boolean bl3 = areComparable = lhs.read1ReferenceIndex == rhs.read1ReferenceIndex && lhs.read1Coordinate == rhs.read1Coordinate && lhs.orientation == rhs.orientation;
        }
        if (areComparable && compareRead2) {
            areComparable = lhs.read2ReferenceIndex == rhs.read2ReferenceIndex && lhs.read2Coordinate == rhs.read2Coordinate;
        }
        return areComparable;
    }

    private void addIndexAsDuplicate(long bamIndex) {
        this.duplicateIndexes.add(bamIndex);
        ++this.numDuplicateIndices;
    }

    private void addRepresentativeReadOfDuplicateSet(long representativeReadIndexInFile, int setSize, long read1IndexInFile) {
        RepresentativeReadIndexer rri = new RepresentativeReadIndexer();
        rri.representativeReadIndexInFile = (int)representativeReadIndexInFile;
        rri.setSize = setSize;
        rri.readIndexInFile = (int)read1IndexInFile;
        this.representativeReadIndicesForDuplicates.add((Object)rri);
    }

    private void addRepresentativeReadIndex(List<ReadEndsForMarkDuplicates> list) {
        short maxScore = 0;
        ReadEndsForMarkDuplicates best = null;
        for (ReadEndsForMarkDuplicates end : list) {
            if (end.score <= maxScore && best != null) continue;
            maxScore = end.score;
            best = end;
        }
        for (ReadEndsForMarkDuplicates end : list) {
            this.addRepresentativeReadOfDuplicateSet(best.read1IndexInFile, list.size(), end.read1IndexInFile);
            this.addRepresentativeReadOfDuplicateSet(best.read1IndexInFile, list.size(), end.read2IndexInFile);
        }
    }

    private void markDuplicatePairs(List<ReadEndsForMarkDuplicates> list) {
        short maxScore = 0;
        ReadEndsForMarkDuplicates best = null;
        for (ReadEndsForMarkDuplicates end : list) {
            if (end.score <= maxScore && best != null) continue;
            maxScore = end.score;
            best = end;
        }
        if (this.READ_NAME_REGEX != null) {
            AbstractMarkDuplicatesCommandLineProgram.trackOpticalDuplicates(list, best, this.opticalDuplicateFinder, this.libraryIdGenerator);
        }
        for (ReadEndsForMarkDuplicates end : list) {
            if (end == best) continue;
            this.addIndexAsDuplicate(end.read1IndexInFile);
            if (end.read2IndexInFile != end.read1IndexInFile) {
                this.addIndexAsDuplicate(end.read2IndexInFile);
            }
            if (!end.isOpticalDuplicate || this.opticalDuplicateIndexes == null) continue;
            this.opticalDuplicateIndexes.add(end.read1IndexInFile);
            this.opticalDuplicateIndexes.add(end.read2IndexInFile);
        }
    }

    private void markDuplicateFragments(List<ReadEndsForMarkDuplicates> list, boolean containsPairs) {
        if (containsPairs) {
            for (ReadEndsForMarkDuplicates end : list) {
                if (end.isPaired()) continue;
                this.addIndexAsDuplicate(end.read1IndexInFile);
            }
        } else {
            short maxScore = 0;
            ReadEndsForMarkDuplicates best = null;
            for (ReadEndsForMarkDuplicates end : list) {
                if (end.score <= maxScore && best != null) continue;
                maxScore = end.score;
                best = end;
            }
            for (ReadEndsForMarkDuplicates end : list) {
                if (end == best) continue;
                this.addIndexAsDuplicate(end.read1IndexInFile);
            }
        }
    }

    static int compareInteger(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    static class RepresentativeReadComparator
    implements Comparator<RepresentativeReadIndexer> {
        @Override
        public int compare(RepresentativeReadIndexer lhs, RepresentativeReadIndexer rhs) {
            int compareDifference = lhs.readIndexInFile - rhs.readIndexInFile;
            return compareDifference;
        }
    }

    static class ReadEndsMDComparator
    implements Comparator<ReadEndsForMarkDuplicates> {
        final boolean useBarcodes;

        public ReadEndsMDComparator(boolean useBarcodes) {
            this.useBarcodes = useBarcodes;
        }

        @Override
        public int compare(ReadEndsForMarkDuplicates lhs, ReadEndsForMarkDuplicates rhs) {
            int compareDifference = lhs.libraryId - rhs.libraryId;
            if (this.useBarcodes) {
                ReadEndsForMarkDuplicatesWithBarcodes lhsWithBarcodes = (ReadEndsForMarkDuplicatesWithBarcodes)lhs;
                ReadEndsForMarkDuplicatesWithBarcodes rhsWithBarcodes = (ReadEndsForMarkDuplicatesWithBarcodes)rhs;
                if (compareDifference == 0) {
                    compareDifference = MarkDuplicates.compareInteger(lhsWithBarcodes.barcode, rhsWithBarcodes.barcode);
                }
                if (compareDifference == 0) {
                    compareDifference = MarkDuplicates.compareInteger(lhsWithBarcodes.readOneBarcode, rhsWithBarcodes.readOneBarcode);
                }
                if (compareDifference == 0) {
                    compareDifference = MarkDuplicates.compareInteger(lhsWithBarcodes.readTwoBarcode, rhsWithBarcodes.readTwoBarcode);
                }
            }
            if (compareDifference == 0) {
                compareDifference = lhs.read1ReferenceIndex - rhs.read1ReferenceIndex;
            }
            if (compareDifference == 0) {
                compareDifference = lhs.read1Coordinate - rhs.read1Coordinate;
            }
            if (compareDifference == 0) {
                compareDifference = lhs.orientation - rhs.orientation;
            }
            if (compareDifference == 0) {
                compareDifference = lhs.read2ReferenceIndex - rhs.read2ReferenceIndex;
            }
            if (compareDifference == 0) {
                compareDifference = lhs.read2Coordinate - rhs.read2Coordinate;
            }
            if (compareDifference == 0) {
                compareDifference = (int)(lhs.read1IndexInFile - rhs.read1IndexInFile);
            }
            if (compareDifference == 0) {
                compareDifference = (int)(lhs.read2IndexInFile - rhs.read2IndexInFile);
            }
            return compareDifference;
        }
    }

    public static enum DuplicateType {
        LIBRARY("LB"),
        SEQUENCING("SQ");

        private final String code;

        private DuplicateType(String code) {
            this.code = code;
        }

        public String code() {
            return this.code;
        }
    }

    public static enum DuplicateTaggingPolicy {
        DontTag,
        OpticalOnly,
        All;

    }
}

