/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates;

import htsjdk.samtools.DuplicateSet;
import htsjdk.samtools.DuplicateSetIterator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.StringUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import picard.PicardException;
import picard.sam.markduplicates.UmiGraph;
import picard.sam.markduplicates.UmiMetrics;

class UmiAwareDuplicateSetIterator
implements CloseableIterator<DuplicateSet> {
    private final DuplicateSetIterator wrappedIterator;
    private Iterator<DuplicateSet> nextSetsIterator;
    private final int maxEditDistanceToJoin;
    private final String umiTag;
    private final String inferredUmiTag;
    private final boolean allowMissingUmis;
    private boolean isOpen = false;
    private UmiMetrics metrics;
    private boolean haveWeSeenFirstRead = false;
    private long observedUmiBases = 0L;

    UmiAwareDuplicateSetIterator(DuplicateSetIterator wrappedIterator, int maxEditDistanceToJoin, String umiTag, String assignedUmiTag, boolean allowMissingUmis, UmiMetrics metrics) {
        this.wrappedIterator = wrappedIterator;
        this.maxEditDistanceToJoin = maxEditDistanceToJoin;
        this.umiTag = umiTag;
        this.inferredUmiTag = assignedUmiTag;
        this.allowMissingUmis = allowMissingUmis;
        this.metrics = metrics;
        this.isOpen = true;
        this.nextSetsIterator = Collections.emptyIterator();
    }

    public void close() {
        this.isOpen = false;
        this.wrappedIterator.close();
        this.metrics.calculateDerivedFields();
    }

    public boolean hasNext() {
        if (!this.isOpen) {
            return false;
        }
        if (this.nextSetsIterator.hasNext() || this.wrappedIterator.hasNext()) {
            return true;
        }
        this.isOpen = false;
        return false;
    }

    public DuplicateSet next() {
        if (!this.nextSetsIterator.hasNext()) {
            this.process(this.wrappedIterator.next());
        }
        return this.nextSetsIterator.next();
    }

    private void process(DuplicateSet set) {
        if (this.nextSetsIterator.hasNext()) {
            throw new PicardException("nextSetsIterator is expected to be empty, but already contains data.");
        }
        UmiGraph umiGraph = new UmiGraph(set, this.umiTag, this.inferredUmiTag, this.allowMissingUmis);
        List<DuplicateSet> duplicateSets = umiGraph.joinUmisIntoDuplicateSets(this.maxEditDistanceToJoin);
        for (DuplicateSet ds : duplicateSets) {
            List records = ds.getRecords();
            SAMRecord representativeRead = ds.getRepresentative();
            String inferredUmi = representativeRead.getStringAttribute(this.inferredUmiTag);
            for (SAMRecord rec : records) {
                String currentUmi = rec.getStringAttribute(this.umiTag);
                if (currentUmi == null) continue;
                if (!this.haveWeSeenFirstRead) {
                    this.metrics.MEAN_UMI_LENGTH = currentUmi.length();
                    this.haveWeSeenFirstRead = true;
                } else if (this.metrics.MEAN_UMI_LENGTH != (double)currentUmi.length()) {
                    throw new PicardException("UMIs of differing lengths were found.");
                }
                this.metrics.OBSERVED_BASE_ERRORS += (long)StringUtil.hammingDistance((String)currentUmi, (String)inferredUmi);
                this.observedUmiBases += (long)currentUmi.length();
                this.metrics.addUmiObservation(currentUmi, inferredUmi);
            }
        }
        this.metrics.DUPLICATE_SETS_WITH_UMI += (long)duplicateSets.size();
        ++this.metrics.DUPLICATE_SETS_IGNORING_UMI;
        this.nextSetsIterator = duplicateSets.iterator();
    }
}

