/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates;

import htsjdk.samtools.DuplicateSet;
import htsjdk.samtools.DuplicateSetIterator;
import htsjdk.samtools.SAMRecordDuplicateComparator;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import picard.cmdline.programgroups.Alpha;
import picard.sam.markduplicates.SimpleMarkDuplicatesWithMateCigar;
import picard.sam.markduplicates.UmiAwareDuplicateSetIterator;
import picard.sam.markduplicates.UmiMetrics;
import picard.sam.markduplicates.util.AbstractMarkDuplicatesCommandLineProgram;

@CommandLineProgramProperties(summary="Identifies duplicate reads using information from read positions and UMIs. <p>This tool locates and tags duplicate reads in a BAM or SAM file, where duplicate reads are defined as originating from a single fragment of DNA. It is based on the MarkDuplicatesWithMateCigar tool, with added logic to leverage Unique Molecular Identifier (UMI) information.</p><p>In addition to assuming that all members of a duplicate set must have the same start and end position, it imposes thatthey must also have sufficiently similar UMIs. In this context, 'sufficiently similar' is parameterized by the command line argument MAX_EDIT_DISTANCE_TO_JOIN, which sets the edit distance between UMIs that will be considered to be part of the same original molecule. This logic allows for sequencing errors in UMIs.</p><p>This tool is NOT intended to be used on data without UMIs; for marking duplicates in non-UMI data, see MarkDuplicates or MarkDuplicatesWithMateCigar. Mixed data (where some reads have UMIs and others do not) is not supported.</p>", oneLineSummary="Identifies duplicate reads using information from read positions and UMIs. ", programGroup=Alpha.class)
public class UmiAwareMarkDuplicatesWithMateCigar
extends SimpleMarkDuplicatesWithMateCigar {
    static final String USAGE_SUMMARY = "Identifies duplicate reads using information from read positions and UMIs. ";
    static final String USAGE_DETAILS = "<p>This tool locates and tags duplicate reads in a BAM or SAM file, where duplicate reads are defined as originating from a single fragment of DNA. It is based on the MarkDuplicatesWithMateCigar tool, with added logic to leverage Unique Molecular Identifier (UMI) information.</p><p>In addition to assuming that all members of a duplicate set must have the same start and end position, it imposes thatthey must also have sufficiently similar UMIs. In this context, 'sufficiently similar' is parameterized by the command line argument MAX_EDIT_DISTANCE_TO_JOIN, which sets the edit distance between UMIs that will be considered to be part of the same original molecule. This logic allows for sequencing errors in UMIs.</p><p>This tool is NOT intended to be used on data without UMIs; for marking duplicates in non-UMI data, see MarkDuplicates or MarkDuplicatesWithMateCigar. Mixed data (where some reads have UMIs and others do not) is not supported.</p>";
    @Argument(shortName="MAX_EDIT_DISTANCE_TO_JOIN", doc="Largest edit distance that UMIs must have in order to be considered as coming from distinct source molecules.", optional=true)
    public int MAX_EDIT_DISTANCE_TO_JOIN = 1;
    @Argument(shortName="UMI_METRICS", doc="UMI Metrics")
    public File UMI_METRICS_FILE;
    @Argument(shortName="UMI_TAG_NAME", doc="Tag name to use for UMI", optional=true)
    public String UMI_TAG_NAME = "RX";
    @Argument(shortName="ASSIGNED_UMI_TAG", doc="Tag name to use for assigned UMI", optional=true)
    public String ASSIGNED_UMI_TAG = "MI";
    @Argument(doc="FOR TESTING ONLY: allow for missing UMIs if data doesn't have UMIs. This option is intended to be used ONLY for testing the code. Use MarkDuplicatesWithMateCigar if data has no UMIs. Mixed data (where some reads have UMIs and others do not) is not supported.", optional=true)
    public boolean ALLOW_MISSING_UMIS = false;
    private final Log log = Log.getInstance(UmiAwareMarkDuplicatesWithMateCigar.class);
    private UmiMetrics metrics = new UmiMetrics();

    @Override
    protected int doWork() {
        IOUtil.assertFileIsWritable((File)this.UMI_METRICS_FILE);
        int retval = super.doWork();
        MetricsFile metricsFile = this.getMetricsFile();
        metricsFile.addMetric((MetricBase)this.metrics);
        metricsFile.write(this.UMI_METRICS_FILE);
        return retval;
    }

    @Override
    protected CloseableIterator<DuplicateSet> getDuplicateSetIterator(AbstractMarkDuplicatesCommandLineProgram.SamHeaderAndIterator headerAndIterator, SAMRecordDuplicateComparator comparator) {
        return new UmiAwareDuplicateSetIterator(new DuplicateSetIterator(headerAndIterator.iterator, headerAndIterator.header, false, comparator), this.MAX_EDIT_DISTANCE_TO_JOIN, this.UMI_TAG_NAME, this.ASSIGNED_UMI_TAG, this.ALLOW_MISSING_UMIS, this.metrics);
    }
}

