/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.liftover.LiftOver;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.Intervals;

@CommandLineProgramProperties(summary="Lifts over an interval list from one reference build to another.  This tool adjusts the coordinates in an interval list derived from one reference to match a new reference, based on a chain file that describes the correspondence between the two references. It is based on the UCSC liftOver tool (see: http://genome.ucsc.edu/cgi-bin/hgLiftOver) and uses a UCSC chain file to guide its operation. It accepts both Picard interval_list files or VCF files as interval inputs.<br /><h4>Usage example:</h4><pre>java -jar picard.jar LiftOverIntervalList \\<br />      I=input.interval_list \\<br />      O=output.interval_list \\<br />      SD=reference_sequence.dict \\<br />      CHAIN=build.chain</pre><hr />", oneLineSummary="Lifts over an interval list from one reference build to another.  ", programGroup=Intervals.class)
@DocumentedFeature
public class LiftOverIntervalList
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Lifts over an interval list from one reference build to another.  ";
    static final String USAGE_DETAILS = "This tool adjusts the coordinates in an interval list derived from one reference to match a new reference, based on a chain file that describes the correspondence between the two references. It is based on the UCSC liftOver tool (see: http://genome.ucsc.edu/cgi-bin/hgLiftOver) and uses a UCSC chain file to guide its operation. It accepts both Picard interval_list files or VCF files as interval inputs.<br /><h4>Usage example:</h4><pre>java -jar picard.jar LiftOverIntervalList \\<br />      I=input.interval_list \\<br />      O=output.interval_list \\<br />      SD=reference_sequence.dict \\<br />      CHAIN=build.chain</pre><hr />";
    private static final Log LOG = Log.getInstance(LiftOverIntervalList.class);
    @Argument(doc="Interval list to be lifted over.", shortName="I")
    public File INPUT;
    @Argument(doc="Where to write lifted-over interval list.", shortName="O")
    public File OUTPUT;
    @Argument(doc="Sequence dictionary to write into the output interval list.", shortName="SD")
    public File SEQUENCE_DICTIONARY;
    @Argument(doc="Chain file that guides LiftOver.")
    public File CHAIN;
    @Argument(doc="Minimum percentage of bases in each input interval that must map to output interval.")
    public double MIN_LIFTOVER_PCT = 0.95;

    public static void main(String[] argv) {
        new LiftOverIntervalList().instanceMainWithExit(argv);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsReadable((File)this.SEQUENCE_DICTIONARY);
        IOUtil.assertFileIsReadable((File)this.CHAIN);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        LiftOver liftOver = new LiftOver(this.CHAIN);
        liftOver.setLiftOverMinMatch(this.MIN_LIFTOVER_PCT);
        IntervalList fromIntervals = IntervalList.fromFile((File)this.INPUT);
        SAMFileHeader toHeader = SamReaderFactory.makeDefault().getFileHeader(this.SEQUENCE_DICTIONARY);
        liftOver.validateToSequences(toHeader.getSequenceDictionary());
        IntervalList toIntervals = new IntervalList(toHeader);
        boolean anyFailed = false;
        for (Interval fromInterval : fromIntervals) {
            Interval toInterval = liftOver.liftOver(fromInterval);
            if (toInterval != null) {
                toIntervals.add(toInterval);
                continue;
            }
            anyFailed = true;
            LOG.warn(new Object[]{"Liftover failed for ", fromInterval, "(len ", fromInterval.length(), ")"});
            List partials = liftOver.diagnosticLiftover(fromInterval);
            for (LiftOver.PartialLiftover partial : partials) {
                LOG.info(new Object[]{partial});
            }
        }
        toIntervals.sorted().write(this.OUTPUT);
        return anyFailed ? 1 : 0;
    }
}

