/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import picard.PicardException;

public class ThreadPoolExecutorWithExceptions
extends ThreadPoolExecutor {
    public ThreadPoolExecutorWithExceptions(int threads) {
        super(threads, threads, 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        if (t == null && r instanceof Future) {
            try {
                Future future = (Future)((Object)r);
                if (future.isDone()) {
                    future.get();
                }
            }
            catch (CancellationException ce) {
                t = ce;
            }
            catch (ExecutionException ee) {
                t = ee.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (t != null) {
            throw new PicardException(t.getMessage(), t);
        }
    }
}

