/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.processor;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.vcf.processor.VcfFileSegment;
import picard.vcf.processor.VcfFileSegmentGenerator;
import picard.vcf.processor.util.PredicateFilterDecoratingClosableIterator;

public abstract class VariantIteratorProducer {
    static final int ONE_HUNDRED_MILLION = 100000000;

    public abstract Iterable<CloseableIterator<VariantContext>> iterators();

    public abstract void close();

    public static VariantIteratorProducer byHundredMegabaseChunksWithOnTheFlyFilteringByInterval(List<File> vcfs, IntervalList intervalList) {
        return new Threadsafe(VcfFileSegmentGenerator.byWholeContigSubdividingWithWidth(100000000L), vcfs, intervalList);
    }

    public static VariantIteratorProducer byHundredMegabaseChunks(List<File> vcfs) {
        return new Threadsafe(VcfFileSegmentGenerator.byWholeContigSubdividingWithWidth(100000000L), vcfs, null);
    }

    static class Threadsafe
    extends VariantIteratorProducer {
        static final Log LOG = Log.getInstance(Threadsafe.class);
        final List<VcfFileSegment> segments;
        final OverlapDetector<Interval> intervalsOfInterestDetector;
        final Map<File, OverlapDetector<VcfFileSegment>> multiSegmentDetectorPerFile = new CollectionUtil.DefaultingMap(f -> new OverlapDetector(0, 0), true);
        final Collection<VCFFileReader> allReaders = Collections.synchronizedCollection(new ArrayList());
        final ThreadLocal<CollectionUtil.DefaultingMap<File, VCFFileReader>> localVcfFileReaders = new ThreadLocal<CollectionUtil.DefaultingMap<File, VCFFileReader>>(){

            @Override
            protected CollectionUtil.DefaultingMap<File, VCFFileReader> initialValue() {
                return new CollectionUtil.DefaultingMap(file -> {
                    VCFFileReader reader = new VCFFileReader(file);
                    LOG.debug(new Object[]{String.format("Producing a reader of %s for %s.", file, Thread.currentThread())});
                    allReaders.add(reader);
                    return reader;
                }, true);
            }
        };

        Threadsafe(VcfFileSegmentGenerator segmenter, List<File> vcfs) {
            this(segmenter, vcfs, null);
        }

        Threadsafe(VcfFileSegmentGenerator segmenter, List<File> vcfs, IntervalList intervals) {
            if (intervals != null) {
                List uniques = intervals.uniqued(false).getIntervals();
                this.intervalsOfInterestDetector = new OverlapDetector(0, 0);
                this.intervalsOfInterestDetector.addAll(uniques, uniques);
            } else {
                this.intervalsOfInterestDetector = null;
            }
            VcfFileSegmentGenerator interestingSegmentSegmenter = this.intervalsOfInterestDetector == null ? segmenter : VcfFileSegmentGenerator.excludingNonOverlaps(segmenter, this.intervalsOfInterestDetector);
            this.segments = new ArrayList<VcfFileSegment>();
            for (File vcf : vcfs) {
                for (VcfFileSegment segment : interestingSegmentSegmenter.forVcf(vcf)) {
                    this.segments.add(segment);
                }
            }
            for (VcfFileSegment segment : this.segments) {
                Interval segmentInterval = segment.correspondingInterval();
                OverlapDetector<VcfFileSegment> vcfSpecificDetector = this.multiSegmentDetectorPerFile.get(segment.vcf());
                if (vcfSpecificDetector.getOverlaps((Locatable)segmentInterval).isEmpty()) {
                    vcfSpecificDetector.addLhs((Object)segment, (Locatable)new Interval(segment.contig(), segment.start(), segment.stop()));
                    continue;
                }
                throw new IllegalArgumentException(String.format("Provided segmenting strategy produced overlapping intervals; %s overlaps with: %s", segment, Joiner.on((String)", ").join((Iterable)vcfSpecificDetector.getOverlaps((Locatable)segmentInterval))));
            }
        }

        private CloseableIterator<VariantContext> iteratorForSegment(VcfFileSegment segment) {
            CloseableIterator query = ((VCFFileReader)this.localVcfFileReaders.get().get((Object)segment.vcf())).query(segment.contig(), segment.start(), segment.stop());
            ArrayList filters = new ArrayList();
            if (this.intervalsOfInterestDetector != null) {
                filters.add(new OverlapsPredicate());
            }
            filters.add(new NonUniqueVariantPredicate(segment));
            return new PredicateFilterDecoratingClosableIterator<VariantContext>(query, filters);
        }

        @Override
        public Iterable<CloseableIterator<VariantContext>> iterators() {
            return FluentIterable.from(this.segments).transform(this::iteratorForSegment);
        }

        @Override
        public void close() {
            Iterator<VCFFileReader> i = this.allReaders.iterator();
            while (i.hasNext()) {
                i.next().close();
                i.remove();
            }
        }

        final class OverlapsPredicate
        implements Predicate<VariantContext> {
            OverlapsPredicate() {
            }

            public boolean apply(VariantContext vc) {
                boolean include;
                boolean bl = include = !Threadsafe.this.intervalsOfInterestDetector.getOverlaps((Locatable)new Interval(vc.getContig(), vc.getStart(), vc.getEnd())).isEmpty();
                if (!include) {
                    LOG.debug(new Object[]{"Filtering variant at ", vc.getContig(), ":", vc.getStart(), "-", vc.getEnd()});
                }
                return include;
            }
        }

        final class NonUniqueVariantPredicate
        implements Predicate<VariantContext> {
            final VcfFileSegment sourceSegment;

            NonUniqueVariantPredicate(VcfFileSegment sourceSegment) {
                this.sourceSegment = sourceSegment;
            }

            public boolean apply(VariantContext vc) {
                if (vc.getStart() == vc.getEnd()) {
                    return true;
                }
                Set intersectingSegments = Threadsafe.this.multiSegmentDetectorPerFile.get(this.sourceSegment.vcf()).getOverlaps((Locatable)new Interval(vc.getContig(), vc.getStart(), vc.getEnd()));
                if (intersectingSegments.size() < 2) {
                    return true;
                }
                int sourceSegmentIndex = Threadsafe.this.segments.indexOf(this.sourceSegment);
                LOG.debug(new Object[]{"Found wide variant spanning multiple source segments: ", vc});
                for (VcfFileSegment intersectingSegment : intersectingSegments) {
                    if (Threadsafe.this.segments.indexOf(intersectingSegment) >= sourceSegmentIndex) continue;
                    return false;
                }
                LOG.debug(new Object[]{"Emitting wide variant because it belongs to first segment: ", vc});
                return true;
            }
        }
    }
}

