/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.translator;

import fr.ens.biologie.genomique.kenetre.translator.Translator;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTranslator
implements Translator {
    private String defaultField;
    private boolean originalDefaultFieldSearchDone;

    @Override
    public String getDefaultField() {
        if (this.defaultField == null && !this.originalDefaultFieldSearchDone) {
            List<String> fields = this.getFields();
            if (fields != null && !fields.isEmpty()) {
                this.defaultField = fields.get(0);
            }
            this.originalDefaultFieldSearchDone = true;
        }
        return this.defaultField;
    }

    @Override
    public void setDefaultField(String field) {
        if (!this.isField(field)) {
            throw new RuntimeException("The field doesn't exists");
        }
        this.defaultField = field;
    }

    @Override
    public List<String> translate(String id) {
        List<String> fields = this.getFields();
        if (id == null || id.isEmpty()) {
            throw new NullPointerException("id argument can't be null.");
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String field : fields) {
            result.add(this.translateField(id, field));
        }
        return result;
    }

    @Override
    public List<List<String>> translate(List<String> ids) {
        if (ids == null) {
            throw new NullPointerException("ids argument can't be null.");
        }
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (String id : ids) {
            result.add(this.translate(id));
        }
        return result;
    }

    @Override
    public List<String> translateField(List<String> ids) {
        return this.translateField(ids, this.getDefaultField());
    }

    @Override
    public List<String> translateField(List<String> ids, String field) {
        if (ids == null) {
            throw new NullPointerException("ids argument can't be null.");
        }
        String lField = field == null ? this.getDefaultField() : field;
        if (lField == null || !this.isField(lField)) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String id : ids) {
            result.add(this.translateField(id, lField));
        }
        return result;
    }

    @Override
    public String translateField(String id) {
        return this.translateField(id, this.getDefaultField());
    }

    @Override
    public boolean isField(String field) {
        if (field == null) {
            throw new NullPointerException("field argument can't be null.");
        }
        List<String> fields = this.getFields();
        if (fields == null) {
            return false;
        }
        for (String field1 : fields) {
            if (!field.equals(field1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLinkInfo(String field) {
        return false;
    }

    @Override
    public String getLinkInfo(String translatedId, String field) {
        return null;
    }

    @Override
    public List<String> getLinkInfo(List<String> translatedIds, String field) {
        if (translatedIds == null || field == null) {
            throw new NullPointerException("translatedIds and field arguments can't be null.");
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String id : translatedIds) {
            result.add(this.getLinkInfo(id, field));
        }
        return result;
    }

    @Override
    public Translator getReverseTranslator() {
        return null;
    }

    @Override
    public List<String> getIds() {
        return null;
    }
}

