/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.translator;

import fr.ens.biologie.genomique.kenetre.translator.AbstractTranslator;
import fr.ens.biologie.genomique.kenetre.translator.Translator;
import fr.ens.biologie.genomique.kenetre.translator.io.TranslatorOutputFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class TranslatorUtils {
    public static void addTranslatorFields(File inputFile, int fieldToTranslate, Translator translator, TranslatorOutputFormat of) throws IOException {
        TranslatorUtils.addTranslatorFields(new FileInputStream(inputFile), fieldToTranslate, translator, of);
    }

    public static void addTranslatorFields(InputStream is, int fieldToTranslate, Translator translator, TranslatorOutputFormat of) throws IOException {
        String line;
        if (is == null) {
            throw new NullPointerException("InputStream is null");
        }
        if (translator == null) {
            throw new NullPointerException("Translator is null");
        }
        if (of == null) {
            throw new NullPointerException("OutputFormat is null");
        }
        List<String> translatorFieldnames = translator.getFields();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.defaultCharset()));
        boolean first = true;
        while ((line = reader.readLine()) != null) {
            ArrayList<String> fields = new ArrayList<String>(Arrays.asList(line.split("\t")));
            if (first) {
                for (String field : fields) {
                    of.addHeaderField(field);
                }
                for (String translatorFieldname : translatorFieldnames) {
                    of.addHeaderField(translatorFieldname);
                }
                first = false;
                continue;
            }
            of.newLine();
            for (String field1 : fields) {
                try {
                    of.writeDouble(Double.parseDouble(field1));
                }
                catch (NumberFormatException e) {
                    of.writeText(field1);
                }
            }
            for (String field : translatorFieldnames) {
                String valueToTranslate = (String)fields.get(fieldToTranslate);
                String value = field == null ? null : translator.translateField(valueToTranslate, field);
                String link = value == null || !translator.isLinkInfo(field) ? null : translator.getLinkInfo(value, field);
                if (value == null) {
                    of.writeEmpty();
                    continue;
                }
                if (link == null) {
                    of.writeText(value);
                    continue;
                }
                of.writeLink(value, link);
            }
        }
        reader.close();
        of.close();
    }

    public static Translator createDuplicatedEnsemblIdTranslator() {
        return new AbstractTranslator(){
            private static final String FIELD_NAME = "EnsemblID";
            private final Pattern pattern = Pattern.compile("ENS[A-Z]+[0-9]{11}");

            @Override
            public String translateField(String id, String field) {
                if (id == null || field == null) {
                    return null;
                }
                if (FIELD_NAME.equals(field) && this.pattern.matcher(id).matches()) {
                    return id;
                }
                return null;
            }

            @Override
            public List<String> getFields() {
                return Collections.singletonList(FIELD_NAME);
            }
        };
    }

    private TranslatorUtils() {
    }
}

