/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.translator;

import fr.ens.biologie.genomique.kenetre.translator.AbstractTranslator;
import fr.ens.biologie.genomique.kenetre.translator.Translator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UniqueIdentifierTranslator
extends AbstractTranslator {
    private static final String DEFAULT_FIELD = "UniqueId";
    private final Map<String, String> mapUniqueId = new HashMap<String, String>();
    private final Map<String, String> reverseMapUniqueId = new HashMap<String, String>();
    private List<String> fields;
    private String newFieldName = "UniqueId";
    private final Translator translator;

    @Override
    public List<String> getFields() {
        return this.fields;
    }

    @Override
    public String translateField(String id, String field) {
        String translatedId = this.mapUniqueId.get(id);
        if (this.newFieldName.equals(field)) {
            return translatedId;
        }
        return this.translator.translateField(translatedId, field);
    }

    @Override
    public boolean isLinkInfo(String field) {
        return this.translator.isLinkInfo(field);
    }

    @Override
    public String getLinkInfo(String translatedId, String field) {
        return this.translator.getLinkInfo(translatedId, field);
    }

    private void translateIds(List<String> ids, String field) {
        Translator translator = this.translator;
        HashMap<String, String> translation = new HashMap<String, String>();
        HashMap<String, Integer> translationCount = new HashMap<String, Integer>();
        String fieldName = field == null ? translator.getDefaultField() : field;
        for (String row : ids) {
            String t = translator.translateField(row, fieldName);
            if (t == null || "".equals(t)) {
                t = row;
            }
            translation.put(row, t);
            if (translationCount.containsKey(t)) {
                int count = (Integer)translationCount.get(t);
                translationCount.put(t, ++count);
                continue;
            }
            translationCount.put(t, 1);
        }
        HashMap<String, Integer> translationCurrentCount = new HashMap<String, Integer>();
        for (Map.Entry e : translation.entrySet()) {
            String postfix;
            String row = (String)e.getKey();
            String t = (String)e.getValue();
            int count = (Integer)translationCount.get(t);
            if (count <= 1) continue;
            if (translationCurrentCount.containsKey(t)) {
                int currentCount = (Integer)translationCurrentCount.get(t);
                translationCurrentCount.put(t, ++currentCount);
                postfix = "#" + currentCount;
            } else {
                translationCurrentCount.put(t, 1);
                postfix = "#1";
            }
            translation.put(row, t + postfix);
        }
        for (String id : ids) {
            String newId = (String)translation.get(id);
            this.mapUniqueId.put(newId, id);
            this.reverseMapUniqueId.put(id, newId);
        }
    }

    public void updateFields() {
        List<String> tFields = this.translator.getFields();
        if (tFields == null) {
            this.fields = Collections.singletonList(this.newFieldName);
        } else {
            this.fields = new ArrayList<String>();
            this.fields.add(this.newFieldName);
            this.fields.addAll(tFields);
        }
    }

    public void setNewFieldName(String newFieldName) {
        this.newFieldName = newFieldName == null ? DEFAULT_FIELD : newFieldName;
    }

    @Override
    public Translator getReverseTranslator() {
        return new AbstractTranslator(){

            @Override
            public List<String> getFields() {
                return Collections.singletonList(UniqueIdentifierTranslator.this.newFieldName);
            }

            @Override
            public String translateField(String id, String field) {
                if (UniqueIdentifierTranslator.this.newFieldName.equals(field)) {
                    return (String)UniqueIdentifierTranslator.this.reverseMapUniqueId.get(id);
                }
                return null;
            }
        };
    }

    private static String getTranslatorDefaultField(Translator translator) {
        if (translator == null) {
            throw new NullPointerException("Translator argument can't is null.");
        }
        return translator.getDefaultField();
    }

    public UniqueIdentifierTranslator(List<String> ids, Translator translator) {
        this(ids, translator, UniqueIdentifierTranslator.getTranslatorDefaultField(translator), null);
    }

    public UniqueIdentifierTranslator(List<String> ids, Translator translator, String translatorField) {
        this(ids, translator, translatorField, null);
    }

    public UniqueIdentifierTranslator(List<String> ids, Translator translator, String translatorField, String newFieldName) {
        if (ids == null) {
            throw new NullPointerException("Identifiers can't be null");
        }
        if (translator == null) {
            throw new NullPointerException("Translator can't be null");
        }
        this.translator = translator;
        this.translateIds(Collections.unmodifiableList(ids), translatorField);
        this.setNewFieldName(newFieldName);
        this.updateFields();
    }

    public UniqueIdentifierTranslator(String[] ids, Translator translator) {
        this(Arrays.asList(ids), translator);
    }
}

