/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.translator.io;

import fr.ens.biologie.genomique.kenetre.translator.io.TranslatorOutputFormat;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeValueTypeAttribute;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.pkg.NamespaceName;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfXMLFactory;
import org.odftoolkit.odfdom.type.Color;
import org.odftoolkit.simple.SpreadsheetDocument;
import org.odftoolkit.simple.style.Font;
import org.odftoolkit.simple.style.StyleTypeDefinitions;
import org.odftoolkit.simple.table.Cell;
import org.odftoolkit.simple.table.Row;
import org.odftoolkit.simple.table.Table;
import org.odftoolkit.simple.table.TableContainer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ODSTranslatorOutputFormat
implements TranslatorOutputFormat {
    private final OutputStream os;
    private final SpreadsheetDocument document;
    private final TableTableElement tableElement;
    private final Table table;
    private final List<String> headers = new ArrayList<String>();
    private TableTableRowElement rowElement;
    private final OdfFileDom dom;
    private boolean first = true;

    @Override
    public void addHeaderField(String fieldName) throws IOException {
        this.headers.add(fieldName);
    }

    @Override
    public void newLine() throws IOException {
        if (this.first) {
            this.table.appendColumns(this.headers.size());
            Row row = this.table.getRowByIndex(0);
            int i = 0;
            for (String h : this.headers) {
                Cell c = row.getCellByIndex(i++);
                c.setCellBackgroundColor(Color.ORANGE);
                Font f = c.getFont();
                f.setFontStyle(StyleTypeDefinitions.FontStyle.ITALIC);
                f.setSize(10.0);
                c.setFont(f);
                c.setStringValue(h);
            }
            for (Node n : new DomNodeList(this.table.getOdfElement().getChildNodes())) {
                if (!(n instanceof TableTableRowElement)) continue;
                this.rowElement = (TableTableRowElement)n;
            }
            this.first = false;
        }
        TableTableRowElement aRow = (TableTableRowElement)OdfXMLFactory.newOdfElement((OdfFileDom)this.dom, (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.TABLE, (String)"table-row"));
        this.tableElement.appendChild((Node)aRow);
        this.rowElement = aRow;
    }

    private TableTableCellElement getCell() {
        TableTableCellElement aCell = (TableTableCellElement)OdfXMLFactory.newOdfElement((OdfFileDom)this.dom, (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.TABLE, (String)"table-cell"));
        this.rowElement.appendChild((Node)aCell);
        return aCell;
    }

    @Override
    public void writeEmpty() throws IOException {
        TableTableCellElement cell = this.getCell();
        cell.setOfficeValueTypeAttribute(OfficeValueTypeAttribute.Value.VOID.toString());
    }

    @Override
    public void writeLong(long l) throws IOException {
        TableTableCellElement cell = this.getCell();
        cell.setOfficeValueTypeAttribute(OfficeValueTypeAttribute.Value.FLOAT.toString());
        cell.setOfficeValueAttribute(Double.valueOf(l));
    }

    @Override
    public void writeDouble(double d) throws IOException {
        TableTableCellElement cell = this.getCell();
        cell.setOfficeValueTypeAttribute(OfficeValueTypeAttribute.Value.FLOAT.toString());
        cell.setOfficeValueAttribute(Double.valueOf(d));
    }

    @Override
    public void writeText(String text) throws IOException {
        TableTableCellElement cell = this.getCell();
        cell.setOfficeValueTypeAttribute(OfficeValueTypeAttribute.Value.STRING.toString());
        cell.setOfficeStringValueAttribute(text == null ? "" : text);
    }

    @Override
    public void writeLink(String text, String link) throws IOException {
        if (text == null || link == null) {
            this.writeText(text);
        }
        TableTableCellElement cell = this.getCell();
        cell.setTableFormulaAttribute("=HYPERLINK(\"" + link + "\";\"" + text + "\")");
    }

    @Override
    public void close() throws IOException {
        try {
            this.document.save(this.os);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public ODSTranslatorOutputFormat(OutputStream os) throws IOException {
        if (os == null) {
            throw new NullPointerException("The output stream is null");
        }
        try {
            this.os = os;
            this.document = SpreadsheetDocument.newSpreadsheetDocument();
            this.table = this.document.getSheetByIndex(0);
            this.tableElement = this.table.getOdfElement();
            this.dom = (OdfFileDom)this.table.getOdfElement().getOwnerDocument();
            Table.newTable((TableContainer)this.document);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public ODSTranslatorOutputFormat(File file) throws IOException {
        this(new FileOutputStream(file));
    }

    private static final class DomNodeList
    extends AbstractList<Node> {
        private final NodeList m_nodeList;

        public DomNodeList(NodeList list) {
            this.m_nodeList = list;
        }

        @Override
        public int size() {
            return this.m_nodeList.getLength();
        }

        @Override
        public Node get(int index) {
            return this.m_nodeList.item(index);
        }
    }
}

