/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.translator.io;

import fr.ens.biologie.genomique.kenetre.translator.io.TranslatorOutputFormat;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.util.DefaultTempFileCreationStrategy;
import org.apache.poi.util.TempFile;
import org.apache.poi.util.TempFileCreationStrategy;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class XLSXTranslatorOutputFormat
implements TranslatorOutputFormat {
    private static final int MAX_LINES_IN_MEMORY = 10;
    private final OutputStream os;
    private final SXSSFWorkbook wb;
    private final Sheet sheet;
    private final CellStyle defaultStyle;
    private final CellStyle headerStyle;
    private final CellStyle linkStyle;
    private int rowCount;
    private int colCount;
    private Row row;

    @Override
    public void addHeaderField(String fieldName) throws IOException {
        Cell cell = this.row.createCell(this.colCount++);
        cell.setCellValue((RichTextString)new XSSFRichTextString(fieldName));
        cell.setCellStyle(this.headerStyle);
    }

    @Override
    public void newLine() throws IOException {
        this.colCount = 0;
        this.row = this.sheet.createRow(this.rowCount++);
    }

    @Override
    public void writeEmpty() throws IOException {
        this.row.createCell(this.colCount++);
    }

    @Override
    public void writeLong(long l) throws IOException {
        Cell cell = this.row.createCell(this.colCount++);
        cell.setCellValue((double)l);
        cell.setCellStyle(this.defaultStyle);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        Cell cell = this.row.createCell(this.colCount++);
        cell.setCellValue(d);
        cell.setCellStyle(this.defaultStyle);
    }

    @Override
    public void writeText(String text) throws IOException {
        Cell cell = this.row.createCell(this.colCount++);
        if (text != null) {
            cell.setCellValue((RichTextString)new XSSFRichTextString(text));
            cell.setCellStyle(this.defaultStyle);
        }
    }

    @Override
    public void writeLink(String text, String link) throws IOException {
        SXSSFCell cell = (SXSSFCell)this.row.createCell(this.colCount++, CellType.FORMULA);
        if (text != null) {
            if (link != null) {
                cell.setCellFormula("HYPERLINK(\"" + link.replace("\"", "\"\"") + "\",\"" + text.replace("\"", "\"\"") + "\")");
                cell.setCellStyle(this.linkStyle);
            }
            cell.setCellValue(text);
        }
    }

    @Override
    public void close() throws IOException {
        this.wb.write(this.os);
        this.os.close();
        this.wb.dispose();
    }

    public XLSXTranslatorOutputFormat(OutputStream os, File temporaryDirectory) {
        if (os == null) {
            throw new NullPointerException("The output stream is null");
        }
        this.os = os;
        if (temporaryDirectory != null) {
            TempFile.setTempFileCreationStrategy((TempFileCreationStrategy)new DefaultTempFileCreationStrategy(temporaryDirectory));
        }
        this.wb = new SXSSFWorkbook(10);
        this.sheet = this.wb.createSheet("new sheet");
        this.row = this.sheet.createRow(this.rowCount++);
        this.wb.setCompressTempFiles(true);
        Font defaultFont = this.wb.createFont();
        defaultFont.setFontName("Arial");
        defaultFont.setFontHeightInPoints((short)10);
        this.defaultStyle = this.wb.createCellStyle();
        this.defaultStyle.setFont(defaultFont);
        Font headerFont = this.wb.createFont();
        headerFont.setFontName(defaultFont.getFontName());
        headerFont.setFontHeightInPoints(defaultFont.getFontHeightInPoints());
        headerFont.setItalic(true);
        this.headerStyle = this.wb.createCellStyle();
        this.headerStyle.setFillForegroundColor(IndexedColors.ORANGE.getIndex());
        this.headerStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.headerStyle.setFont(headerFont);
        Font linkfont = this.wb.createFont();
        linkfont.setFontName(defaultFont.getFontName());
        linkfont.setFontHeightInPoints(defaultFont.getFontHeightInPoints());
        linkfont.setUnderline((byte)1);
        linkfont.setColor(IndexedColors.BLUE.getIndex());
        this.linkStyle = this.wb.createCellStyle();
        this.linkStyle.setFont(linkfont);
    }

    public XLSXTranslatorOutputFormat(OutputStream os) {
        this(os, null);
    }

    public XLSXTranslatorOutputFormat(File file) throws IOException {
        this(new FileOutputStream(file), null);
    }

    public XLSXTranslatorOutputFormat(File file, File temporaryDirectory) throws IOException {
        this(new FileOutputStream(file), temporaryDirectory);
    }
}

