/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.expressioncounter;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.GFFEntry;
import fr.ens.biologie.genomique.kenetre.bio.GenomeDescription;
import fr.ens.biologie.genomique.kenetre.bio.expressioncounter.ExpressionCounter;
import fr.ens.biologie.genomique.kenetre.bio.io.GFFReader;
import fr.ens.biologie.genomique.kenetre.bio.io.GTFReader;
import fr.ens.biologie.genomique.kenetre.log.DummyLogger;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.util.ReporterIncrementer;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractExpressionCounter
implements ExpressionCounter {
    private static final int DEFAULT_MAX_RECORDS_IN_RAM = 500000;
    private static final String MAX_RECORDS_IN_RAM_KEY = "max.entries.in.ram";
    private int maxRecordsInRam = 500000;
    private GenericLogger logger = new DummyLogger();

    @Override
    public void setLogger(GenericLogger logger) {
        Objects.requireNonNull(logger);
        this.logger = logger;
    }

    @Override
    public GenericLogger getLogger() {
        return this.logger;
    }

    protected boolean setCommonParameter(String key, String value) throws KenetreException {
        Objects.requireNonNull(key, "the key argument is null");
        Objects.requireNonNull(value, "the value argument is null");
        if (MAX_RECORDS_IN_RAM_KEY.equals(key)) {
            try {
                int intValue = Integer.parseInt(value);
                if (intValue < 1) {
                    throw new KenetreException("Invalid " + key + "parameter (The value must be greater than 1): " + value);
                }
                this.maxRecordsInRam = intValue;
            }
            catch (NumberFormatException e) {
                throw new KenetreException("Invalid parameter, an integer parameter is need for " + key + " parameter: " + value, (Throwable)e);
            }
            return true;
        }
        return false;
    }

    @Override
    public void init(GenomeDescription genomeDesc, InputStream annotationIs, boolean gtfFormat) throws KenetreException, IOException {
        try (GTFReader gffReader = gtfFormat ? new GTFReader(annotationIs) : new GFFReader(annotationIs);){
            this.init(genomeDesc, (Iterable<GFFEntry>)gffReader);
        }
    }

    @Override
    public void init(InputStream descIs, InputStream annotationIs, boolean gtfFormat) throws KenetreException, IOException {
        try (GTFReader gffReader = gtfFormat ? new GTFReader(annotationIs) : new GFFReader(annotationIs);){
            this.init(GenomeDescription.load((InputStream)descIs), (Iterable<GFFEntry>)gffReader);
        }
    }

    @Override
    public Map<String, Integer> count(InputStream inputSam, ReporterIncrementer reporter, String counterGroup) throws KenetreException {
        if (inputSam == null) {
            throw new NullPointerException("the inputSam argument is null");
        }
        return this.count((Iterable<SAMRecord>)SamReaderFactory.makeDefault().open(SamInputResource.of((InputStream)inputSam)), reporter, counterGroup);
    }

    @Override
    public Map<String, Integer> count(InputStream inputSam, OutputStream outputSam, File temporaryDirectory, ReporterIncrementer reporter, String counterGroup) throws KenetreException {
        if (inputSam == null) {
            throw new NullPointerException("the inputSam argument is null");
        }
        if (outputSam == null) {
            throw new NullPointerException("the outputSam argument is null");
        }
        if (temporaryDirectory == null) {
            throw new NullPointerException("the temporaryDirectory argument is null");
        }
        SamReader reader = SamReaderFactory.makeDefault().open(SamInputResource.of((InputStream)inputSam));
        SAMFileWriter writer = new SAMFileWriterFactory().setTempDirectory(temporaryDirectory).setMaxRecordsInRam(this.maxRecordsInRam).makeSAMWriter(reader.getFileHeader(), false, outputSam);
        return this.count(new IteratorWriter(writer, reader), reporter, counterGroup);
    }

    private static class IteratorWriter
    implements Iterable<SAMRecord>,
    Iterator<SAMRecord> {
        private final SAMFileWriter writer;
        private final Iterator<SAMRecord> samRecords;
        private SAMRecord current;

        @Override
        public Iterator<SAMRecord> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public boolean hasNext() {
            boolean result = this.samRecords.hasNext();
            if (!result && this.current != null) {
                this.writer.addAlignment(this.current);
                this.writer.close();
                this.current = null;
            }
            return result;
        }

        @Override
        public SAMRecord next() {
            if (this.current != null) {
                this.writer.addAlignment(this.current);
                this.current = null;
            }
            this.current = this.samRecords.next();
            return this.current;
        }

        private IteratorWriter(SAMFileWriter writer, SamReader samReader) {
            this.writer = writer;
            this.samRecords = samReader.iterator();
        }
    }
}

