/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.expressioncounter;

public enum ExpressionCounterCounter {
    INVALID_SAM_ENTRIES_COUNTER("invalid SAM input entries"),
    TOTAL_READS_COUNTER("reads total"),
    UNUSED_READS_COUNTER("reads unused"),
    USED_READS_COUNTER("reads used"),
    UNMAPPED_READS_COUNTER("unmapped reads"),
    ELIMINATED_READS_COUNTER("reads eliminated"),
    TOTAL_ALIGNMENTS_COUNTER("total number of alignments"),
    NOT_ALIGNED_ALIGNMENTS_COUNTER("number of not aligned alignments", "not_aligned"),
    NOT_UNIQUE_ALIGNMENTS_COUNTER("number of not unique alignments", "alignment_not_unique"),
    LOW_QUAL_ALIGNMENTS_COUNTER("number of alignments with too low quality", "too_low_aQual"),
    EMPTY_ALIGNMENTS_COUNTER("number of alignments with no feature", "no_feature"),
    AMBIGUOUS_ALIGNMENTS_COUNTER("number of ambiguous alignments", "ambiguous"),
    MISSING_MATES_COUNTER("number of missing mate alignments"),
    PARENTS_COUNTER("parent"),
    INVALID_CHROMOSOME_COUNTER("invalid chromosome"),
    PARENT_ID_NOT_FOUND_COUNTER("Parent Id not found in exon range");

    private final String counterName;
    private final String htseqName;

    public String counterName() {
        return this.counterName;
    }

    public String htSeqCountCounterName() {
        return this.htseqName;
    }

    public static ExpressionCounterCounter getCounterFromHTSeqCountName(String counterName) {
        if (counterName == null) {
            throw new NullPointerException("counterName argument cannot be null");
        }
        String s = counterName.startsWith("__") ? counterName.substring(2) : counterName;
        for (ExpressionCounterCounter c : ExpressionCounterCounter.values()) {
            if (c.htseqName == null || !c.htseqName.equals(s)) continue;
            return c;
        }
        return null;
    }

    public static ExpressionCounterCounter getCounterFromEoulsanName(String counterName) {
        if (counterName == null) {
            throw new NullPointerException("counterName argument cannot be null");
        }
        for (ExpressionCounterCounter c : ExpressionCounterCounter.values()) {
            if (c.counterName == null || !c.counterName.equals(counterName)) continue;
            return c;
        }
        return null;
    }

    public String toString() {
        return this.counterName;
    }

    private ExpressionCounterCounter(String counterName) {
        this(counterName, null);
    }

    private ExpressionCounterCounter(String counterName, String htseqName) {
        this.counterName = counterName;
        this.htseqName = htseqName;
    }
}

