/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.expressioncounter;

import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.GFFEntry;
import fr.ens.biologie.genomique.kenetre.bio.GenomeDescription;
import fr.ens.biologie.genomique.kenetre.bio.GenomicArray;
import fr.ens.biologie.genomique.kenetre.bio.GenomicInterval;
import fr.ens.biologie.genomique.kenetre.bio.expressioncounter.AbstractExpressionCounter;
import fr.ens.biologie.genomique.kenetre.bio.expressioncounter.ExpressionCounterCounter;
import fr.ens.biologie.genomique.kenetre.bio.expressioncounter.HTSeqUtils;
import fr.ens.biologie.genomique.kenetre.bio.expressioncounter.OverlapMode;
import fr.ens.biologie.genomique.kenetre.bio.expressioncounter.StrandUsage;
import fr.ens.biologie.genomique.kenetre.util.GuavaCompatibility;
import fr.ens.biologie.genomique.kenetre.util.ReporterIncrementer;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HTSeqCounter
extends AbstractExpressionCounter
implements Serializable {
    private static final long serialVersionUID = 4750866178483111062L;
    public static final String COUNTER_NAME = "htseq-count";
    public static final String REMOVE_AMBIGUOUS_CASES_PARAMETER_NAME = "remove.ambiguous.cases";
    public static final String OVERLAP_MODE_PARAMETER_NAME = "overlap.mode";
    public static final String STRANDED_PARAMETER_NAME = "stranded";
    public static final String COUNTER_PARAMETER_NAME = "counter";
    public static final String GENOMIC_TYPE_PARAMETER_NAME = "genomic.type";
    public static final String ATTRIBUTE_ID_PARAMETER_NAME = "attribute.id";
    public static final String SPLIT_ATTRIBUTE_VALUES_PARAMETER_NAME = "split.attribute.values";
    public static final String MINIMUM_ALIGNMENT_QUALITY_PARAMETER_NAME = "minimum.alignment.quality";
    public static final String REMOVE_NON_UNIQUE_ALIGNMENTS_PARAMETER_NAME = "remove.non.unique.alignments";
    public static final String REMOVE_SECONDARY_ALIGNMENTS_PARAMETER_NAME = "remove.secondary.alignments";
    public static final String REMOVE_SUPPLEMENTARY_ALIGNMENTS_PARAMETER_NAME = "remove.supplementary.alignments";
    public static final String REMOVE_NON_ASSIGNED_FEATURES_SAM_TAGS_PARAMETER_NAME = "remove.non.assigned.sam.tags";
    public static final String SAM_TAG_TO_USE_PARAMETER_NAME = "sam.tag.to.use";
    public static final String SAM_TAG_DEFAULT = "XF";
    private String genomicType = "exon";
    private String attributeId = "PARENT";
    private boolean splitAttributeValues = false;
    private StrandUsage stranded = StrandUsage.NO;
    private OverlapMode overlapMode = OverlapMode.UNION;
    private boolean removeAmbiguousCases = true;
    private int minimalQuality = 0;
    private boolean removeNonUnique = true;
    private boolean removeSecondaryAlignments = false;
    private boolean removeSupplementaryAlignments = false;
    private boolean removeNonAssignedFeatureSamTags = false;
    private String samTag = "XF";
    private final GenomicArray<String> features = new GenomicArray();
    private boolean initialized;

    @Override
    public String getName() {
        return COUNTER_NAME;
    }

    @Override
    public String getDescription() {
        return "htseq-count counter";
    }

    @Override
    public void setParameter(String key, String value) throws KenetreException {
        if (this.setCommonParameter(key, value)) {
            return;
        }
        switch (key) {
            case "genomic.type": {
                this.genomicType = value;
                break;
            }
            case "attribute.id": {
                this.attributeId = value;
                break;
            }
            case "stranded": {
                this.stranded = StrandUsage.getStrandUsageFromName(value);
                if (this.stranded != null) break;
                throw new KenetreException("Unknown strand mode");
            }
            case "overlap.mode": {
                this.overlapMode = OverlapMode.getOverlapModeFromName(value);
                if (this.overlapMode != null) break;
                throw new KenetreException("Unknown overlap mode");
            }
            case "remove.ambiguous.cases": {
                this.removeAmbiguousCases = Boolean.parseBoolean(value);
                break;
            }
            case "split.attribute.values": {
                this.splitAttributeValues = Boolean.parseBoolean(value);
                break;
            }
            case "minimum.alignment.quality": {
                try {
                    this.minimalQuality = Integer.parseInt(value);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new KenetreException("Invalid minimal quality value: " + value);
                }
            }
            case "remove.non.unique.alignments": {
                this.removeNonUnique = Boolean.parseBoolean(value);
                break;
            }
            case "remove.secondary.alignments": {
                this.removeSecondaryAlignments = Boolean.parseBoolean(value);
                break;
            }
            case "remove.supplementary.alignments": {
                this.removeSupplementaryAlignments = Boolean.parseBoolean(value);
                break;
            }
            case "remove.non.assigned.sam.tags": {
                this.removeNonAssignedFeatureSamTags = Boolean.parseBoolean(value);
                break;
            }
            case "sam.tag.to.use": {
                this.samTag = value.toUpperCase().trim();
                if (this.samTag.length() == 2 && (this.samTag.charAt(0) >= 'X' || this.samTag.charAt(0) <= 'Z') && (this.samTag.charAt(1) >= 'A' || this.samTag.charAt(1) <= 'Z')) break;
                throw new KenetreException("Invalid SAM tag: " + value);
            }
            default: {
                throw new KenetreException("Unknown parameter: " + key);
            }
        }
    }

    @Override
    public void checkConfiguration() throws KenetreException {
        if (this.genomicType == null) {
            throw new KenetreException("No parent type set");
        }
        if (this.attributeId == null) {
            throw new KenetreException("No attribute id set");
        }
        if (this.stranded == null) {
            throw new KenetreException("Unknown strand mode");
        }
        if (this.overlapMode == null) {
            throw new KenetreException("Unknown overlap mode");
        }
    }

    @Override
    public void init(GenomeDescription desc, Iterable<GFFEntry> annotations) throws KenetreException {
        if (desc == null) {
            throw new NullPointerException("the desc argument is null");
        }
        if (annotations == null) {
            throw new NullPointerException("the annotations argument is null");
        }
        if (this.initialized) {
            throw new IllegalStateException("the counter has been already initialized");
        }
        this.checkConfiguration();
        this.features.addChromosomes(desc);
        Splitter splitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        for (GFFEntry gff : annotations) {
            if (!this.genomicType.equals(gff.getType())) continue;
            String featureId = gff.getAttributeValue(this.attributeId);
            if (featureId == null) {
                throw new KenetreException("Feature " + this.genomicType + " does not contain a " + this.attributeId + " attribute");
            }
            if ((this.stranded == StrandUsage.YES || this.stranded == StrandUsage.REVERSE) && '.' == gff.getStrand()) {
                throw new KenetreException("Feature " + this.genomicType + " does not have strand information but you are running htseq-count in stranded mode.");
            }
            List featureIds = this.splitAttributeValues ? GuavaCompatibility.splitToList((Splitter)splitter, (CharSequence)featureId) : Collections.singletonList(featureId);
            for (String f : featureIds) {
                this.features.addEntry(new GenomicInterval(gff, this.stranded.isSaveStrandInfo()), (Object)f);
            }
        }
        if (this.features.getFeaturesIds().size() == 0) {
            throw new KenetreException("Warning: No features of type '" + this.genomicType + "' found.\n");
        }
        this.initialized = true;
    }

    @Override
    public Map<String, Integer> count(Iterable<SAMRecord> samRecords, ReporterIncrementer reporter, String counterGroup) throws KenetreException {
        if (reporter == null) {
            throw new NullPointerException("the reporter argument is null");
        }
        if (counterGroup == null) {
            throw new NullPointerException("the counterGroup argument is null");
        }
        if (!this.initialized) {
            throw new IllegalStateException("the counter has not been initialized");
        }
        SAMRecord sam1 = null;
        SAMRecord sam2 = null;
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        ArrayList<GenomicInterval> ivSeq = new ArrayList<GenomicInterval>();
        InternalCounters internalCounters = new InternalCounters(reporter, counterGroup);
        for (SAMRecord samRecord : samRecords) {
            internalCounters.input++;
            if (!samRecord.getReadPairedFlag()) {
                sam1 = samRecord;
                if (!this.processSingleEnd(sam1, ivSeq, internalCounters)) {
                    continue;
                }
            } else {
                if (samRecord.getHeader().getSortOrder() == SAMFileHeader.SortOrder.coordinate) {
                    throw new KenetreException("The counter does not support SAM data sorted by coordinate in paired-end mode");
                }
                if (sam1 != null && sam2 != null) {
                    sam1 = null;
                    sam2 = null;
                    ivSeq.clear();
                }
                if (samRecord.getFirstOfPairFlag()) {
                    sam1 = samRecord;
                } else {
                    sam2 = samRecord;
                }
                if (sam1 == null || sam2 == null) continue;
                if (!sam1.getReadName().equals(sam2.getReadName())) {
                    sam1 = sam2;
                    sam2 = null;
                    internalCounters.missingMate++;
                    continue;
                }
                if (!this.pairedEnd(sam1, sam2, ivSeq, internalCounters)) continue;
            }
            this.updateCounts(sam1, sam2, ivSeq, counts, internalCounters);
        }
        internalCounters.fillReporter(this);
        return counts;
    }

    private boolean processSingleEnd(SAMRecord samRecord, List<GenomicInterval> ivSeq, InternalCounters counters) {
        ivSeq.clear();
        if (samRecord.getReadUnmappedFlag()) {
            counters.notAligned++;
            this.assignment(samRecord, null, "__not_aligned");
            return false;
        }
        if (this.removeSecondaryAlignments && samRecord.isSecondaryAlignment()) {
            counters.secondaryAlignments++;
            return false;
        }
        if (this.removeSupplementaryAlignments && samRecord.getSupplementaryAlignmentFlag()) {
            counters.supplementaryAlignments++;
            return false;
        }
        if (samRecord.getAttribute("NH") != null && samRecord.getIntegerAttribute("NH") > 1) {
            counters.nonUnique++;
            this.assignment(samRecord, null, "__alignment_not_unique");
            if (this.removeNonUnique) {
                return false;
            }
        }
        if (samRecord.getMappingQuality() < this.minimalQuality) {
            counters.lowQual++;
            this.assignment(samRecord, null, "__too_low_aQual");
            return false;
        }
        ivSeq.addAll(HTSeqUtils.addIntervals(samRecord, this.stranded));
        return true;
    }

    private boolean pairedEnd(SAMRecord sam1, SAMRecord sam2, List<GenomicInterval> ivSeq, InternalCounters counters) {
        if (!sam1.getReadUnmappedFlag()) {
            ivSeq.addAll(HTSeqUtils.addIntervals(sam1, this.stranded));
        }
        if (!sam2.getReadUnmappedFlag()) {
            ivSeq.addAll(HTSeqUtils.addIntervals(sam2, this.stranded));
        }
        if (sam1.getReadUnmappedFlag() && sam2.getReadUnmappedFlag()) {
            counters.notAligned++;
            this.assignment(sam1, sam2, "__not_aligned");
            return false;
        }
        if (this.removeSecondaryAlignments) {
            if (sam1 != null && sam1.isSecondaryAlignment()) {
                return false;
            }
            if (sam2 != null && sam2.isSecondaryAlignment()) {
                return false;
            }
        }
        if (this.removeSupplementaryAlignments) {
            if (sam1 != null && sam1.getSupplementaryAlignmentFlag()) {
                return false;
            }
            if (sam2 != null && sam2.getSupplementaryAlignmentFlag()) {
                return false;
            }
        }
        if (sam1.getAttribute("NH") != null && sam1.getIntegerAttribute("NH") > 1 || sam2.getAttribute("NH") != null && sam2.getIntegerAttribute("NH") > 1) {
            counters.nonUnique++;
            this.assignment(sam1, sam2, "__alignment_not_unique");
            if (this.removeNonUnique) {
                return false;
            }
        }
        if (sam1.getMappingQuality() < this.minimalQuality || sam2.getMappingQuality() < this.minimalQuality) {
            counters.lowQual++;
            this.assignment(sam1, sam2, "__too_low_aQual");
            return false;
        }
        return true;
    }

    private void updateCounts(SAMRecord samRecord1, SAMRecord samRecord2, List<GenomicInterval> ivSeq, Map<String, Integer> counts, InternalCounters internalCounters) throws KenetreException {
        try {
            Set<String> fs = HTSeqUtils.featuresOverlapped(ivSeq, this.features, this.overlapMode, this.stranded);
            switch (fs.size()) {
                case 0: {
                    internalCounters.empty++;
                    this.assignment(samRecord1, samRecord2, "__no_feature");
                    break;
                }
                case 1: {
                    String id = fs.iterator().next();
                    HTSeqCounter.increment(counts, id);
                    this.assignment(samRecord1, samRecord2, id);
                    break;
                }
                default: {
                    internalCounters.ambiguous++;
                    this.assignment(samRecord1, samRecord2, fs);
                    if (!this.removeAmbiguousCases) {
                        for (String id2 : fs) {
                            HTSeqCounter.increment(counts, id2);
                        }
                    }
                    break;
                }
            }
        }
        catch (HTSeqUtils.UnknownChromosomeException e) {
            internalCounters.empty++;
            this.assignment(samRecord1, samRecord2, "__no_feature");
        }
    }

    private static void increment(Map<String, Integer> counts, String key) {
        if (!counts.containsKey(key)) {
            counts.put(key, 1);
        } else {
            counts.put(key, counts.get(key) + 1);
        }
    }

    private void assignment(SAMRecord samRecord1, SAMRecord samRecord2, String assignment) {
        if (this.removeNonAssignedFeatureSamTags && assignment.startsWith("__")) {
            return;
        }
        if (samRecord1 != null) {
            samRecord1.setAttribute(this.samTag, (Object)assignment);
        }
        if (samRecord2 != null) {
            samRecord2.setAttribute(this.samTag, (Object)assignment);
        }
    }

    private void assignment(SAMRecord samRecord1, SAMRecord samRecord2, Set<String> features) {
        ArrayList<String> list = new ArrayList<String>(features);
        Collections.sort(list);
        this.assignment(samRecord1, samRecord2, "__ambiguous[" + StringUtils.join(list, (String)"+") + ']');
    }

    @Override
    public void addZeroCountFeatures(Map<String, Integer> counts) {
        if (counts == null) {
            throw new NullPointerException("The counts arguments cannot be null");
        }
        if (!this.initialized) {
            throw new IllegalStateException("the counter has not been initialized");
        }
        for (String feature : this.features.getFeaturesIds()) {
            if (counts.containsKey(feature)) continue;
            counts.put(feature, 0);
        }
    }

    public String toString() {
        return "HTSeqCounter{genomicType=" + this.genomicType + ", attributeId=" + this.attributeId + ", splitAttributeValues=" + this.splitAttributeValues + ", stranded=" + (Object)((Object)this.stranded) + ", overlapMode=" + (Object)((Object)this.overlapMode) + ", removeAmbiguousCases=" + this.removeAmbiguousCases + ", removeNonUnique=" + this.removeNonUnique + ",, removeSecondaryAlignments=" + this.removeSecondaryAlignments + ", removeSupplementaryAlignments=" + this.removeSupplementaryAlignments + " minAverageQuality=" + this.minimalQuality + ", initialized=" + this.initialized + "}";
    }

    private static class InternalCounters {
        final ReporterIncrementer reporter;
        final String counterGroup;
        private int input;
        private int empty;
        private int ambiguous;
        private int notAligned;
        private int lowQual;
        private int secondaryAlignments;
        private int supplementaryAlignments;
        private int nonUnique;
        private int missingMate;

        private void fillReporter(HTSeqCounter counter) {
            this.reporter.incrCounter(this.counterGroup, ExpressionCounterCounter.TOTAL_ALIGNMENTS_COUNTER.counterName(), (long)this.input);
            this.reporter.incrCounter(this.counterGroup, ExpressionCounterCounter.EMPTY_ALIGNMENTS_COUNTER.counterName(), (long)this.empty);
            this.reporter.incrCounter(this.counterGroup, ExpressionCounterCounter.AMBIGUOUS_ALIGNMENTS_COUNTER.counterName(), (long)this.ambiguous);
            this.reporter.incrCounter(this.counterGroup, ExpressionCounterCounter.LOW_QUAL_ALIGNMENTS_COUNTER.counterName(), (long)this.lowQual);
            this.reporter.incrCounter(this.counterGroup, ExpressionCounterCounter.NOT_ALIGNED_ALIGNMENTS_COUNTER.counterName(), (long)this.notAligned);
            this.reporter.incrCounter(this.counterGroup, ExpressionCounterCounter.NOT_UNIQUE_ALIGNMENTS_COUNTER.counterName(), (long)this.nonUnique);
            this.reporter.incrCounter(this.counterGroup, ExpressionCounterCounter.MISSING_MATES_COUNTER.counterName(), (long)this.missingMate);
            this.reporter.incrCounter(this.counterGroup, ExpressionCounterCounter.ELIMINATED_READS_COUNTER.counterName(), (long)(this.empty + (counter.removeAmbiguousCases ? this.ambiguous : 0) + this.lowQual + this.notAligned + (counter.removeNonUnique ? this.nonUnique : 0) + this.secondaryAlignments + this.supplementaryAlignments + this.missingMate));
        }

        private InternalCounters(ReporterIncrementer reporter, String counterGroup) {
            this.reporter = reporter;
            this.counterGroup = counterGroup;
        }
    }
}

