/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.expressioncounter;

import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.BadBioEntryException;
import fr.ens.biologie.genomique.kenetre.bio.GFFEntry;
import fr.ens.biologie.genomique.kenetre.bio.GenomicArray;
import fr.ens.biologie.genomique.kenetre.bio.GenomicInterval;
import fr.ens.biologie.genomique.kenetre.bio.expressioncounter.OverlapMode;
import fr.ens.biologie.genomique.kenetre.bio.expressioncounter.StrandUsage;
import fr.ens.biologie.genomique.kenetre.bio.io.GFFReader;
import fr.ens.biologie.genomique.kenetre.bio.io.GTFReader;
import fr.ens.biologie.genomique.kenetre.util.GuavaCompatibility;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HTSeqUtils {
    public static void storeAnnotation(GenomicArray<String> features, InputStream annotationIs, boolean gtfFormat, String featureType, StrandUsage stranded, String attributeId, boolean splitAttributeValues, Map<String, Integer> counts) throws IOException, KenetreException, BadBioEntryException {
        Splitter splitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        try (GTFReader gffReader = gtfFormat ? new GTFReader(annotationIs) : new GFFReader(annotationIs);){
            for (GFFEntry gff : gffReader) {
                if (!featureType.equals(gff.getType())) continue;
                String featureId = gff.getAttributeValue(attributeId);
                if (featureId == null) {
                    throw new KenetreException("Feature " + featureType + " does not contain a " + attributeId + " attribute");
                }
                if ((stranded == StrandUsage.YES || stranded == StrandUsage.REVERSE) && '.' == gff.getStrand()) {
                    throw new KenetreException("Feature " + featureType + " does not have strand information but you are running htseq-count in stranded mode.");
                }
                List featureIds = splitAttributeValues ? GuavaCompatibility.splitToList((Splitter)splitter, (CharSequence)featureId) : Collections.singletonList(featureId);
                for (String f : featureIds) {
                    features.addEntry(new GenomicInterval(gff, stranded.isSaveStrandInfo()), (Object)f);
                    counts.put(f, 0);
                }
            }
            gffReader.throwException();
        }
    }

    public static List<GenomicInterval> addIntervals(SAMRecord record, StrandUsage stranded) {
        if (record == null) {
            return null;
        }
        ArrayList<GenomicInterval> result = new ArrayList<GenomicInterval>();
        if (!record.getReadPairedFlag() || record.getReadPairedFlag() && record.getFirstOfPairFlag()) {
            if (stranded == StrandUsage.REVERSE) {
                result.addAll(HTSeqUtils.parseCigar(record.getCigar(), record.getReferenceName(), record.getAlignmentStart(), record.getReadNegativeStrandFlag() ? (char)'+' : '-'));
            } else {
                result.addAll(HTSeqUtils.parseCigar(record.getCigar(), record.getReferenceName(), record.getAlignmentStart(), record.getReadNegativeStrandFlag() ? (char)'-' : '+'));
            }
        } else if (record.getReadPairedFlag() && !record.getFirstOfPairFlag()) {
            if (stranded == StrandUsage.REVERSE) {
                result.addAll(HTSeqUtils.parseCigar(record.getCigar(), record.getReferenceName(), record.getAlignmentStart(), record.getReadNegativeStrandFlag() ? (char)'-' : '+'));
            } else {
                result.addAll(HTSeqUtils.parseCigar(record.getCigar(), record.getReferenceName(), record.getAlignmentStart(), record.getReadNegativeStrandFlag() ? (char)'+' : '-'));
            }
        } else {
            return null;
        }
        return result;
    }

    public static List<GenomicInterval> parseCigar(Cigar cigar, String chromosome, int start, char strand) {
        if (cigar == null) {
            return null;
        }
        ArrayList<GenomicInterval> result = new ArrayList<GenomicInterval>();
        int pos = start;
        block3: for (CigarElement ce : cigar.getCigarElements()) {
            int len = ce.getLength();
            CigarOperator co = ce.getOperator();
            switch (co) {
                case M: 
                case EQ: 
                case X: {
                    result.add(new GenomicInterval(chromosome, pos, pos + len - 1, strand));
                    pos += len;
                    continue block3;
                }
            }
            if (!co.consumesReferenceBases()) continue;
            pos += len;
        }
        return result;
    }

    public static Set<String> featuresOverlapped(List<GenomicInterval> ivList, GenomicArray<String> features, OverlapMode mode, StrandUsage stranded) throws KenetreException {
        HashSet<String> fs = null;
        if (mode == OverlapMode.UNION) {
            fs = new HashSet<String>();
            for (GenomicInterval iv : ivList) {
                String chr = iv.getChromosome();
                if (!features.containsChromosome(chr)) {
                    throw new UnknownChromosomeException(chr);
                }
                Map intervals = features.getEntries(chr, iv.getStart(), iv.getEnd());
                if (stranded == StrandUsage.YES || stranded == StrandUsage.REVERSE) {
                    HTSeqUtils.filterIntervalsStrands(intervals, iv.getStrand());
                }
                if (intervals == null || intervals.size() <= 0) continue;
                for (Map.Entry e : intervals.entrySet()) {
                    if (e.getValue() == null) continue;
                    fs.addAll((Collection)e.getValue());
                }
            }
        } else if (mode == OverlapMode.INTERSECTION_NONEMPTY || mode == OverlapMode.INTERSECTION_STRICT) {
            for (GenomicInterval iv : ivList) {
                String chr = iv.getChromosome();
                if (!features.containsChromosome(chr)) {
                    throw new KenetreException("Unknown chromosome: " + chr);
                }
                Map intervals = features.getEntries(chr, iv.getStart(), iv.getEnd());
                if (stranded == StrandUsage.YES || stranded == StrandUsage.REVERSE) {
                    HTSeqUtils.filterIntervalsStrands(intervals, iv.getStrand());
                }
                if (intervals.isEmpty()) {
                    Set emptySet = Collections.emptySet();
                    intervals.put(iv, emptySet);
                }
                if (intervals.size() <= 0) continue;
                for (Map.Entry i : intervals.entrySet()) {
                    Set fs2 = (Set)i.getValue();
                    if (fs2.size() <= 0 && mode != OverlapMode.INTERSECTION_STRICT) continue;
                    if (fs == null) {
                        fs = new HashSet(fs2);
                        continue;
                    }
                    fs.retainAll(fs2);
                }
            }
        } else {
            throw new KenetreException("Error : illegal overlap mode.");
        }
        if (fs == null) {
            return Collections.emptySet();
        }
        return fs;
    }

    private static void filterIntervalsStrands(Map<GenomicInterval, Set<String>> intervals, char strand) {
        if (intervals == null) {
            return;
        }
        HashSet<GenomicInterval> toRemove = new HashSet<GenomicInterval>();
        for (Map.Entry<GenomicInterval, Set<String>> e : intervals.entrySet()) {
            if (e.getKey().getStrand() == strand) continue;
            toRemove.add(e.getKey());
        }
        for (GenomicInterval iv : toRemove) {
            intervals.remove(iv);
        }
    }

    public static class UnknownChromosomeException
    extends KenetreException {
        private static final long serialVersionUID = -7074516037283735042L;

        public UnknownChromosomeException(String chromosome) {
            super("Unknown chromosome: " + chromosome);
        }
    }
}

