/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.it;

import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.it.ITCommandExecutor;
import fr.ens.biologie.genomique.kenetre.it.ITCommandResult;
import fr.ens.biologie.genomique.kenetre.it.ITFactory;
import fr.ens.biologie.genomique.kenetre.it.ITLogger;
import fr.ens.biologie.genomique.kenetre.it.ITOutput;
import fr.ens.biologie.genomique.kenetre.it.ITOutputComparisonResult;
import fr.ens.biologie.genomique.kenetre.it.ITResult;
import fr.ens.biologie.genomique.kenetre.it.ITSuite;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class IT {
    public static final Locale DEFAULT_LOCALE = Locale.US;
    public static final Splitter CMD_LINE_SPLITTER = Splitter.on((char)' ').trimResults().omitEmptyStrings();
    public static final String SEPARATOR = " ";
    static final String PREFIX_ENV_VAR = "env.var.";
    private static final List<String> PROPERTIES_TO_COMPILE = IT.loadList();
    private static final String TEST_SOURCE_LINK_NAME = "test-source";
    private static final String ENV_FILENAME = "ENV";
    private final Properties testConf;
    private final String testName;
    private final String description;
    private final File applicationPath;
    private final File testDataDirectory;
    private final File outputTestDirectory;
    private final File expectedTestDirectory;
    private final String fileToComparePatterns;
    private final String excludeToComparePatterns;
    private final String fileToRemovePatterns;
    private final String checkExistenceFilePatterns;
    private final String checkAbsenceFilePatterns;
    private final boolean generateExpectedDirectoryTestData;
    private final boolean generateAllExpectedDirectoryTest;
    private final boolean generateNewExpectedDirectoryTests;
    private final boolean manualGenerationExpectedData;
    private final ITResult itResult;
    private final List<String> environmentVariables;
    private final ITSuite itSuite;
    private final String checkLengthFilePatterns;
    private ITOutput itOutput = null;
    private boolean isRemoveFileRequired;

    @Test
    public final void launchTest() throws Exception {
        this.itSuite.notifyStartTest();
        Stopwatch timer = Stopwatch.createStarted();
        ITLogger.getLogger().info("Start test " + this.testName);
        ITLogger.getLogger().info("Test directory " + this.testDataDirectory.getAbsolutePath());
        ITLogger.getLogger().info("Output directory " + this.outputTestDirectory.getAbsolutePath());
        try {
            if (!this.isDataNeededToBeGenerated()) {
                this.itResult.asNothingToDo();
                return;
            }
            this.buildOutputDirectory();
            this.launchScriptsTest(this.itResult);
            this.itOutput = new ITOutput(this.outputTestDirectory, this.fileToComparePatterns, this.excludeToComparePatterns, this.checkLengthFilePatterns, this.checkExistenceFilePatterns, this.checkAbsenceFilePatterns, this.fileToRemovePatterns);
            if (this.generateExpectedDirectoryTestData) {
                this.itResult.asGeneratedData();
                this.createExpectedDirectory();
                this.itOutput.copyFiles(this.expectedTestDirectory);
            } else {
                Set<ITOutputComparisonResult> results = this.itOutput.compareTo(new ITOutput(this.expectedTestDirectory, this.fileToComparePatterns, this.excludeToComparePatterns, this.checkLengthFilePatterns, this.checkExistenceFilePatterns, this.checkAbsenceFilePatterns, this.fileToRemovePatterns));
                this.itResult.addComparisonsResults(results);
                if (!this.itResult.isSuccess()) {
                    throw this.itResult.getException();
                }
            }
        }
        catch (Throwable e) {
            this.itResult.setException(e);
            throw new Exception(this.itResult.createReportTestngMessage());
        }
        finally {
            if (this.itOutput != null) {
                this.itOutput.deleteFileMatchingOnPattern(this.itResult, this.isRemoveFileRequired);
            }
            timer.stop();
            ITLogger.getLogger().info("End of test " + this.testName);
            this.itResult.createReportFile(timer.elapsed(TimeUnit.MILLISECONDS));
            this.itSuite.notifyEndTest(this.itResult);
        }
    }

    private static List<String> loadList() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("excluded.files.to.compare");
        l.add("files.to.compare");
        l.add("files.to.remove");
        l.add("files.to.check.absence");
        l.add("files.to.check.existences");
        l.add("files.to.check.length");
        return Collections.unmodifiableList(l);
    }

    private boolean isKeyInCompileProperties(String keyToFind) {
        for (String key : PROPERTIES_TO_COMPILE) {
            if (!key.equals(keyToFind)) continue;
            return true;
        }
        return false;
    }

    private void launchScriptsTest(ITResult itResult) throws Throwable {
        FileUtils.checkExistingDirectoryFile((File)this.outputTestDirectory, (String)"output test directory");
        this.saveEnvironmentVariable();
        ITCommandExecutor cmdExecutor = new ITCommandExecutor(this.testConf, this.outputTestDirectory, this.environmentVariables, this.getDurationMaxInMinutes());
        boolean isApplicationCmdLine = true;
        this.executeCommand(cmdExecutor, itResult, "pre.global.script", "PRE_SCRIPT_GLOBAL", "global prescript");
        this.executeCommand(cmdExecutor, itResult, "pre.test.script", "PRE_SCRIPT", "test prescript");
        if (this.generateExpectedDirectoryTestData && this.manualGenerationExpectedData) {
            this.executeCommand(cmdExecutor, itResult, "command.to.generate.manually", "", "manual script to generate data", true);
        } else {
            this.executeCommand(cmdExecutor, itResult, "command.to.launch.application", "", "application", true);
        }
        this.executeCommand(cmdExecutor, itResult, "post.test.script", "POST_SCRIPT", "test postscript");
        this.executeCommand(cmdExecutor, itResult, "post.global.script", "POST_SCRIPT_GLOBAL", "global postscript");
    }

    private void executeCommand(ITCommandExecutor cmdExecutor, ITResult itResult, String keyConf, String suffixFilename, String desc) throws Throwable {
        this.executeCommand(cmdExecutor, itResult, keyConf, suffixFilename, desc, false);
    }

    private void executeCommand(ITCommandExecutor cmdExecutor, ITResult itResult, String keyConf, String suffixFilename, String desc, boolean isApplication) throws Throwable {
        ITCommandResult cmdResult = cmdExecutor.executeCommand(keyConf, suffixFilename, desc, isApplication);
        if (cmdResult == null) {
            return;
        }
        itResult.addCommandResult(cmdResult);
        if (cmdResult.isCaughtException()) {
            throw cmdResult.getException();
        }
    }

    private void saveEnvironmentVariable() {
        File envFile = new File(this.outputTestDirectory, ENV_FILENAME);
        if (this.environmentVariables != null && !this.environmentVariables.isEmpty()) {
            try {
                Files.write(envFile.toPath(), this.environmentVariables, new OpenOption[0]);
            }
            catch (IOException e) {
                ITLogger.getLogger().warning("Error while writing environment variables in file: " + e.getMessage());
            }
        }
    }

    private List<String> extractEnvironmentVariables() {
        ArrayList<String> envp = new ArrayList<String>();
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            envp.add(e.getKey() + "=" + e.getValue());
        }
        for (Object o : this.testConf.keySet()) {
            String keyProperty = (String)o;
            if (!keyProperty.startsWith(PREFIX_ENV_VAR)) continue;
            String keyEnvp = keyProperty.substring(PREFIX_ENV_VAR.length());
            String valEnvp = this.testConf.getProperty(keyProperty);
            envp.add(keyEnvp + "=" + valEnvp);
        }
        if (envp.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableList(envp);
    }

    private boolean isDataNeededToBeGenerated() throws IOException {
        if (!this.generateExpectedDirectoryTestData) {
            return true;
        }
        if (this.manualGenerationExpectedData) {
            return !this.expectedTestDirectory.exists();
        }
        if (this.generateAllExpectedDirectoryTest) {
            return true;
        }
        return this.generateNewExpectedDirectoryTests && !this.expectedTestDirectory.exists();
    }

    private void createExpectedDirectory() throws IOException {
        if (!this.generateExpectedDirectoryTestData) {
            return;
        }
        if ((this.manualGenerationExpectedData || this.generateNewExpectedDirectoryTests) && this.expectedTestDirectory.exists()) {
            return;
        }
        if (this.generateAllExpectedDirectoryTest && this.expectedTestDirectory.exists()) {
            FileUtils.recursiveDelete((File)this.expectedTestDirectory);
        }
        if (!this.expectedTestDirectory.exists() && !this.expectedTestDirectory.mkdir()) {
            throw new IOException(this.testName + ": error while create expected data directory: " + this.expectedTestDirectory.getAbsolutePath());
        }
    }

    private void buildOutputDirectory() throws IOException {
        if (this.outputTestDirectory.exists()) {
            throw new IOException("Test output directory already exists " + this.outputTestDirectory.getAbsolutePath());
        }
        if (!new File(this.outputTestDirectory + "/tmp").mkdirs()) {
            throw new IOException("Cannot create analysis directory " + this.outputTestDirectory.getAbsolutePath());
        }
        FileUtils.checkExistingDirectoryFile((File)this.testDataDirectory, (String)"input test directory");
        Path testSourcePath = Files.createSymbolicLink(new File(this.outputTestDirectory, TEST_SOURCE_LINK_NAME).toPath(), this.testDataDirectory.toPath(), new FileAttribute[0]);
        for (File file : this.testDataDirectory.listFiles()) {
            if (!file.isFile()) continue;
            Path target = new File(testSourcePath.toFile(), file.getName()).toPath();
            Path linkPath = new File(this.outputTestDirectory, file.getName()).toPath();
            ITSuite.createRelativeOrAbsoluteSymbolicLink(linkPath, target);
        }
    }

    private File retrieveExpectedDirectory() throws KenetreException, IOException {
        FileUtils.checkExistingDirectoryFile((File)this.testDataDirectory, (String)"output data parent directory");
        File[] expectedDirectories = this.testDataDirectory.listFiles(pathname -> pathname.getName().startsWith("expected"));
        if (expectedDirectories.length == 0 && !this.generateExpectedDirectoryTestData) {
            throw new KenetreException(this.testName + ": no expected directory found to launch test in " + this.testDataDirectory.getAbsolutePath());
        }
        if (expectedDirectories.length == 0 && this.generateExpectedDirectoryTestData) {
            String cmdToGetApplicationVersion = this.testConf.getProperty("command.to.get.application.version");
            String versionExpectedApplication = this.itSuite.retrieveVersionApplication(cmdToGetApplicationVersion, this.applicationPath);
            return new File(this.testDataDirectory, "/expected_" + (this.manualGenerationExpectedData ? "UNKNOWN" : versionExpectedApplication));
        }
        if (expectedDirectories.length > 1) {
            throw new KenetreException(this.testName + ": more one expected directory found in " + this.testDataDirectory.getAbsolutePath());
        }
        if (!expectedDirectories[0].isDirectory()) {
            throw new KenetreException(this.testName + ": no expected directory found in " + this.testDataDirectory.getAbsolutePath());
        }
        return expectedDirectories[0];
    }

    private String buildExcludePatterns(String valueConfigTests) {
        if (valueConfigTests == null || valueConfigTests.equals("none")) {
            return "**/test-source **/test.conf";
        }
        return "test-source test.conf " + valueConfigTests;
    }

    private Properties loadConfigurationFile(Properties globalsConf) throws IOException, KenetreException {
        File testConfFile = new File(this.testDataDirectory, "test.conf");
        FileUtils.checkExistingFile((File)testConfFile, (String)"test configuration file");
        Properties props = new Properties();
        props.putAll((Map<?, ?>)globalsConf);
        BufferedReader br = com.google.common.io.Files.newReader((File)testConfFile, (Charset)Charset.defaultCharset());
        String line = null;
        while ((line = br.readLine()) != null) {
            int pos;
            if (line.startsWith("#") || (pos = line.indexOf(61)) == -1) continue;
            String key = line.substring(0, pos).trim();
            String value = ITFactory.evaluateExpressions(line.substring(pos + 1).trim(), true);
            if (this.isKeyInCompileProperties(key) && props.containsKey(key)) {
                value = props.getProperty(key) + SEPARATOR + value;
            }
            props.put(key, value);
        }
        br.close();
        return props;
    }

    private String extractPattern(String propertyKey) {
        String patterns = this.testConf.getProperty(propertyKey);
        if (patterns == null || patterns.trim().isEmpty()) {
            return "none";
        }
        return patterns.trim();
    }

    public String getProperty(String key) {
        return this.testConf.getProperty(key);
    }

    public String getTestName() {
        return this.testName;
    }

    public File getExpectedTestDirectory() {
        return this.expectedTestDirectory;
    }

    public File getOutputTestDirectory() {
        return this.outputTestDirectory;
    }

    public String toString() {
        return this.description + ", files from pattern(s) " + this.fileToComparePatterns;
    }

    public String getFileToComparePatterns() {
        return this.fileToComparePatterns;
    }

    public String getFileToRemovePatterns() {
        return this.fileToRemovePatterns;
    }

    public String getExcludeToComparePatterns() {
        return this.excludeToComparePatterns;
    }

    public String getCheckExistenceFilePatterns() {
        return this.checkExistenceFilePatterns;
    }

    public String getCheckLengthFilePatterns() {
        return this.checkLengthFilePatterns;
    }

    public int getCountFilesToCheckContent() {
        return this.itOutput == null ? 0 : this.itOutput.getCountFilesToCheckContent();
    }

    public int getCountFilesToCheckLength() {
        return this.itOutput == null ? 0 : this.itOutput.getCountFilesToCheckLength();
    }

    public int getCountFilesToCheckExistence() {
        return this.itOutput == null ? 0 : this.itOutput.getCountFilesToCheckExistence();
    }

    public int getCountFilesToCompare() {
        return this.itOutput == null ? 0 : this.itOutput.getCountFilesToCompare();
    }

    public int getCountFilesToRemove() {
        return this.itOutput == null ? 0 : this.itOutput.getCountFilesToRemove();
    }

    public ITOutput getITOutput() {
        return this.itOutput;
    }

    public int getDurationMaxInMinutes() {
        String value = this.getProperty("runtime.test.maximum");
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            ITLogger.getLogger().severe("Duration set in configuration invalid " + value + ". Use default value " + 1);
            return 1;
        }
    }

    public IT(ITSuite itSuite, Properties globalsConf, File applicationPath, File testsDataDirectory, File outputTestsDirectory, String testName) throws IOException, KenetreException {
        FileUtils.checkExistingDirectoryFile((File)testsDataDirectory, (String)"tests data directory");
        FileUtils.checkExistingDirectoryFile((File)outputTestsDirectory, (String)"output tests directory");
        FileUtils.checkExistingDirectoryFile((File)applicationPath, (String)"application path");
        this.itSuite = itSuite;
        this.applicationPath = applicationPath;
        this.testName = testName;
        this.testDataDirectory = new File(testsDataDirectory, this.testName);
        this.outputTestDirectory = new File(outputTestsDirectory, this.testName);
        this.testConf = this.loadConfigurationFile(globalsConf);
        this.environmentVariables = this.extractEnvironmentVariables();
        this.itResult = new ITResult(this);
        this.isRemoveFileRequired = Boolean.parseBoolean(this.testConf.getProperty("success.it.delete.file"));
        this.generateAllExpectedDirectoryTest = this.itSuite.isGenerateAllExpectedDirectoryTest();
        this.generateNewExpectedDirectoryTests = this.itSuite.isGenerateNewExpectedDirectoryTests();
        this.generateExpectedDirectoryTestData = this.generateAllExpectedDirectoryTest || this.generateNewExpectedDirectoryTests;
        this.manualGenerationExpectedData = Boolean.parseBoolean(this.testConf.getProperty("manual.generation.expected.data"));
        this.expectedTestDirectory = this.retrieveExpectedDirectory();
        this.fileToComparePatterns = this.extractPattern("files.to.compare");
        this.fileToRemovePatterns = this.extractPattern("files.to.remove");
        this.excludeToComparePatterns = this.buildExcludePatterns(this.extractPattern("excluded.files.to.compare"));
        this.checkExistenceFilePatterns = this.extractPattern("files.to.check.existences");
        this.checkLengthFilePatterns = this.extractPattern("files.to.check.length");
        this.checkAbsenceFilePatterns = this.testConf.getProperty("files.to.check.absence");
        this.description = this.testConf.containsKey("description") ? this.testConf.getProperty("description") + ", action: " + this.itSuite.getActionType() : this.testName + ", action: " + this.itSuite.getActionType();
    }
}

