/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.it;

import com.google.common.io.Files;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public class ITCommandResult {
    private final File directory;
    private final String commandLine;
    private final String desc;
    private final StringBuilder message;
    private Throwable exception;
    private int exitValue = -1;
    private long duration = -1L;
    private final long durationMaxToInterruptProcess;
    private String exceptionMessage;
    private boolean interruptedProcess = false;
    private File stderrFile;
    private boolean isReportCreated = false;

    public boolean isEmpty() {
        return this.message.toString().isEmpty();
    }

    public String getReport() {
        if (this.isReportCreated) {
            return this.message.toString();
        }
        this.message.append("\nExecute ");
        this.message.append(this.desc);
        this.message.append(":");
        this.message.append("\n\tCommand line: ");
        this.message.append(this.commandLine);
        this.message.append("\n\tDirectory: ");
        this.message.append(this.directory.getAbsolutePath());
        this.message.append("\n\tDuration: ");
        this.message.append(this.duration == -1L ? "none" : StringUtils.toTimeHumanReadable((long)this.duration));
        this.message.append("\n\tMessage: exit value ");
        this.message.append(this.exitValue);
        this.message.append(this.getSTDERRMessageOnProcess());
        if (this.isInterruptedProcess()) {
            this.message.append("\n\tInterrupt process after: ");
            this.message.append(StringUtils.toTimeHumanReadable((long)this.durationMaxToInterruptProcess));
        }
        this.message.append("\n");
        this.isReportCreated = true;
        return this.message.toString();
    }

    public String getSTDERRMessageOnProcess() {
        if (this.stderrFile == null || !this.stderrFile.exists()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n\tCopy content of standard error file from: ");
        sb.append(this.stderrFile.getAbsolutePath());
        sb.append('\n');
        try (BufferedReader br = Files.newReader((File)this.stderrFile, (Charset)Charset.defaultCharset());){
            String line = "";
            while ((line = br.readLine()) != null) {
                sb.append("\n\t\t");
                sb.append(line);
            }
            sb.append("\nEnd file\n\n");
        }
        catch (IOException e) {
            sb.append("\nAn error occurs during read file ");
            sb.append(this.stderrFile.getAbsolutePath());
            sb.append("\n\n");
        }
        return sb.toString();
    }

    public boolean isCaughtException() {
        return this.exception != null;
    }

    public void setExitValue(int exitValue) {
        this.exitValue = exitValue;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.setException(exception, "");
    }

    public void setException(Exception exception, String message) {
        this.exception = exception;
        this.exceptionMessage = message;
    }

    public void setErrorFileOnProcess(File stderrFile) {
        this.stderrFile = stderrFile;
    }

    public boolean asErrorFileSave() {
        return this.stderrFile != null && this.stderrFile.exists();
    }

    public boolean isInterruptedProcess() {
        return this.interruptedProcess;
    }

    public void asInterruptedProcess() {
        this.interruptedProcess = true;
    }

    ITCommandResult(String commandLine, File directory, String desc, int duration) {
        this.commandLine = commandLine;
        this.directory = directory;
        this.desc = desc;
        this.durationMaxToInterruptProcess = duration * 60 * 1000;
        this.message = new StringBuilder();
    }
}

