/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.it;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.it.ITOutputComparisonResult;
import fr.ens.biologie.genomique.kenetre.it.ITResult;
import fr.ens.biologie.genomique.kenetre.it.comparator.BAMComparator;
import fr.ens.biologie.genomique.kenetre.it.comparator.BinaryComparator;
import fr.ens.biologie.genomique.kenetre.it.comparator.Comparator;
import fr.ens.biologie.genomique.kenetre.it.comparator.FastqComparator;
import fr.ens.biologie.genomique.kenetre.it.comparator.LogComparator;
import fr.ens.biologie.genomique.kenetre.it.comparator.SAMComparator;
import fr.ens.biologie.genomique.kenetre.it.comparator.TextComparator;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class ITOutput {
    private static final Splitter SPACE_SPLITTER = Splitter.on((char)' ').trimResults().omitEmptyStrings();
    private static final PathMatcher ALL_PATH_MATCHER = FileSystems.getDefault().getPathMatcher("glob:*");
    private static final boolean USE_DEFAULT_PATTERN = true;
    private static final double PART_DIFFERENCE_LENGTH_FILE = 0.01;
    private final String fileToComparePatterns;
    private final String fileToRemovePatterns;
    private final String excludeToComparePatterns;
    private final String checkExistenceFilePatterns;
    private final String checkAbsenceFilePatterns;
    private final String checkLengthFilePatterns;
    private final List<File> filesToCompare;
    private final List<File> filesToRemove;
    private final List<File> filesToExclude;
    private final List<File> filesToCheckExistence;
    private final List<File> filesToCheckLength;
    private final List<File> filesToCheckAbsence;
    private final List<File> filesToCheckContent;
    private final File directory;

    public final void copyFiles(File destinationDirectory) throws IOException, KenetreException {
        boolean noFileFoundToCopy = true;
        if (this.filesToCompare.isEmpty()) {
            return;
        }
        for (File f : this.filesToCompare) {
            String filename = f.getName();
            if (new File(destinationDirectory, filename).exists()) continue;
            File dest = new File(destinationDirectory, filename);
            if (Files.copy(f.toPath(), dest.toPath(), new CopyOption[0]) == null) {
                throw new IOException("Error when moving file " + filename + " to " + destinationDirectory.getAbsolutePath() + ".");
            }
            noFileFoundToCopy = false;
        }
        if (noFileFoundToCopy) {
            String msg = "Fail: none file to copy in destination " + destinationDirectory.getAbsolutePath();
            throw new KenetreException(msg);
        }
    }

    public final Set<ITOutputComparisonResult> compareTo(ITOutput expectedOutput) throws IOException {
        TreeSet<ITOutputComparisonResult> results = new TreeSet<ITOutputComparisonResult>();
        ArrayList allFilesFromTest = Lists.newArrayList(this.filesToCompare);
        HashMap<String, File> filesTestedMap = new HashMap<String, File>(this.filesToCompare.size());
        for (File f : allFilesFromTest) {
            filesTestedMap.put(f.getName(), f);
        }
        for (File fileExpected : expectedOutput.getFilesToCompare()) {
            String filename = fileExpected.getName();
            File fileTested = (File)filesTestedMap.get(filename);
            ITOutputComparisonResult comparisonResult = new ITOutputComparisonResult(filename);
            if (fileTested == null) {
                comparisonResult.setResult(ITOutputComparisonResult.StatusComparison.MISSING, "missing file in output test directory " + this.directory.getAbsolutePath());
            } else {
                this.compareFiles(comparisonResult, fileExpected, fileTested);
            }
            allFilesFromTest.remove(fileTested);
            results.add(comparisonResult);
        }
        if (!allFilesFromTest.isEmpty()) {
            for (File f : allFilesFromTest) {
                ITOutputComparisonResult ocr = new ITOutputComparisonResult(f.getName(), ITOutputComparisonResult.StatusComparison.UNEXPECTED, "unexpected file in test data directory " + expectedOutput.getDirectory().getAbsolutePath());
                results.add(ocr);
            }
        }
        results.addAll(this.checkAbsenceFileFromPatterns());
        if (results.isEmpty()) {
            return Collections.emptySet();
        }
        return results;
    }

    public void deleteFileMatchingOnPattern(ITResult itResult, boolean isDeleteFileRequired) {
        ArrayList<File> linksSymbolic = new ArrayList<File>();
        StringBuilder msg = new StringBuilder();
        msg.append("\nClean output directory:\n");
        boolean success = true;
        if (!itResult.isSuccess()) {
            msg.append(isDeleteFileRequired ? "\tConfiguration required to delete files, but test fail. Files still exist in " : "\tConfiguration required always to keep files in ");
            msg.append(this.directory.getAbsolutePath());
        }
        if (itResult.isSuccess() && isDeleteFileRequired) {
            msg.append("\tTest succeeded.");
            msg.append("\n\tConfiguration required to delete files from directory ");
            msg.append(this.directory.getAbsolutePath());
            for (File f : this.getFilesToRemove()) {
                if (Files.isSymbolicLink(f.toPath())) {
                    linksSymbolic.add(f);
                    continue;
                }
                if (f.delete()) continue;
                success = false;
                msg.append("\n\tFail to delete file ");
                msg.append(f.getAbsolutePath());
            }
            String s = this.removeBrokenSymbolicLink(linksSymbolic);
            msg.append(s);
            if (success) {
                msg.append("\n\tAll deletions successful.");
            }
        } else {
            msg.append("\n\tDelete file matching on patterns no required.");
        }
        itResult.addCommentsIntoTextReport(msg.toString());
    }

    private String removeBrokenSymbolicLink(List<File> linksSymbolic) {
        StringBuilder msg = new StringBuilder();
        for (File link : linksSymbolic) {
            File realFile = null;
            try {
                realFile = Files.readSymbolicLink(link.toPath()).toFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (realFile == null || realFile.exists() || !link.delete()) continue;
            msg.append("\n\tFail to delete broken symbolic link file ");
            msg.append(link.getName());
        }
        return msg.toString();
    }

    private void compareFiles(ITOutputComparisonResult comparisonResult, File fileExpected, File fileTested) throws IOException {
        if (this.filesToCheckContent.contains(fileTested)) {
            this.compareFilesContent(comparisonResult, fileExpected, fileTested);
        } else if (this.filesToCheckLength.contains(fileTested)) {
            this.compareFilesLength(comparisonResult, fileExpected, fileTested);
        } else if (this.filesToCheckExistence.contains(fileTested)) {
            this.compareFilesExistence(comparisonResult, fileExpected, fileTested);
        }
    }

    private void compareFilesContent(ITOutputComparisonResult comparisonResult, File fileExpected, File fileTested) throws IOException {
        FilesComparator fc = new FilesComparator(fileExpected, fileTested);
        boolean res = fc.compare();
        if (!res) {
            comparisonResult.setResult(ITOutputComparisonResult.StatusComparison.NOT_EQUALS, fileExpected, fileTested, fc.getDetailComparison());
        } else {
            comparisonResult.setResult(ITOutputComparisonResult.StatusComparison.EQUALS);
        }
    }

    private void compareFilesLength(ITOutputComparisonResult comparisonResult, File fileExpected, File fileTested) {
        long diffLengthMax;
        long fileTestedLength;
        long fileExpectedLength = fileExpected.length();
        long diffLength = fileExpectedLength - (fileTestedLength = fileTested.length());
        boolean isEqualsLength = diffLength < (diffLengthMax = (long)((double)fileExpectedLength * 0.01));
        String msg = "";
        if (isEqualsLength) {
            comparisonResult.setResult(ITOutputComparisonResult.StatusComparison.EQUALS);
        } else {
            msg = String.format("length expected: %s (%d) vs tested %s (%d)%n", fileExpected.getAbsolutePath(), fileExpectedLength, fileTested.getAbsolutePath(), fileTestedLength);
            comparisonResult.setResult(ITOutputComparisonResult.StatusComparison.NOT_EQUALS, fileExpected, fileTested, msg);
        }
    }

    private void compareFilesExistence(ITOutputComparisonResult comparisonResult, File fileExpected, File fileTested) {
        long fileExpectedLength = fileExpected.length();
        long fileTestedLength = fileTested.length();
        if (fileTestedLength > 0L || fileExpectedLength == 0L) {
            comparisonResult.setResult(ITOutputComparisonResult.StatusComparison.EQUALS);
        } else {
            comparisonResult.setResult(ITOutputComparisonResult.StatusComparison.NOT_EQUALS, fileExpected, fileTested, "file tested can not be empty.");
        }
    }

    private Set<ITOutputComparisonResult> checkAbsenceFileFromPatterns() throws IOException {
        HashSet<ITOutputComparisonResult> results = new HashSet<ITOutputComparisonResult>();
        for (File f : this.filesToCheckAbsence) {
            ITOutputComparisonResult ocr = new ITOutputComparisonResult(f.getName(), ITOutputComparisonResult.StatusComparison.UNEXPECTED, "Unexpected file in output test directory matched to patterns " + this.checkAbsenceFilePatterns);
            results.add(ocr);
        }
        return results;
    }

    private List<File> collectFilesFromPattern(String patternKey, boolean defaultAllPath) throws IOException {
        Set<PathMatcher> fileMatcher = ITOutput.createPathMatchers(patternKey, defaultAllPath);
        List<File> files = this.listingFilesFromPatterns(fileMatcher);
        if (this.filesToExclude != null && !this.filesToExclude.isEmpty()) {
            files.removeAll(this.filesToExclude);
        }
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(files);
    }

    private List<File> collectFilesFromPattern(String patternKey) throws IOException {
        return this.collectFilesFromPattern(patternKey, false);
    }

    private List<File> listingFilesFromPatterns(Set<PathMatcher> patterns) throws IOException {
        final ArrayList<File> matchedFiles = new ArrayList<File>();
        for (final PathMatcher matcher : patterns) {
            Files.walkFileTree(Paths.get(this.directory.toURI()), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (matcher.matches(file)) {
                        matchedFiles.add(file.toFile());
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        if (matchedFiles.isEmpty()) {
            return Collections.emptyList();
        }
        return matchedFiles;
    }

    private static Set<PathMatcher> createPathMatchers(String patterns, boolean defaultAllPath) {
        if (patterns == null || patterns.trim().isEmpty()) {
            if (defaultAllPath) {
                return Collections.singleton(ALL_PATH_MATCHER);
            }
            return Collections.emptySet();
        }
        HashSet<PathMatcher> result = new HashSet<PathMatcher>();
        for (String globSyntax : SPACE_SPLITTER.split((CharSequence)patterns)) {
            PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + globSyntax);
            result.add(matcher);
        }
        return Collections.unmodifiableSet(result);
    }

    private File getDirectory() {
        return this.directory;
    }

    public List<File> getFilesToCheckLength() {
        return Collections.unmodifiableList(this.filesToCheckLength);
    }

    public List<File> getFilesToCheckContent() {
        return Collections.unmodifiableList(this.filesToCheckContent);
    }

    public List<File> getFilesToCheckAbsence() {
        return Collections.unmodifiableList(this.filesToCheckAbsence);
    }

    public List<File> getFilesToCheckExistence() {
        return Collections.unmodifiableList(this.filesToCheckExistence);
    }

    public List<File> getFilesToCompare() {
        return Collections.unmodifiableList(this.filesToCompare);
    }

    public List<File> getFilesToRemove() {
        return Collections.unmodifiableList(this.filesToRemove);
    }

    public int getCountFilesToCheckContent() {
        return this.filesToCheckContent.size();
    }

    public int getCountFilesToCheckLength() {
        return this.filesToCheckLength.size();
    }

    public int getCountFilesToCheckExistence() {
        return this.filesToCheckExistence.size();
    }

    public int getCountFilesToCheckAbsence() {
        return this.filesToCheckAbsence.size();
    }

    public int getCountFilesToCompare() {
        return this.filesToCompare.size();
    }

    public int getCountFilesToRemove() {
        return this.filesToRemove.size();
    }

    public ITOutput(File outputTestDirectory, String fileToComparePatterns, String excludeToComparePatterns, String checkLengthFilePatterns, String checkExistenceFilePatterns, String checkAbsenceFilePatterns, String fileToRemovePatterns) throws IOException, KenetreException {
        this.directory = outputTestDirectory;
        this.fileToComparePatterns = fileToComparePatterns;
        this.fileToRemovePatterns = fileToRemovePatterns;
        this.excludeToComparePatterns = excludeToComparePatterns;
        this.checkLengthFilePatterns = checkLengthFilePatterns;
        this.checkExistenceFilePatterns = checkExistenceFilePatterns;
        this.checkAbsenceFilePatterns = checkAbsenceFilePatterns;
        this.filesToCompare = new ArrayList<File>();
        this.filesToExclude = this.collectFilesFromPattern(this.excludeToComparePatterns);
        this.filesToCheckContent = this.collectFilesFromPattern(this.fileToComparePatterns, true);
        this.filesToCheckExistence = this.collectFilesFromPattern(this.checkExistenceFilePatterns);
        this.filesToCheckLength = this.collectFilesFromPattern(this.checkLengthFilePatterns);
        this.filesToCheckAbsence = this.collectFilesFromPattern(this.checkAbsenceFilePatterns);
        this.filesToRemove = this.collectFilesFromPattern(this.fileToRemovePatterns);
        this.filesToCompare.addAll(this.filesToCheckContent);
        this.filesToCompare.addAll(this.filesToCheckLength);
        this.filesToCompare.addAll(this.filesToCheckExistence);
    }

    private static final class FilesComparator {
        private final List<Comparator> comparators = new ArrayList<Comparator>();
        private static final boolean USE_SERIALIZATION_FILE = true;
        private final File fileA;
        private final File fileB;
        private final Comparator comparator;
        private String detailComparison = "SUCCESS";

        public boolean compare() throws IOException {
            boolean b = this.comparator.compareFiles(this.fileA, this.fileB);
            if (!b) {
                this.detailComparison = "fail at comparison #" + this.comparator.getNumberElementsCompared() + ":[ " + this.comparator.getCauseFailComparison() + "]";
            }
            return b;
        }

        private Comparator findComparator(String filename) {
            String extension = StringUtils.extensionWithoutCompressionExtension((String)filename);
            for (Comparator comp : this.comparators) {
                if (!comp.getExtensions().contains(extension)) continue;
                return comp;
            }
            return this.comparators.get(0);
        }

        public String getDetailComparison() {
            return this.detailComparison;
        }

        FilesComparator(File fileA, File fileB) {
            this.fileA = fileA;
            this.fileB = fileB;
            this.comparators.add(new BinaryComparator());
            this.comparators.add(new FastqComparator(true));
            this.comparators.add(new SAMComparator(true, "PG", "HD", "CO"));
            this.comparators.add(new BAMComparator(true, "PG", "HD", "CO"));
            this.comparators.add(new TextComparator(true));
            this.comparators.add(new LogComparator());
            this.comparator = this.findComparator(this.fileA.getName());
        }
    }
}

