/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.it;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.it.IT;
import fr.ens.biologie.genomique.kenetre.it.ITCommandResult;
import fr.ens.biologie.genomique.kenetre.it.ITLogger;
import fr.ens.biologie.genomique.kenetre.it.ITOutputComparisonResult;
import fr.ens.biologie.genomique.kenetre.it.ITSuite;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class ITResult {
    private final IT it;
    private final StringBuilder commentForReport;
    private Throwable exception;
    private final List<ITCommandResult> commandsResults;
    private Set<ITOutputComparisonResult> comparisonsResults;
    private boolean generatedData = false;
    private boolean nothingToDo = false;

    public void createReportFile(long duration) {
        String durationIT = StringUtils.toTimeHumanReadable((long)duration);
        this.updateLogger(durationIT);
        if (this.isNothingToDo()) {
            return;
        }
        String filename = this.isSuccess() ? "SUCCESS" : "FAIL";
        File reportFile = new File(this.it.getOutputTestDirectory(), filename);
        try {
            BufferedWriter fw = com.google.common.io.Files.newWriter((File)reportFile, (Charset)Charset.defaultCharset());
            fw.write(this.createReportText(true, durationIT));
            fw.write("\n");
            ((Writer)fw).flush();
            ((Writer)fw).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.isGeneratedData()) {
            try {
                Files.copy(reportFile.toPath(), new File(this.it.getExpectedTestDirectory(), filename).toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                ITLogger.getLogger().warning("Error while copying the result execution integration test in expected directory: " + e.getMessage());
            }
        }
    }

    public String createReportTestngMessage() {
        if (this.isSuccess()) {
            return "";
        }
        String txt = "Fail test: " + this.it.getTestName();
        txt = txt + "\n\tdirectory: " + this.it.getOutputTestDirectory();
        txt = txt + this.createExceptionText(false);
        return txt;
    }

    private void updateLogger(String duration) {
        String txt = "";
        if (this.nothingToDo) {
            txt = txt + "NOTHING TO DO of the " + this.it.getTestName();
        } else {
            txt = txt + (this.isSuccess() ? "SUCCESS" : "FAIL") + " of the test " + this.it.getTestName() + (this.isGeneratedData() ? ": generate expected data" : ": launch test and comparison") + ". Duration = " + duration;
            if (!this.isSuccess()) {
                txt = txt + this.createExceptionText(false);
            }
        }
        ITLogger.getLogger().info(txt);
    }

    private String createReportText(boolean withStackTrace, String duration) {
        StringBuilder report = new StringBuilder();
        report.append(this.isSuccess() ? "SUCCESS" : "FAIL");
        report.append(": ");
        report.append(this.it.getTestName());
        report.append(this.isGeneratedData() ? ": generate expected data" : ": test execution and output files comparison.");
        report.append("\n\nDate: ");
        report.append(this.getCurrentFormatedDate());
        report.append('\n');
        report.append("\n\nDirectories:");
        report.append("\n\tExpected:");
        report.append(this.it.getExpectedTestDirectory().getAbsolutePath());
        report.append("\n\tOuput:");
        report.append(this.it.getOutputTestDirectory().getAbsolutePath());
        report.append("\n\nPatterns:");
        report.append("\n\tFile count to compare from pattern(s): ");
        report.append(this.it.getFileToComparePatterns());
        if (!this.it.getFileToComparePatterns().equals("none")) {
            report.append(": ");
            report.append(this.it.getCountFilesToCheckContent());
            report.append(" file(s)");
        }
        report.append("\n\tFile lengths count to check from pattern(s): ");
        report.append(this.it.getCheckLengthFilePatterns());
        if (!this.it.getCheckLengthFilePatterns().equals("none")) {
            report.append(": ");
            report.append(this.it.getCountFilesToCheckLength());
            report.append(" file(s)");
        }
        report.append("\n\tFile count to check if it exists from pattern(s): ");
        report.append(this.it.getCheckExistenceFilePatterns());
        if (!this.it.getCheckExistenceFilePatterns().equals("none")) {
            report.append(": ");
            report.append(this.it.getCountFilesToCheckExistence());
            report.append(" file(s)");
        }
        report.append("\n\tPatterns files to exclude comparisons:\t");
        report.append(this.it.getExcludeToComparePatterns());
        report.append("\n\tFile count to remove from pattern(s) if test succeeded: ");
        report.append(this.it.getFileToRemovePatterns());
        if (!this.it.getFileToRemovePatterns().equals("none")) {
            report.append(": ");
            report.append(this.it.getCountFilesToRemove());
            report.append(" file(s)");
        }
        report.append("\n\nDuration one script maximum: ");
        report.append(StringUtils.toTimeHumanReadable((long)(this.it.getDurationMaxInMinutes() * 60 * 1000)));
        report.append('\n');
        if (!this.commandsResults.isEmpty()) {
            for (ITCommandResult icr : this.commandsResults) {
                report.append(icr.getReport());
            }
        }
        if (this.isGeneratedData()) {
            report.append("\nSUCCESS: copy files ");
            report.append(this.it.getCountFilesToCompare());
            report.append(" to ");
            report.append(this.it.getExpectedTestDirectory().getAbsolutePath());
        }
        if (this.comparisonsResults.isEmpty()) {
            if (this.exception != null) {
                report.append('\n');
                report.append(this.createExceptionText(withStackTrace));
                report.append('\n');
            }
        } else {
            report.append("\n\nComparisons:");
            for (ITOutputComparisonResult ocr : this.comparisonsResults) {
                report.append('\n');
                report.append(ocr.getReport());
            }
            report.append('\n');
        }
        if (this.commentForReport.length() > 0) {
            report.append(this.commentForReport.toString());
        }
        report.append("\n\nTest duration: ");
        report.append(duration);
        return report.toString();
    }

    private String getCurrentFormatedDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd kk:mm:ss", IT.DEFAULT_LOCALE);
        return df.format(new Date());
    }

    public void checkNeededThrowException() {
        if (this.comparisonsResults.isEmpty()) {
            return;
        }
        for (ITOutputComparisonResult ocr : this.comparisonsResults) {
            if (ocr.getStatusComparison().isSuccess()) continue;
            StringBuilder msg = new StringBuilder();
            if (this.getException() != null) {
                msg.append(this.getException().getMessage());
                msg.append("\n");
            }
            msg.append("\t");
            msg.append(ocr.getStatusComparison().getExceptionMessage());
            msg.append("\t");
            msg.append(ocr.getFilename());
            this.setException((Throwable)new KenetreException(msg.toString()));
        }
    }

    public String createExceptionText(boolean withStackTrace) {
        ITCommandResult lastCommandResult;
        if (this.exception == null) {
            return "";
        }
        StringBuilder msgException = new StringBuilder();
        msgException.append("\n=== Execution Test Error ===");
        msgException.append("\nFrom class: \n\t");
        msgException.append(this.exception.getClass().getName());
        msgException.append("\nException message: \n");
        msgException.append(this.exception.getMessage());
        msgException.append("\n");
        if (ITSuite.getInstance().isDebugModeEnabled() && withStackTrace) {
            StringWriter sw = new StringWriter();
            this.exception.printStackTrace(new PrintWriter(sw));
            msgException.append("\n=== Execution Test Debug Stack Trace ===\n");
            msgException.append(sw.toString());
        }
        if ((lastCommandResult = this.commandsResults.get(this.commandsResults.size() - 1)).asErrorFileSave()) {
            msgException.append(lastCommandResult.getSTDERRMessageOnProcess());
        }
        return msgException.toString();
    }

    public void addCommandResult(ITCommandResult cmdResult) {
        if (cmdResult != null) {
            this.commandsResults.add(cmdResult);
        }
    }

    public void addComparisonsResults(Set<ITOutputComparisonResult> comparisonsResults) {
        if (comparisonsResults != null) {
            this.comparisonsResults = comparisonsResults;
        }
        this.checkNeededThrowException();
    }

    public void addCommentsIntoTextReport(String msg) {
        this.commentForReport.append(msg);
    }

    public void asGeneratedData() {
        this.generatedData = true;
    }

    public boolean isGeneratedData() {
        return this.generatedData;
    }

    public boolean isSuccess() {
        return this.exception == null;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable e) {
        this.exception = e;
    }

    public void asNothingToDo() {
        this.nothingToDo = true;
    }

    public boolean isNothingToDo() {
        return this.nothingToDo;
    }

    public ITResult(IT it) {
        this.it = it;
        this.commandsResults = new ArrayList<ITCommandResult>();
        this.comparisonsResults = Collections.emptySet();
        this.commentForReport = new StringBuilder();
    }
}

