/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.it.comparator;

import com.google.common.collect.Sets;
import fr.ens.biologie.genomique.kenetre.io.ReporterLogReader;
import fr.ens.biologie.genomique.kenetre.it.comparator.AbstractComparator;
import fr.ens.biologie.genomique.kenetre.util.Reporter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;

public class LogComparator
extends AbstractComparator {
    private static final String COMPARATOR_NAME = "LogComparator";
    private static final Collection<String> EXTENSIONS = Sets.newHashSet((Object[])new String[]{".log"});
    private int numberElementsCompared;

    @Override
    public boolean compareFiles(InputStream isA, InputStream isB) throws IOException {
        Reporter logExpected = new ReporterLogReader(isA).read();
        Reporter logTested = new ReporterLogReader(isB).read();
        int numberElements = 0;
        for (String counterGroup : logExpected.getCounterGroups()) {
            numberElements += logExpected.getCounterNames(counterGroup).size();
            for (String counter : logExpected.getCounterNames(counterGroup)) {
                ++this.numberElementsCompared;
                long diffExpectedTested = logExpected.getCounterValue(counterGroup, counter) - this.getCounterValue(logTested, counterGroup, counter);
                if (Math.abs(diffExpectedTested) < 1L) continue;
                this.setCauseFailComparison("Invalid value found: " + this.getCounterValue(logTested, counterGroup, counter) + ", " + logExpected.getCounterValue(counterGroup, counter) + " was expected.");
                return false;
            }
        }
        if (numberElements != this.numberElementsCompared) {
            this.setCauseFailComparison("Found " + this.numberElementsCompared + " elements, " + numberElements + " were expected.");
            return false;
        }
        return true;
    }

    private long getCounterValue(Reporter logTested, String counterGroupExpected, String counter) {
        int pos = counterGroupExpected.indexOf(",");
        String prefix = counterGroupExpected.substring(0, pos);
        for (String counterGroup : logTested.getCounterGroups()) {
            if (!counterGroup.startsWith(prefix)) continue;
            return logTested.getCounterValue(counterGroup, counter);
        }
        return -1L;
    }

    @Override
    public Collection<String> getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getName() {
        return COMPARATOR_NAME;
    }

    @Override
    public int getNumberElementsCompared() {
        return this.numberElementsCompared;
    }
}

