/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.it.comparator;

import com.google.common.collect.Sets;
import fr.ens.biologie.genomique.eoulsan.util.EnhancedBloomFilter;
import fr.ens.biologie.genomique.kenetre.it.comparator.AbstractComparatorWithBloomFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;

public class TextComparator
extends AbstractComparatorWithBloomFilter {
    private static final String NAME_COMPARATOR = "TextComparator";
    private static final Collection<String> EXTENSIONS = Sets.newHashSet((Object[])new String[]{".txt", ".tsv", ".csv", ".xml"});
    private int numberElementsCompared;

    @Override
    public boolean compareFiles(EnhancedBloomFilter filter, InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.defaultCharset()));
        String line = null;
        this.numberElementsCompared = 0;
        while ((line = reader.readLine()) != null) {
            ++this.numberElementsCompared;
            if (filter.mightContain(line)) continue;
            this.setCauseFailComparison(line);
            reader.close();
            return false;
        }
        reader.close();
        if (this.numberElementsCompared != filter.getAddedNumberOfElements()) {
            this.setCauseFailComparison("Different count elements " + this.numberElementsCompared + " was " + filter.getAddedNumberOfElements() + " expected.");
            return false;
        }
        return true;
    }

    @Override
    public Collection<String> getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getName() {
        return NAME_COMPARATOR;
    }

    @Override
    public int getNumberElementsCompared() {
        return this.numberElementsCompared;
    }

    public TextComparator(boolean useSerializeFile) {
        super(useSerializeFile);
    }
}

