/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna;

public class TerminalSize {
    public static final TerminalSize ZERO = new TerminalSize(0, 0);
    public static final TerminalSize ONE = new TerminalSize(1, 1);
    private final int columns;
    private final int rows;

    public TerminalSize(int columns, int rows) {
        if (columns < 0) {
            throw new IllegalArgumentException("TerminalSize.columns cannot be less than 0!");
        }
        if (rows < 0) {
            throw new IllegalArgumentException("TerminalSize.rows cannot be less than 0!");
        }
        this.columns = columns;
        this.rows = rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public TerminalSize withColumns(int columns) {
        if (this.columns == columns) {
            return this;
        }
        if (columns == 0 && this.rows == 0) {
            return ZERO;
        }
        return new TerminalSize(columns, this.rows);
    }

    public int getRows() {
        return this.rows;
    }

    public TerminalSize withRows(int rows) {
        if (this.rows == rows) {
            return this;
        }
        if (rows == 0 && this.columns == 0) {
            return ZERO;
        }
        return new TerminalSize(this.columns, rows);
    }

    public TerminalSize withRelativeColumns(int delta) {
        if (delta == 0) {
            return this;
        }
        return this.withColumns(this.columns + delta);
    }

    public TerminalSize withRelativeRows(int delta) {
        if (delta == 0) {
            return this;
        }
        return this.withRows(this.rows + delta);
    }

    public TerminalSize withRelative(TerminalSize delta) {
        return this.withRelative(delta.getColumns(), delta.getRows());
    }

    public TerminalSize withRelative(int deltaColumns, int deltaRows) {
        return this.withRelativeRows(deltaRows).withRelativeColumns(deltaColumns);
    }

    public TerminalSize max(TerminalSize other) {
        return this.withColumns(Math.max(this.columns, other.columns)).withRows(Math.max(this.rows, other.rows));
    }

    public TerminalSize min(TerminalSize other) {
        return this.withColumns(Math.min(this.columns, other.columns)).withRows(Math.min(this.rows, other.rows));
    }

    public TerminalSize with(TerminalSize size) {
        if (this.equals(size)) {
            return this;
        }
        return size;
    }

    public String toString() {
        return "{" + this.columns + "x" + this.rows + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TerminalSize)) {
            return false;
        }
        TerminalSize other = (TerminalSize)obj;
        return this.columns == other.columns && this.rows == other.rows;
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + this.columns;
        hash = 53 * hash + this.rows;
        return hash;
    }
}

