/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.graphics.Theme;
import com.googlecode.lanterna.gui2.AbstractComposite;
import com.googlecode.lanterna.gui2.BasePane;
import com.googlecode.lanterna.gui2.BasePaneListener;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.ComponentRenderer;
import com.googlecode.lanterna.gui2.Container;
import com.googlecode.lanterna.gui2.Interactable;
import com.googlecode.lanterna.gui2.InteractableLookupMap;
import com.googlecode.lanterna.gui2.TextGUI;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import com.googlecode.lanterna.input.MouseAction;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractBasePane<T extends BasePane>
implements BasePane {
    protected final ContentHolder contentHolder = new ContentHolder();
    private final CopyOnWriteArrayList<BasePaneListener<T>> listeners = new CopyOnWriteArrayList();
    protected InteractableLookupMap interactableLookupMap = new InteractableLookupMap(new TerminalSize(80, 25));
    private Interactable focusedInteractable;
    private boolean invalid = false;
    private boolean strictFocusChange = false;
    private boolean enableDirectionBasedMovements = true;
    private Theme theme = null;

    protected AbstractBasePane() {
    }

    @Override
    public boolean isInvalid() {
        return this.invalid || this.contentHolder.isInvalid();
    }

    @Override
    public void invalidate() {
        this.invalid = true;
        this.contentHolder.invalidate();
    }

    @Override
    public void draw(TextGUIGraphics graphics) {
        graphics.applyThemeStyle(this.getTheme().getDefinition(Window.class).getNormal());
        graphics.fill(' ');
        this.contentHolder.draw(graphics);
        if (!this.interactableLookupMap.getSize().equals(graphics.getSize())) {
            this.interactableLookupMap = new InteractableLookupMap(graphics.getSize());
        } else {
            this.interactableLookupMap.reset();
        }
        this.contentHolder.updateLookupMap(this.interactableLookupMap);
        this.invalid = false;
    }

    @Override
    public boolean handleInput(KeyStroke key) {
        AtomicBoolean deliverEvent = new AtomicBoolean(true);
        for (BasePaneListener<T> listener : this.listeners) {
            listener.onInput(this.self(), key, deliverEvent);
        }
        if (!deliverEvent.get()) {
            return true;
        }
        boolean handled = this.doHandleInput(key);
        if (!handled) {
            AtomicBoolean hasBeenHandled = new AtomicBoolean(false);
            for (BasePaneListener<T> listener : this.listeners) {
                listener.onUnhandledInput(this.self(), key, hasBeenHandled);
            }
            handled = hasBeenHandled.get();
        }
        return handled;
    }

    abstract T self();

    private boolean doHandleInput(KeyStroke key) {
        if (key.getKeyType() == KeyType.MouseEvent) {
            Interactable interactable;
            MouseAction mouseAction = (MouseAction)key;
            TerminalPosition localCoordinates = this.fromGlobal(mouseAction.getPosition());
            if (localCoordinates != null && (interactable = this.interactableLookupMap.getInteractableAt(localCoordinates)) != null) {
                interactable.handleInput(key);
            }
        } else if (this.focusedInteractable != null) {
            Interactable next = null;
            Interactable.FocusChangeDirection direction = Interactable.FocusChangeDirection.TELEPORT;
            Interactable.Result result = this.focusedInteractable.handleInput(key);
            if (!this.enableDirectionBasedMovements) {
                if (result == Interactable.Result.MOVE_FOCUS_DOWN || result == Interactable.Result.MOVE_FOCUS_RIGHT) {
                    result = Interactable.Result.MOVE_FOCUS_NEXT;
                } else if (result == Interactable.Result.MOVE_FOCUS_UP || result == Interactable.Result.MOVE_FOCUS_LEFT) {
                    result = Interactable.Result.MOVE_FOCUS_PREVIOUS;
                }
            }
            switch (result) {
                case HANDLED: {
                    return true;
                }
                case UNHANDLED: {
                    for (Container parent = this.focusedInteractable.getParent(); parent != null; parent = parent.getParent()) {
                        if (!parent.handleInput(key)) continue;
                        return true;
                    }
                    return false;
                }
                case MOVE_FOCUS_NEXT: {
                    next = this.contentHolder.nextFocus(this.focusedInteractable);
                    if (next == null) {
                        next = this.contentHolder.nextFocus(null);
                    }
                    direction = Interactable.FocusChangeDirection.NEXT;
                    break;
                }
                case MOVE_FOCUS_PREVIOUS: {
                    next = this.contentHolder.previousFocus(this.focusedInteractable);
                    if (next == null) {
                        next = this.contentHolder.previousFocus(null);
                    }
                    direction = Interactable.FocusChangeDirection.PREVIOUS;
                    break;
                }
                case MOVE_FOCUS_DOWN: {
                    next = this.interactableLookupMap.findNextDown(this.focusedInteractable);
                    direction = Interactable.FocusChangeDirection.DOWN;
                    if (next != null || this.strictFocusChange) break;
                    next = this.contentHolder.nextFocus(this.focusedInteractable);
                    direction = Interactable.FocusChangeDirection.NEXT;
                    break;
                }
                case MOVE_FOCUS_LEFT: {
                    next = this.interactableLookupMap.findNextLeft(this.focusedInteractable);
                    direction = Interactable.FocusChangeDirection.LEFT;
                    break;
                }
                case MOVE_FOCUS_RIGHT: {
                    next = this.interactableLookupMap.findNextRight(this.focusedInteractable);
                    direction = Interactable.FocusChangeDirection.RIGHT;
                    break;
                }
                case MOVE_FOCUS_UP: {
                    next = this.interactableLookupMap.findNextUp(this.focusedInteractable);
                    direction = Interactable.FocusChangeDirection.UP;
                    if (next != null || this.strictFocusChange) break;
                    next = this.contentHolder.previousFocus(this.focusedInteractable);
                    direction = Interactable.FocusChangeDirection.PREVIOUS;
                }
            }
            if (next != null) {
                this.setFocusedInteractable(next, direction);
            }
            return true;
        }
        return false;
    }

    @Override
    public Component getComponent() {
        return this.contentHolder.getComponent();
    }

    @Override
    public void setComponent(Component component) {
        this.contentHolder.setComponent(component);
    }

    @Override
    public Interactable getFocusedInteractable() {
        return this.focusedInteractable;
    }

    @Override
    public TerminalPosition getCursorPosition() {
        if (this.focusedInteractable == null) {
            return null;
        }
        TerminalPosition position = this.focusedInteractable.getCursorLocation();
        if (position == null) {
            return null;
        }
        if (position.getColumn() < 0 || position.getRow() < 0 || position.getColumn() >= this.focusedInteractable.getSize().getColumns() || position.getRow() >= this.focusedInteractable.getSize().getRows()) {
            return null;
        }
        return this.focusedInteractable.toBasePane(position);
    }

    @Override
    public void setFocusedInteractable(Interactable toFocus) {
        this.setFocusedInteractable(toFocus, toFocus != null ? Interactable.FocusChangeDirection.TELEPORT : Interactable.FocusChangeDirection.RESET);
    }

    protected void setFocusedInteractable(Interactable toFocus, Interactable.FocusChangeDirection direction) {
        if (this.focusedInteractable == toFocus) {
            return;
        }
        if (toFocus != null && !toFocus.isEnabled()) {
            return;
        }
        if (this.focusedInteractable != null) {
            this.focusedInteractable.onLeaveFocus(direction, this.focusedInteractable);
        }
        Interactable previous = this.focusedInteractable;
        this.focusedInteractable = toFocus;
        if (toFocus != null) {
            toFocus.onEnterFocus(direction, previous);
        }
        this.invalidate();
    }

    @Override
    public void setStrictFocusChange(boolean strictFocusChange) {
        this.strictFocusChange = strictFocusChange;
    }

    @Override
    public void setEnableDirectionBasedMovements(boolean enableDirectionBasedMovements) {
        this.enableDirectionBasedMovements = enableDirectionBasedMovements;
    }

    @Override
    public synchronized Theme getTheme() {
        if (this.theme != null) {
            return this.theme;
        }
        if (this.getTextGUI() != null) {
            return this.getTextGUI().getTheme();
        }
        return null;
    }

    @Override
    public synchronized void setTheme(Theme theme) {
        this.theme = theme;
    }

    protected void addBasePaneListener(BasePaneListener<T> basePaneListener) {
        this.listeners.addIfAbsent(basePaneListener);
    }

    protected void removeBasePaneListener(BasePaneListener<T> basePaneListener) {
        this.listeners.remove(basePaneListener);
    }

    protected List<BasePaneListener<T>> getBasePaneListeners() {
        return this.listeners;
    }

    protected class ContentHolder
    extends AbstractComposite<Container> {
        protected ContentHolder() {
        }

        @Override
        public void setComponent(Component component) {
            if (this.getComponent() == component) {
                return;
            }
            AbstractBasePane.this.setFocusedInteractable(null);
            super.setComponent(component);
            if (AbstractBasePane.this.focusedInteractable == null && component instanceof Interactable) {
                AbstractBasePane.this.setFocusedInteractable((Interactable)component);
            } else if (AbstractBasePane.this.focusedInteractable == null && component instanceof Container) {
                AbstractBasePane.this.setFocusedInteractable(((Container)component).nextFocus(null));
            }
        }

        @Override
        public boolean removeComponent(Component component) {
            boolean removed = super.removeComponent(component);
            if (removed) {
                AbstractBasePane.this.focusedInteractable = null;
            }
            return removed;
        }

        @Override
        public TextGUI getTextGUI() {
            return AbstractBasePane.this.getTextGUI();
        }

        @Override
        protected ComponentRenderer<Container> createDefaultRenderer() {
            return new ComponentRenderer<Container>(){

                @Override
                public TerminalSize getPreferredSize(Container component) {
                    Component subComponent = ContentHolder.this.getComponent();
                    if (subComponent == null) {
                        return TerminalSize.ZERO;
                    }
                    return subComponent.getPreferredSize();
                }

                @Override
                public void drawComponent(TextGUIGraphics graphics, Container component) {
                    Component subComponent = ContentHolder.this.getComponent();
                    if (subComponent == null) {
                        return;
                    }
                    subComponent.draw(graphics);
                }
            };
        }

        @Override
        public TerminalPosition toGlobal(TerminalPosition position) {
            return AbstractBasePane.this.toGlobal(position);
        }

        @Override
        public TerminalPosition toBasePane(TerminalPosition position) {
            return position;
        }

        @Override
        public BasePane getBasePane() {
            return AbstractBasePane.this;
        }
    }
}

