/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.gui2.AbstractComponent;
import com.googlecode.lanterna.gui2.AbstractInteractableComponent;
import com.googlecode.lanterna.gui2.Direction;
import com.googlecode.lanterna.gui2.Interactable;
import com.googlecode.lanterna.gui2.InteractableRenderer;
import com.googlecode.lanterna.gui2.ScrollBar;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.input.KeyStroke;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractListBox<V, T extends AbstractListBox<V, T>>
extends AbstractInteractableComponent<T> {
    private final List<V> items = new ArrayList<V>();
    private int selectedIndex = -1;
    private ListItemRenderer<V, T> listItemRenderer;

    protected AbstractListBox() {
        this(null);
    }

    protected AbstractListBox(TerminalSize size) {
        this.setPreferredSize(size);
        this.setListItemRenderer(this.createDefaultListItemRenderer());
    }

    @Override
    protected InteractableRenderer<T> createDefaultRenderer() {
        return new DefaultListBoxRenderer();
    }

    protected ListItemRenderer<V, T> createDefaultListItemRenderer() {
        return new ListItemRenderer();
    }

    ListItemRenderer<V, T> getListItemRenderer() {
        return this.listItemRenderer;
    }

    public synchronized T setListItemRenderer(ListItemRenderer<V, T> listItemRenderer) {
        if (listItemRenderer == null && (listItemRenderer = this.createDefaultListItemRenderer()) == null) {
            throw new IllegalStateException("createDefaultListItemRenderer returned null");
        }
        this.listItemRenderer = listItemRenderer;
        return (T)((AbstractListBox)this.self());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Interactable.Result handleKeyStroke(KeyStroke keyStroke) {
        try {
            switch (keyStroke.getKeyType()) {
                case Tab: {
                    Interactable.Result result = Interactable.Result.MOVE_FOCUS_NEXT;
                    return result;
                }
                case ReverseTab: {
                    Interactable.Result result = Interactable.Result.MOVE_FOCUS_PREVIOUS;
                    return result;
                }
                case ArrowRight: {
                    Interactable.Result result = Interactable.Result.MOVE_FOCUS_RIGHT;
                    return result;
                }
                case ArrowLeft: {
                    Interactable.Result result = Interactable.Result.MOVE_FOCUS_LEFT;
                    return result;
                }
                case ArrowDown: {
                    if (this.items.isEmpty() || this.selectedIndex == this.items.size() - 1) {
                        Interactable.Result result = Interactable.Result.MOVE_FOCUS_DOWN;
                        return result;
                    }
                    ++this.selectedIndex;
                    Interactable.Result result = Interactable.Result.HANDLED;
                    return result;
                }
                case ArrowUp: {
                    if (this.items.isEmpty() || this.selectedIndex == 0) {
                        Interactable.Result result = Interactable.Result.MOVE_FOCUS_UP;
                        return result;
                    }
                    --this.selectedIndex;
                    Interactable.Result result = Interactable.Result.HANDLED;
                    return result;
                }
                case Home: {
                    this.selectedIndex = 0;
                    Interactable.Result result = Interactable.Result.HANDLED;
                    return result;
                }
                case End: {
                    this.selectedIndex = this.items.size() - 1;
                    Interactable.Result result = Interactable.Result.HANDLED;
                    return result;
                }
                case PageUp: {
                    if (this.getSize() != null) {
                        this.setSelectedIndex(this.getSelectedIndex() - this.getSize().getRows());
                    }
                    Interactable.Result result = Interactable.Result.HANDLED;
                    return result;
                }
                case PageDown: {
                    if (this.getSize() != null) {
                        this.setSelectedIndex(this.getSelectedIndex() + this.getSize().getRows());
                    }
                    Interactable.Result result = Interactable.Result.HANDLED;
                    return result;
                }
            }
            Interactable.Result result = Interactable.Result.UNHANDLED;
            return result;
        }
        finally {
            this.invalidate();
        }
    }

    @Override
    protected synchronized void afterEnterFocus(Interactable.FocusChangeDirection direction, Interactable previouslyInFocus) {
        if (this.items.isEmpty()) {
            return;
        }
        if (direction == Interactable.FocusChangeDirection.DOWN) {
            this.selectedIndex = 0;
        } else if (direction == Interactable.FocusChangeDirection.UP) {
            this.selectedIndex = this.items.size() - 1;
        }
    }

    public synchronized T addItem(V item) {
        if (item == null) {
            return (T)((AbstractListBox)this.self());
        }
        this.items.add(item);
        if (this.selectedIndex == -1) {
            this.selectedIndex = 0;
        }
        this.invalidate();
        return (T)((AbstractListBox)this.self());
    }

    public synchronized V removeItem(int index) {
        V existing = this.items.remove(index);
        if (index < this.selectedIndex) {
            --this.selectedIndex;
        }
        while (this.selectedIndex >= this.items.size()) {
            --this.selectedIndex;
        }
        this.invalidate();
        return existing;
    }

    public synchronized T clearItems() {
        this.items.clear();
        this.selectedIndex = -1;
        this.invalidate();
        return (T)((AbstractListBox)this.self());
    }

    @Override
    public boolean isFocusable() {
        if (this.isEmpty()) {
            return false;
        }
        return super.isFocusable();
    }

    public synchronized int indexOf(V item) {
        return this.items.indexOf(item);
    }

    public synchronized V getItemAt(int index) {
        return this.items.get(index);
    }

    public synchronized boolean isEmpty() {
        return this.items.isEmpty();
    }

    public synchronized int getItemCount() {
        return this.items.size();
    }

    public synchronized List<V> getItems() {
        return new ArrayList<V>(this.items);
    }

    public synchronized T setSelectedIndex(int index) {
        this.selectedIndex = index;
        if (this.selectedIndex < 0) {
            this.selectedIndex = 0;
        }
        if (this.selectedIndex > this.items.size() - 1) {
            this.selectedIndex = this.items.size() - 1;
        }
        this.invalidate();
        return (T)((AbstractListBox)this.self());
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public synchronized V getSelectedItem() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.items.get(this.selectedIndex);
    }

    public static class ListItemRenderer<V, T extends AbstractListBox<V, T>> {
        public int getHotSpotPositionOnLine(int selectedIndex) {
            return 0;
        }

        public String getLabel(T listBox, int index, V item) {
            return item != null ? item.toString() : "<null>";
        }

        public void drawItem(TextGUIGraphics graphics, T listBox, int index, V item, boolean selected, boolean focused) {
            ThemeDefinition themeDefinition = ((AbstractComponent)listBox).getTheme().getDefinition(AbstractListBox.class);
            if (selected && focused) {
                graphics.applyThemeStyle(themeDefinition.getSelected());
            } else {
                graphics.applyThemeStyle(themeDefinition.getNormal());
            }
            String label = this.getLabel(listBox, index, item);
            label = TerminalTextUtils.fitString(label, graphics.getSize().getColumns());
            while (TerminalTextUtils.getColumnWidth(label) < graphics.getSize().getColumns()) {
                label = label + " ";
            }
            graphics.putString(0, 0, label);
        }
    }

    public static class DefaultListBoxRenderer<V, T extends AbstractListBox<V, T>>
    implements InteractableRenderer<T> {
        private final ScrollBar verticalScrollBar = new ScrollBar(Direction.VERTICAL);
        private int scrollTopIndex = 0;

        @Override
        public TerminalPosition getCursorLocation(T listBox) {
            if (!((AbstractComponent)listBox).getThemeDefinition().isCursorVisible()) {
                return null;
            }
            int selectedIndex = ((AbstractListBox)listBox).getSelectedIndex();
            int columnAccordingToRenderer = ((AbstractListBox)listBox).getListItemRenderer().getHotSpotPositionOnLine(selectedIndex);
            if (columnAccordingToRenderer == -1) {
                return null;
            }
            return new TerminalPosition(columnAccordingToRenderer, selectedIndex - this.scrollTopIndex);
        }

        @Override
        public TerminalSize getPreferredSize(T listBox) {
            int maxWidth = 5;
            int index = 0;
            for (Object item : ((AbstractListBox)listBox).getItems()) {
                String itemString = ((AbstractListBox)listBox).getListItemRenderer().getLabel(listBox, index++, item);
                int stringLengthInColumns = TerminalTextUtils.getColumnWidth(itemString);
                if (stringLengthInColumns <= maxWidth) continue;
                maxWidth = stringLengthInColumns;
            }
            return new TerminalSize(maxWidth + 1, ((AbstractListBox)listBox).getItemCount());
        }

        @Override
        public void drawComponent(TextGUIGraphics graphics, T listBox) {
            ThemeDefinition themeDefinition = ((AbstractComponent)listBox).getTheme().getDefinition(AbstractListBox.class);
            int componentHeight = graphics.getSize().getRows();
            int selectedIndex = ((AbstractListBox)listBox).getSelectedIndex();
            List items = ((AbstractListBox)listBox).getItems();
            ListItemRenderer listItemRenderer = ((AbstractListBox)listBox).getListItemRenderer();
            if (selectedIndex != -1) {
                if (selectedIndex < this.scrollTopIndex) {
                    this.scrollTopIndex = selectedIndex;
                } else if (selectedIndex >= componentHeight + this.scrollTopIndex) {
                    this.scrollTopIndex = selectedIndex - componentHeight + 1;
                }
            }
            if (items.size() > componentHeight && items.size() - this.scrollTopIndex < componentHeight) {
                this.scrollTopIndex = items.size() - componentHeight;
            }
            graphics.applyThemeStyle(themeDefinition.getNormal());
            graphics.fill(' ');
            TerminalSize itemSize = graphics.getSize().withRows(1);
            for (int i = this.scrollTopIndex; i < items.size() && i - this.scrollTopIndex < componentHeight; ++i) {
                listItemRenderer.drawItem(graphics.newTextGraphics(new TerminalPosition(0, i - this.scrollTopIndex), itemSize), listBox, i, items.get(i), selectedIndex == i, ((AbstractInteractableComponent)listBox).isFocused());
            }
            graphics.applyThemeStyle(themeDefinition.getNormal());
            if (items.size() > componentHeight) {
                this.verticalScrollBar.onAdded(((AbstractComponent)listBox).getParent());
                this.verticalScrollBar.setViewSize(componentHeight);
                this.verticalScrollBar.setScrollMaximum(items.size());
                this.verticalScrollBar.setScrollPosition(this.scrollTopIndex);
                this.verticalScrollBar.draw(graphics.newTextGraphics(new TerminalPosition(graphics.getSize().getColumns() - 1, 0), new TerminalSize(1, graphics.getSize().getRows())));
            }
        }
    }
}

