/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.Interactable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class InteractableLookupMap {
    private final int[][] lookupMap;
    private final List<Interactable> interactables;

    InteractableLookupMap(TerminalSize size) {
        this.lookupMap = new int[size.getRows()][size.getColumns()];
        this.interactables = new ArrayList<Interactable>();
        for (int[] aLookupMap : this.lookupMap) {
            Arrays.fill(aLookupMap, -1);
        }
    }

    void reset() {
        this.interactables.clear();
        for (int[] aLookupMap : this.lookupMap) {
            Arrays.fill(aLookupMap, -1);
        }
    }

    TerminalSize getSize() {
        if (this.lookupMap.length == 0) {
            return TerminalSize.ZERO;
        }
        return new TerminalSize(this.lookupMap[0].length, this.lookupMap.length);
    }

    public synchronized void add(Interactable interactable) {
        TerminalPosition topLeft = interactable.toBasePane(TerminalPosition.TOP_LEFT_CORNER);
        TerminalSize size = interactable.getSize();
        this.interactables.add(interactable);
        int index = this.interactables.size() - 1;
        for (int y = topLeft.getRow(); y < topLeft.getRow() + size.getRows(); ++y) {
            for (int x = topLeft.getColumn(); x < topLeft.getColumn() + size.getColumns(); ++x) {
                if (y < 0 || y >= this.lookupMap.length || x < 0 || x >= this.lookupMap[y].length) continue;
                this.lookupMap[y][x] = index;
            }
        }
    }

    public synchronized Interactable getInteractableAt(TerminalPosition position) {
        if (position.getRow() < 0 || position.getColumn() < 0) {
            return null;
        }
        if (position.getRow() >= this.lookupMap.length) {
            return null;
        }
        if (position.getColumn() >= this.lookupMap[0].length) {
            return null;
        }
        if (this.lookupMap[position.getRow()][position.getColumn()] == -1) {
            return null;
        }
        return this.interactables.get(this.lookupMap[position.getRow()][position.getColumn()]);
    }

    public synchronized Interactable findNextUp(Interactable interactable) {
        return this.findNextUpOrDown(interactable, false);
    }

    public synchronized Interactable findNextDown(Interactable interactable) {
        return this.findNextUpOrDown(interactable, true);
    }

    private Interactable findNextUpOrDown(Interactable interactable, boolean isDown) {
        int directionTerm = isDown ? 1 : -1;
        TerminalPosition startPosition = interactable.getCursorLocation();
        startPosition = startPosition == null ? (isDown ? new TerminalPosition(0, interactable.getSize().getRows() - 1) : TerminalPosition.TOP_LEFT_CORNER) : (isDown ? startPosition.withRow(interactable.getSize().getRows() - 1) : startPosition.withRow(0));
        startPosition = interactable.toBasePane(startPosition);
        if (startPosition == null) {
            return null;
        }
        Set<Interactable> disqualified = this.getDisqualifiedInteractables(startPosition, true);
        TerminalSize size = this.getSize();
        int maxShiftLeft = interactable.toBasePane(TerminalPosition.TOP_LEFT_CORNER).getColumn();
        maxShiftLeft = Math.max(maxShiftLeft, 0);
        int maxShiftRight = interactable.toBasePane(new TerminalPosition(interactable.getSize().getColumns() - 1, 0)).getColumn();
        maxShiftRight = Math.min(maxShiftRight, size.getColumns() - 1);
        int maxShift = Math.max(startPosition.getColumn() - maxShiftLeft, maxShiftRight - startPosition.getRow());
        for (int searchRow = startPosition.getRow() + directionTerm; searchRow >= 0 && searchRow < size.getRows(); searchRow += directionTerm) {
            block1: for (int xShift = 0; xShift <= maxShift; ++xShift) {
                for (int modifier : new int[]{1, -1}) {
                    int index;
                    if (xShift == 0 && modifier == -1) continue block1;
                    int searchColumn = startPosition.getColumn() + xShift * modifier;
                    if (searchColumn < maxShiftLeft || searchColumn > maxShiftRight || (index = this.lookupMap[searchRow][searchColumn]) == -1 || disqualified.contains(this.interactables.get(index))) continue;
                    return this.interactables.get(index);
                }
            }
        }
        return null;
    }

    public synchronized Interactable findNextLeft(Interactable interactable) {
        return this.findNextLeftOrRight(interactable, false);
    }

    public synchronized Interactable findNextRight(Interactable interactable) {
        return this.findNextLeftOrRight(interactable, true);
    }

    private Interactable findNextLeftOrRight(Interactable interactable, boolean isRight) {
        int directionTerm = isRight ? 1 : -1;
        TerminalPosition startPosition = interactable.getCursorLocation();
        startPosition = startPosition == null ? (isRight ? new TerminalPosition(interactable.getSize().getColumns() - 1, 0) : TerminalPosition.TOP_LEFT_CORNER) : (isRight ? startPosition.withColumn(interactable.getSize().getColumns() - 1) : startPosition.withColumn(0));
        startPosition = interactable.toBasePane(startPosition);
        if (startPosition == null) {
            return null;
        }
        Set<Interactable> disqualified = this.getDisqualifiedInteractables(startPosition, false);
        TerminalSize size = this.getSize();
        int maxShiftUp = interactable.toBasePane(TerminalPosition.TOP_LEFT_CORNER).getRow();
        maxShiftUp = Math.max(maxShiftUp, 0);
        int maxShiftDown = interactable.toBasePane(new TerminalPosition(0, interactable.getSize().getRows() - 1)).getRow();
        maxShiftDown = Math.min(maxShiftDown, size.getRows() - 1);
        int maxShift = Math.max(startPosition.getRow() - maxShiftUp, maxShiftDown - startPosition.getRow());
        for (int searchColumn = startPosition.getColumn() + directionTerm; searchColumn >= 0 && searchColumn < size.getColumns(); searchColumn += directionTerm) {
            block1: for (int yShift = 0; yShift <= maxShift; ++yShift) {
                for (int modifier : new int[]{1, -1}) {
                    int index;
                    if (yShift == 0 && modifier == -1) continue block1;
                    int searchRow = startPosition.getRow() + yShift * modifier;
                    if (searchRow < maxShiftUp || searchRow > maxShiftDown || (index = this.lookupMap[searchRow][searchColumn]) == -1 || disqualified.contains(this.interactables.get(index))) continue;
                    return this.interactables.get(index);
                }
            }
        }
        return null;
    }

    private Set<Interactable> getDisqualifiedInteractables(TerminalPosition startPosition, boolean scanHorizontally) {
        HashSet<Interactable> disqualified = new HashSet<Interactable>();
        if (this.lookupMap.length == 0) {
            return disqualified;
        }
        TerminalSize size = this.getSize();
        if (startPosition.getRow() < 0) {
            startPosition = startPosition.withRow(0);
        } else if (startPosition.getRow() >= this.lookupMap.length) {
            startPosition = startPosition.withRow(this.lookupMap.length - 1);
        }
        if (startPosition.getColumn() < 0) {
            startPosition = startPosition.withColumn(0);
        } else if (startPosition.getColumn() >= this.lookupMap[startPosition.getRow()].length) {
            startPosition = startPosition.withColumn(this.lookupMap[startPosition.getRow()].length - 1);
        }
        if (scanHorizontally) {
            for (int column = 0; column < size.getColumns(); ++column) {
                int index = this.lookupMap[startPosition.getRow()][column];
                if (index == -1) continue;
                disqualified.add(this.interactables.get(index));
            }
        } else {
            for (int row = 0; row < size.getRows(); ++row) {
                int index = this.lookupMap[row][startPosition.getColumn()];
                if (index == -1) continue;
                disqualified.add(this.interactables.get(index));
            }
        }
        return disqualified;
    }

    void debug() {
        int[][] arr$ = this.lookupMap;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int[] row;
            for (int value : row = arr$[i$]) {
                if (value >= 0) {
                    System.out.print(" ");
                }
                System.out.print(value);
            }
            System.out.println();
        }
        System.out.println();
    }
}

