/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.gui2.AbstractComponent;
import com.googlecode.lanterna.gui2.ComponentRenderer;
import com.googlecode.lanterna.gui2.TextGUIGraphics;

public class ProgressBar
extends AbstractComponent<ProgressBar> {
    private int min;
    private int max;
    private int value;
    private int preferredWidth;
    private String labelFormat;

    public ProgressBar() {
        this(0, 100);
    }

    public ProgressBar(int min, int max) {
        this(min, max, 0);
    }

    public ProgressBar(int min, int max, int preferredWidth) {
        if (min > max) {
            min = max;
        }
        this.min = min;
        this.max = max;
        this.value = min;
        this.labelFormat = "%2.0f%%";
        if (preferredWidth < 1) {
            preferredWidth = 1;
        }
        this.preferredWidth = preferredWidth;
    }

    public int getMin() {
        return this.min;
    }

    public synchronized ProgressBar setMin(int min) {
        if (min > this.max) {
            this.setMax(min);
        }
        if (min > this.value) {
            this.setValue(min);
        }
        if (this.min != min) {
            this.min = min;
            this.invalidate();
        }
        return this;
    }

    public int getMax() {
        return this.max;
    }

    public synchronized ProgressBar setMax(int max) {
        if (max < this.min) {
            this.setMin(max);
        }
        if (max < this.value) {
            this.setValue(max);
        }
        if (this.max != max) {
            this.max = max;
            this.invalidate();
        }
        return this;
    }

    public int getValue() {
        return this.value;
    }

    public synchronized ProgressBar setValue(int value) {
        if (value < this.min) {
            value = this.min;
        }
        if (value > this.max) {
            value = this.max;
        }
        if (this.value != value) {
            this.value = value;
            this.invalidate();
        }
        return this;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setPreferredWidth(int preferredWidth) {
        this.preferredWidth = preferredWidth;
    }

    public String getLabelFormat() {
        return this.labelFormat;
    }

    public synchronized ProgressBar setLabelFormat(String labelFormat) {
        this.labelFormat = labelFormat;
        this.invalidate();
        return this;
    }

    public synchronized float getProgress() {
        return (float)(this.value - this.min) / (float)this.max;
    }

    public synchronized String getFormattedLabel() {
        if (this.labelFormat == null) {
            return "";
        }
        return String.format(this.labelFormat, Float.valueOf(this.getProgress() * 100.0f));
    }

    @Override
    protected ComponentRenderer<ProgressBar> createDefaultRenderer() {
        return new DefaultProgressBarRenderer();
    }

    public static class LargeProgressBarRenderer
    implements ComponentRenderer<ProgressBar> {
        @Override
        public TerminalSize getPreferredSize(ProgressBar component) {
            int preferredWidth = component.getPreferredWidth();
            if (preferredWidth > 0) {
                return new TerminalSize(preferredWidth, 3);
            }
            return new TerminalSize(42, 3);
        }

        @Override
        public void drawComponent(TextGUIGraphics graphics, ProgressBar component) {
            TerminalSize size = graphics.getSize();
            if (size.getRows() == 0 || size.getColumns() == 0) {
                return;
            }
            ThemeDefinition themeDefinition = component.getThemeDefinition();
            int columnOfProgress = (int)(component.getProgress() * (float)(size.getColumns() - 4));
            int mark25 = -1;
            int mark50 = -1;
            int mark75 = -1;
            if (size.getColumns() > 9) {
                mark50 = (size.getColumns() - 2) / 2;
            }
            if (size.getColumns() > 16) {
                mark25 = (size.getColumns() - 2) / 4;
                mark75 = mark50 + mark25;
            }
            int rowOffset = 0;
            if (size.getRows() >= 3) {
                graphics.applyThemeStyle(themeDefinition.getNormal());
                graphics.drawLine(0, 0, size.getColumns(), 0, ' ');
                if (size.getColumns() > 1) {
                    graphics.setCharacter(1, 0, '0');
                }
                if (mark25 != -1) {
                    if (component.getProgress() < 0.25f) {
                        graphics.applyThemeStyle(themeDefinition.getInsensitive());
                    }
                    graphics.putString(1 + mark25, 0, "25");
                }
                if (mark50 != -1) {
                    if (component.getProgress() < 0.5f) {
                        graphics.applyThemeStyle(themeDefinition.getInsensitive());
                    }
                    graphics.putString(1 + mark50, 0, "50");
                }
                if (mark75 != -1) {
                    if (component.getProgress() < 0.75f) {
                        graphics.applyThemeStyle(themeDefinition.getInsensitive());
                    }
                    graphics.putString(1 + mark75, 0, "75");
                }
                if (size.getColumns() >= 7) {
                    if (component.getProgress() < 1.0f) {
                        graphics.applyThemeStyle(themeDefinition.getInsensitive());
                    }
                    graphics.putString(size.getColumns() - 3, 0, "100");
                }
                ++rowOffset;
            }
            for (int i = 0; i < Math.max(1, size.getRows() - 2); ++i) {
                graphics.applyThemeStyle(themeDefinition.getNormal());
                graphics.drawLine(0, rowOffset, size.getColumns(), rowOffset, ' ');
                if (size.getColumns() > 2) {
                    graphics.setCharacter(1, rowOffset, '\u2502');
                }
                if (size.getColumns() > 3) {
                    graphics.setCharacter(size.getColumns() - 2, rowOffset, '\u2502');
                }
                if (size.getColumns() > 4) {
                    graphics.applyThemeStyle(themeDefinition.getActive());
                    for (int columnOffset = 2; columnOffset < size.getColumns() - 2; ++columnOffset) {
                        if (columnOfProgress + 2 == columnOffset) {
                            graphics.applyThemeStyle(themeDefinition.getNormal());
                        }
                        if (mark25 == columnOffset - 1) {
                            graphics.setCharacter(columnOffset, rowOffset, '\u2502');
                            continue;
                        }
                        if (mark50 == columnOffset - 1) {
                            graphics.setCharacter(columnOffset, rowOffset, '\u2502');
                            continue;
                        }
                        if (mark75 == columnOffset - 1) {
                            graphics.setCharacter(columnOffset, rowOffset, '\u2502');
                            continue;
                        }
                        graphics.setCharacter(columnOffset, rowOffset, ' ');
                    }
                }
                if ((int)(component.getProgress() * (float)((size.getColumns() - 4) * 2)) % 2 == 1) {
                    graphics.applyThemeStyle(themeDefinition.getPreLight());
                    graphics.setCharacter(columnOfProgress + 2, rowOffset, '|');
                }
                ++rowOffset;
            }
            if (size.getRows() >= 2) {
                graphics.applyThemeStyle(themeDefinition.getNormal());
                graphics.drawLine(0, rowOffset, size.getColumns(), rowOffset, '\u2534');
                graphics.setCharacter(0, rowOffset, ' ');
                if (size.getColumns() > 1) {
                    graphics.setCharacter(size.getColumns() - 1, rowOffset, ' ');
                }
                if (size.getColumns() > 2) {
                    graphics.setCharacter(1, rowOffset, '\u2514');
                }
                if (size.getColumns() > 3) {
                    graphics.setCharacter(size.getColumns() - 2, rowOffset, '\u2518');
                }
            }
        }
    }

    public static class DefaultProgressBarRenderer
    implements ComponentRenderer<ProgressBar> {
        @Override
        public TerminalSize getPreferredSize(ProgressBar component) {
            int preferredWidth = component.getPreferredWidth();
            if (preferredWidth > 0) {
                return new TerminalSize(preferredWidth, 1);
            }
            if (component.getLabelFormat() != null && !component.getLabelFormat().trim().isEmpty()) {
                return new TerminalSize(TerminalTextUtils.getColumnWidth(String.format(component.getLabelFormat(), Float.valueOf(100.0f))) + 2, 1);
            }
            return new TerminalSize(10, 1);
        }

        @Override
        public void drawComponent(TextGUIGraphics graphics, ProgressBar component) {
            TerminalSize size = graphics.getSize();
            if (size.getRows() == 0 || size.getColumns() == 0) {
                return;
            }
            ThemeDefinition themeDefinition = component.getThemeDefinition();
            int columnOfProgress = (int)(component.getProgress() * (float)size.getColumns());
            String label = component.getFormattedLabel();
            int labelRow = size.getRows() / 2;
            int labelWidth = TerminalTextUtils.getColumnWidth(label);
            if (labelWidth > size.getColumns()) {
                boolean tail = true;
                while (labelWidth > size.getColumns()) {
                    label = tail ? label.substring(0, label.length() - 1) : label.substring(1);
                    tail = !tail;
                    labelWidth = TerminalTextUtils.getColumnWidth(label);
                }
            }
            int labelStartPosition = (size.getColumns() - labelWidth) / 2;
            for (int row = 0; row < size.getRows(); ++row) {
                graphics.applyThemeStyle(themeDefinition.getActive());
                for (int column = 0; column < size.getColumns(); ++column) {
                    if (column == columnOfProgress) {
                        graphics.applyThemeStyle(themeDefinition.getNormal());
                    }
                    if (row == labelRow && column >= labelStartPosition && column < labelStartPosition + labelWidth) {
                        char character = label.charAt(TerminalTextUtils.getStringCharacterIndex(label, column - labelStartPosition));
                        graphics.setCharacter(column, row, character);
                        if (!TerminalTextUtils.isCharDoubleWidth(character) || ++column != columnOfProgress) continue;
                        graphics.applyThemeStyle(themeDefinition.getNormal());
                        continue;
                    }
                    graphics.setCharacter(column, row, themeDefinition.getCharacter("FILLER", ' '));
                }
            }
        }
    }
}

