/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.gui2.AbstractTextGUIThread;
import com.googlecode.lanterna.gui2.AsynchronousTextGUIThread;
import com.googlecode.lanterna.gui2.TextGUI;
import com.googlecode.lanterna.gui2.TextGUIThread;
import com.googlecode.lanterna.gui2.TextGUIThreadFactory;
import java.io.EOFException;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;

public class SeparateTextGUIThread
extends AbstractTextGUIThread
implements AsynchronousTextGUIThread {
    private volatile AsynchronousTextGUIThread.State state;
    private final Thread textGUIThread;
    private final CountDownLatch waitLatch = new CountDownLatch(1);

    private SeparateTextGUIThread(TextGUI textGUI) {
        super(textGUI);
        this.textGUIThread = new Thread("LanternaGUI"){

            @Override
            public void run() {
                SeparateTextGUIThread.this.mainGUILoop();
            }
        };
        this.state = AsynchronousTextGUIThread.State.CREATED;
    }

    @Override
    public void start() {
        this.textGUIThread.start();
        this.state = AsynchronousTextGUIThread.State.STARTED;
    }

    @Override
    public void stop() {
        if (this.state != AsynchronousTextGUIThread.State.STARTED) {
            return;
        }
        this.state = AsynchronousTextGUIThread.State.STOPPING;
    }

    @Override
    public void waitForStop() throws InterruptedException {
        this.waitLatch.await();
    }

    @Override
    public AsynchronousTextGUIThread.State getState() {
        return this.state;
    }

    @Override
    public Thread getThread() {
        return this.textGUIThread;
    }

    @Override
    public void invokeLater(Runnable runnable) throws IllegalStateException {
        if (this.state != AsynchronousTextGUIThread.State.STARTED) {
            throw new IllegalStateException("Cannot schedule " + runnable + " for execution on the TextGUIThread " + "because the thread is in " + (Object)((Object)this.state) + " state");
        }
        super.invokeLater(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainGUILoop() {
        try {
            try {
                this.textGUI.updateScreen();
            }
            catch (IOException e) {
                this.exceptionHandler.onIOException(e);
            }
            catch (RuntimeException e) {
                this.exceptionHandler.onRuntimeException(e);
            }
            while (this.state == AsynchronousTextGUIThread.State.STARTED) {
                try {
                    if (this.processEventsAndUpdate()) continue;
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException ignored) {}
                }
                catch (EOFException e) {
                    this.stop();
                    break;
                }
                catch (IOException e) {
                    if (!this.exceptionHandler.onIOException(e)) continue;
                    this.stop();
                    break;
                }
                catch (RuntimeException e) {
                    if (!this.exceptionHandler.onRuntimeException(e)) continue;
                    this.stop();
                    break;
                }
            }
        }
        finally {
            this.state = AsynchronousTextGUIThread.State.STOPPED;
            this.waitLatch.countDown();
        }
    }

    public static class Factory
    implements TextGUIThreadFactory {
        @Override
        public TextGUIThread createTextGUIThread(TextGUI textGUI) {
            return new SeparateTextGUIThread(textGUI);
        }
    }
}

