/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2.dialogs;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.gui2.ActionListBox;
import com.googlecode.lanterna.gui2.Button;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.EmptySpace;
import com.googlecode.lanterna.gui2.GridLayout;
import com.googlecode.lanterna.gui2.Label;
import com.googlecode.lanterna.gui2.LocalizedString;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.dialogs.DialogWindow;
import com.googlecode.lanterna.gui2.dialogs.ListSelectDialogBuilder;
import java.util.List;

public class ListSelectDialog<T>
extends DialogWindow {
    private T result = null;

    ListSelectDialog(String title, String description, TerminalSize listBoxPreferredSize, boolean canCancel, List<T> content) {
        super(title);
        if (content.isEmpty()) {
            throw new IllegalStateException("ListSelectDialog needs at least one item");
        }
        ActionListBox listBox = new ActionListBox(listBoxPreferredSize);
        for (final T item : content) {
            listBox.addItem(item.toString(), new Runnable(){

                @Override
                public void run() {
                    ListSelectDialog.this.onSelect(item);
                }
            });
        }
        Panel mainPanel = new Panel();
        mainPanel.setLayoutManager(new GridLayout(1).setLeftMarginSize(1).setRightMarginSize(1));
        if (description != null) {
            mainPanel.addComponent(new Label(description));
            mainPanel.addComponent(new EmptySpace(TerminalSize.ONE));
        }
        ((ActionListBox)listBox.setLayoutData(GridLayout.createLayoutData(GridLayout.Alignment.FILL, GridLayout.Alignment.CENTER, true, false))).addTo(mainPanel);
        mainPanel.addComponent(new EmptySpace(TerminalSize.ONE));
        if (canCancel) {
            Panel buttonPanel = new Panel();
            buttonPanel.setLayoutManager(new GridLayout(2).setHorizontalSpacing(1));
            buttonPanel.addComponent((Component)new Button(LocalizedString.Cancel.toString(), new Runnable(){

                @Override
                public void run() {
                    ListSelectDialog.this.onCancel();
                }
            }).setLayoutData(GridLayout.createLayoutData(GridLayout.Alignment.CENTER, GridLayout.Alignment.CENTER, true, false)));
            ((Panel)buttonPanel.setLayoutData(GridLayout.createLayoutData(GridLayout.Alignment.END, GridLayout.Alignment.CENTER, false, false))).addTo(mainPanel);
        }
        this.setComponent(mainPanel);
    }

    private void onSelect(T item) {
        this.result = item;
        this.close();
    }

    private void onCancel() {
        this.close();
    }

    public T showDialog(WindowBasedTextGUI textGUI) {
        this.result = null;
        super.showDialog(textGUI);
        return this.result;
    }

    public static <T> T showDialog(WindowBasedTextGUI textGUI, String title, String description, T ... items) {
        return ListSelectDialog.showDialog(textGUI, title, description, null, items);
    }

    public static <T> T showDialog(WindowBasedTextGUI textGUI, String title, String description, int listBoxHeight, T ... items) {
        int width = 0;
        for (T item : items) {
            width = Math.max(width, TerminalTextUtils.getColumnWidth(item.toString()));
        }
        return ListSelectDialog.showDialog(textGUI, title, description, new TerminalSize(width += 2, listBoxHeight), items);
    }

    public static <T> T showDialog(WindowBasedTextGUI textGUI, String title, String description, TerminalSize listBoxSize, T ... items) {
        ListSelectDialog listSelectDialog = (ListSelectDialog)((ListSelectDialogBuilder)((ListSelectDialogBuilder)new ListSelectDialogBuilder().setTitle(title)).setDescription(description)).setListBoxSize(listBoxSize).addListItems(items).build();
        return listSelectDialog.showDialog(textGUI);
    }
}

