/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.screen;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.TextCharacter;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.Scrollable;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import com.googlecode.lanterna.screen.AbstractScreen;
import com.googlecode.lanterna.screen.Screen;
import com.googlecode.lanterna.terminal.Terminal;
import com.googlecode.lanterna.terminal.TerminalResizeListener;
import java.io.IOException;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.TreeMap;

public class TerminalScreen
extends AbstractScreen {
    private final Terminal terminal;
    private boolean isStarted;
    private boolean fullRedrawHint;
    private ScrollHint scrollHint;

    public TerminalScreen(Terminal terminal) throws IOException {
        this(terminal, DEFAULT_CHARACTER);
    }

    public TerminalScreen(Terminal terminal, TextCharacter defaultCharacter) throws IOException {
        super(terminal.getTerminalSize(), defaultCharacter);
        this.terminal = terminal;
        this.terminal.addResizeListener(new TerminalScreenResizeListener());
        this.isStarted = false;
        this.fullRedrawHint = true;
    }

    @Override
    public synchronized void startScreen() throws IOException {
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        this.getTerminal().enterPrivateMode();
        this.getTerminal().getTerminalSize();
        this.getTerminal().clearScreen();
        this.fullRedrawHint = true;
        TerminalPosition cursorPosition = this.getCursorPosition();
        if (cursorPosition != null) {
            this.getTerminal().setCursorVisible(true);
            this.getTerminal().setCursorPosition(cursorPosition.getColumn(), cursorPosition.getRow());
        } else {
            this.getTerminal().setCursorVisible(false);
        }
    }

    @Override
    public void stopScreen() throws IOException {
        this.stopScreen(true);
    }

    public synchronized void stopScreen(boolean flushInput) throws IOException {
        if (!this.isStarted) {
            return;
        }
        if (flushInput) {
            KeyStroke keyStroke;
            while ((keyStroke = this.pollInput()) != null && keyStroke.getKeyType() != KeyType.EOF) {
            }
        }
        this.getTerminal().exitPrivateMode();
        this.isStarted = false;
    }

    @Override
    public synchronized void refresh(Screen.RefreshType refreshType) throws IOException {
        if (!this.isStarted) {
            return;
        }
        if (refreshType == Screen.RefreshType.AUTOMATIC && this.fullRedrawHint || refreshType == Screen.RefreshType.COMPLETE) {
            this.refreshFull();
            this.fullRedrawHint = false;
        } else if (refreshType == Screen.RefreshType.AUTOMATIC && (this.scrollHint == null || this.scrollHint == ScrollHint.INVALID)) {
            double threshold = (double)(this.getTerminalSize().getRows() * this.getTerminalSize().getColumns()) * 0.75;
            if (this.getBackBuffer().isVeryDifferent(this.getFrontBuffer(), (int)threshold)) {
                this.refreshFull();
            } else {
                this.refreshByDelta();
            }
        } else {
            this.refreshByDelta();
        }
        this.getBackBuffer().copyTo(this.getFrontBuffer());
        TerminalPosition cursorPosition = this.getCursorPosition();
        if (cursorPosition != null) {
            this.getTerminal().setCursorVisible(true);
            if (cursorPosition.getColumn() > 0 && TerminalTextUtils.isCharCJK(this.getFrontBuffer().getCharacterAt(cursorPosition.withRelativeColumn(-1)).getCharacter())) {
                this.getTerminal().setCursorPosition(cursorPosition.getColumn() - 1, cursorPosition.getRow());
            } else {
                this.getTerminal().setCursorPosition(cursorPosition.getColumn(), cursorPosition.getRow());
            }
        } else {
            this.getTerminal().setCursorVisible(false);
        }
        this.getTerminal().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void useScrollHint() throws IOException {
        if (this.scrollHint == null) {
            return;
        }
        try {
            if (this.scrollHint == ScrollHint.INVALID) {
                return;
            }
            Terminal term = this.getTerminal();
            if (term instanceof Scrollable) {
                this.scrollHint.applyTo((Scrollable)((Object)term));
                this.scrollHint.applyTo(this.getFrontBuffer());
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        finally {
            this.scrollHint = null;
        }
    }

    private void refreshByDelta() throws IOException {
        TreeMap<TerminalPosition, TextCharacter> updateMap = new TreeMap<TerminalPosition, TextCharacter>(new ScreenPointComparator());
        TerminalSize terminalSize = this.getTerminalSize();
        this.useScrollHint();
        for (int y = 0; y < terminalSize.getRows(); ++y) {
            for (int x = 0; x < terminalSize.getColumns(); ++x) {
                TextCharacter backBufferCharacter = this.getBackBuffer().getCharacterAt(x, y);
                if (!backBufferCharacter.equals(this.getFrontBuffer().getCharacterAt(x, y))) {
                    updateMap.put(new TerminalPosition(x, y), backBufferCharacter);
                }
                if (!TerminalTextUtils.isCharCJK(backBufferCharacter.getCharacter())) continue;
                ++x;
            }
        }
        if (updateMap.isEmpty()) {
            return;
        }
        TerminalPosition currentPosition = (TerminalPosition)updateMap.keySet().iterator().next();
        this.getTerminal().setCursorPosition(currentPosition.getColumn(), currentPosition.getRow());
        TextCharacter firstScreenCharacterToUpdate = (TextCharacter)updateMap.values().iterator().next();
        EnumSet<SGR> currentSGR = firstScreenCharacterToUpdate.getModifiers();
        this.getTerminal().resetColorAndSGR();
        for (SGR sgr : currentSGR) {
            this.getTerminal().enableSGR(sgr);
        }
        TextColor currentForegroundColor = firstScreenCharacterToUpdate.getForegroundColor();
        TextColor currentBackgroundColor = firstScreenCharacterToUpdate.getBackgroundColor();
        this.getTerminal().setForegroundColor(currentForegroundColor);
        this.getTerminal().setBackgroundColor(currentBackgroundColor);
        for (TerminalPosition position : updateMap.keySet()) {
            TextCharacter newCharacter;
            if (!position.equals(currentPosition)) {
                this.getTerminal().setCursorPosition(position.getColumn(), position.getRow());
                currentPosition = position;
            }
            if (!currentForegroundColor.equals((newCharacter = (TextCharacter)updateMap.get(position)).getForegroundColor())) {
                this.getTerminal().setForegroundColor(newCharacter.getForegroundColor());
                currentForegroundColor = newCharacter.getForegroundColor();
            }
            if (!currentBackgroundColor.equals(newCharacter.getBackgroundColor())) {
                this.getTerminal().setBackgroundColor(newCharacter.getBackgroundColor());
                currentBackgroundColor = newCharacter.getBackgroundColor();
            }
            for (SGR sgr : SGR.values()) {
                if (currentSGR.contains((Object)sgr) && !newCharacter.getModifiers().contains((Object)sgr)) {
                    this.getTerminal().disableSGR(sgr);
                    currentSGR.remove((Object)sgr);
                    continue;
                }
                if (currentSGR.contains((Object)sgr) || !newCharacter.getModifiers().contains((Object)sgr)) continue;
                this.getTerminal().enableSGR(sgr);
                currentSGR.add(sgr);
            }
            this.getTerminal().putCharacter(newCharacter.getCharacter());
            if (TerminalTextUtils.isCharCJK(newCharacter.getCharacter())) {
                currentPosition = currentPosition.withRelativeColumn(2);
                continue;
            }
            currentPosition = currentPosition.withRelativeColumn(1);
        }
    }

    private void refreshFull() throws IOException {
        this.getTerminal().setForegroundColor(TextColor.ANSI.DEFAULT);
        this.getTerminal().setBackgroundColor(TextColor.ANSI.DEFAULT);
        this.getTerminal().clearScreen();
        this.getTerminal().resetColorAndSGR();
        this.scrollHint = null;
        EnumSet<SGR> currentSGR = EnumSet.noneOf(SGR.class);
        TextColor currentForegroundColor = TextColor.ANSI.DEFAULT;
        TextColor currentBackgroundColor = TextColor.ANSI.DEFAULT;
        for (int y = 0; y < this.getTerminalSize().getRows(); ++y) {
            this.getTerminal().setCursorPosition(0, y);
            int currentColumn = 0;
            for (int x = 0; x < this.getTerminalSize().getColumns(); ++x) {
                TextCharacter newCharacter = this.getBackBuffer().getCharacterAt(x, y);
                if (newCharacter.equals(DEFAULT_CHARACTER)) continue;
                if (!currentForegroundColor.equals(newCharacter.getForegroundColor())) {
                    this.getTerminal().setForegroundColor(newCharacter.getForegroundColor());
                    currentForegroundColor = newCharacter.getForegroundColor();
                }
                if (!currentBackgroundColor.equals(newCharacter.getBackgroundColor())) {
                    this.getTerminal().setBackgroundColor(newCharacter.getBackgroundColor());
                    currentBackgroundColor = newCharacter.getBackgroundColor();
                }
                for (SGR sgr : SGR.values()) {
                    if (currentSGR.contains((Object)sgr) && !newCharacter.getModifiers().contains((Object)sgr)) {
                        this.getTerminal().disableSGR(sgr);
                        currentSGR.remove((Object)sgr);
                        continue;
                    }
                    if (currentSGR.contains((Object)sgr) || !newCharacter.getModifiers().contains((Object)sgr)) continue;
                    this.getTerminal().enableSGR(sgr);
                    currentSGR.add(sgr);
                }
                if (currentColumn != x) {
                    this.getTerminal().setCursorPosition(x, y);
                    currentColumn = x;
                }
                this.getTerminal().putCharacter(newCharacter.getCharacter());
                if (TerminalTextUtils.isCharCJK(newCharacter.getCharacter())) {
                    currentColumn += 2;
                    ++x;
                    continue;
                }
                ++currentColumn;
            }
        }
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    @Override
    public KeyStroke readInput() throws IOException {
        return this.terminal.readInput();
    }

    @Override
    public KeyStroke pollInput() throws IOException {
        return this.terminal.pollInput();
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.fullRedrawHint = true;
        this.scrollHint = ScrollHint.INVALID;
    }

    @Override
    public synchronized TerminalSize doResizeIfNecessary() {
        TerminalSize newSize = super.doResizeIfNecessary();
        if (newSize != null) {
            this.fullRedrawHint = true;
        }
        return newSize;
    }

    @Override
    public void scrollLines(int firstLine, int lastLine, int distance) {
        if (distance == 0 || firstLine > lastLine) {
            return;
        }
        super.scrollLines(firstLine, lastLine, distance);
        ScrollHint newHint = new ScrollHint(firstLine, lastLine, distance);
        if (this.scrollHint == null) {
            this.scrollHint = newHint;
        } else if (this.scrollHint != ScrollHint.INVALID) {
            if (this.scrollHint.matches(newHint)) {
                this.scrollHint.distance += newHint.distance;
            } else {
                this.scrollHint = ScrollHint.INVALID;
            }
        }
    }

    private static class ScrollHint {
        public static final ScrollHint INVALID = new ScrollHint(-1, -1, 0);
        public final int firstLine;
        public final int lastLine;
        public int distance;

        public ScrollHint(int firstLine, int lastLine, int distance) {
            this.firstLine = firstLine;
            this.lastLine = lastLine;
            this.distance = distance;
        }

        public boolean matches(ScrollHint other) {
            return this.firstLine == other.firstLine && this.lastLine == other.lastLine;
        }

        public void applyTo(Scrollable scr) throws IOException {
            scr.scrollLines(this.firstLine, this.lastLine, this.distance);
        }
    }

    private static class ScreenPointComparator
    implements Comparator<TerminalPosition> {
        private ScreenPointComparator() {
        }

        @Override
        public int compare(TerminalPosition o1, TerminalPosition o2) {
            if (o1.getRow() == o2.getRow()) {
                if (o1.getColumn() == o2.getColumn()) {
                    return 0;
                }
                return new Integer(o1.getColumn()).compareTo(o2.getColumn());
            }
            return new Integer(o1.getRow()).compareTo(o2.getRow());
        }
    }

    private class TerminalScreenResizeListener
    implements TerminalResizeListener {
        private TerminalScreenResizeListener() {
        }

        @Override
        public void onResized(Terminal terminal, TerminalSize newSize) {
            TerminalScreen.this.addResizeRequest(newSize);
        }
    }
}

