/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.ansi;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.terminal.ansi.UnixLikeTTYTerminal;
import com.googlecode.lanterna.terminal.ansi.UnixLikeTerminal;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CygwinTerminal
extends UnixLikeTTYTerminal {
    private static final String STTY_LOCATION = CygwinTerminal.findProgram("stty.exe");
    private static final Pattern STTY_SIZE_PATTERN = Pattern.compile(".*rows ([0-9]+);.*columns ([0-9]+);.*");

    public CygwinTerminal(InputStream terminalInput, OutputStream terminalOutput, Charset terminalCharset) throws IOException {
        super(null, terminalInput, terminalOutput, terminalCharset, UnixLikeTerminal.CtrlCBehaviour.TRAP);
    }

    @Override
    protected TerminalSize findTerminalSize() throws IOException {
        try {
            String stty = this.runSTTYCommand("-a");
            Matcher matcher = STTY_SIZE_PATTERN.matcher(stty);
            if (matcher.matches()) {
                return new TerminalSize(Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(1)));
            }
            return new TerminalSize(80, 24);
        }
        catch (Throwable e) {
            return new TerminalSize(80, 24);
        }
    }

    @Override
    protected String runSTTYCommand(String ... parameters) throws IOException {
        ArrayList<String> commandLine = new ArrayList<String>(Arrays.asList(this.findSTTY(), "-F", this.getPseudoTerminalDevice()));
        commandLine.addAll(Arrays.asList(parameters));
        return this.exec(commandLine.toArray(new String[commandLine.size()]));
    }

    private String findSTTY() {
        return STTY_LOCATION;
    }

    private String getPseudoTerminalDevice() {
        return "/dev/pty0";
    }

    private static String findProgram(String programName) {
        String[] paths;
        for (String path : paths = System.getProperty("java.library.path").split(";")) {
            File shBin = new File(path, programName);
            if (!shBin.exists()) continue;
            return shBin.getAbsolutePath();
        }
        return programName;
    }
}

